//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *   Derived from kinetd, (C) 2002 by Tim Jansen <tim@tjansen.de>
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "mostrecentlyused.h"
#include <algorithm>
#include <kglobal.h>
#include <kconfig.h>
#include <kdebug.h>

using namespace std;

MostRecentlyUsed::MostRecentlyUsed(QObject *parent) :
    DCOPObject("MRUServices"), QObject(parent)
{
    KConfig *config = KGlobal::config();
    config->setGroup("mruServices");
    QStringList labelList = config->readListEntry("labels");
    QStringList iconList = config->readListEntry("icons");
    QStringList addressList = config->readListEntry("addresses");
    int num = min(min(labelList.count(), iconList.count()),
                  addressList.count());
    for (int n=0; n<num; ++n) {
        MruEntry e;
        e.commandline = config->readListEntry(QString("command%1").arg(n));
        e.deviceaddress = addressList[n];
        e.label = labelList[n];
        e.iconname = iconList[n];
        mruEntries.push_back(e);
    }
    emit updateReceived();
}

MostRecentlyUsed::~MostRecentlyUsed()
{

}

void MostRecentlyUsed::writeConfig() 
{
    KConfig *config = KGlobal::config();
    config->setGroup("mruServices");
    QStringList labelList;
    QStringList iconList;
    QStringList addressList;
    int n = 0;
    for (std::deque<MruEntry>::iterator it = mruEntries.begin(); it != mruEntries.end(); ++it) {
        labelList.append(it->label);
        iconList.append(it->iconname);
        config->writeEntry(QString("command%1").arg(n), it->commandline);
        addressList.append(it->deviceaddress);
        ++n;
    }
    config->writeEntry("labels", labelList);
    config->writeEntry("icons", iconList);
    config->writeEntry("addresses", addressList);
}

void MostRecentlyUsed::mruAdd(QString label, QStringList commandline, 
    QString iconname, QString deviceaddress)
{
    MruEntry e;
    e.commandline = commandline;
    e.deviceaddress = deviceaddress;
    e.label = label;
    e.iconname = iconname;
    if (std::find(mruEntries.begin(), mruEntries.end(), e) == mruEntries.end()) {
        mruEntries.push_front(e);
    }
    emit updateReceived();
}

void MostRecentlyUsed::mruClear()
{
    mruEntries.clear();
    emit updateReceived();
}

bool MostRecentlyUsed::MruEntry::operator==(const MruEntry& other) const
{
    return commandline == other.commandline &&
        iconname == other.iconname &&
        label == other.label &&
        deviceaddress == other.deviceaddress;
}

int MostRecentlyUsed::getNumMru()
{
    return mruEntries.size();
}

QString MostRecentlyUsed::getMruLabel(int n)
{
    if (n < int(mruEntries.size())) {
        return mruEntries[n].label;
    } 
    else {
        return QString::null;
    }
}

QStringList MostRecentlyUsed::getMruCommand(int n)
{
    if (n < int(mruEntries.size())) {
        return mruEntries[n].commandline;
    } 
    else {
        return QString::null;
    }
}

QString MostRecentlyUsed::getMruIcon(int n)
{
    if (n < int(mruEntries.size())) {
        return mruEntries[n].iconname;
    } 
    else {
        return QString::null;
    }
}

QString MostRecentlyUsed::getMruAddress(int n)
{
    if (n < int(mruEntries.size())) {
        return mruEntries[n].deviceaddress;
    } 
    else {
        return QString::null;
    }
}




#include "mostrecentlyused.moc"
