/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUELOCKRC_H
#define KBLUELOCKRC_H

#include <kconfig.h>
#include <kapplication.h>

class kbluelockrc
{

public:
  kbluelockrc();
  ~kbluelockrc();
  static kbluelockrc* getDefaultRC(); // singleton implementation
  void write();

  int getScanInterval() const { return scaninterval; }
  int getValidateBDADDR() const { return validate_bdaddr; }
  int getValidateName() const { return validate_name; }
  int getValidateDeviceType() const { return validate_devtype; }
  QStringList* getDeviceAddresses() { return &dev_addrs; }
  QStringList* getDeviceNames() { return &dev_names; }
  QStringList* getDeviceTypes() { return &dev_types; }

  bool addDevice(const QString &_bdaddr, const QString &_name, const QString &_type);
  bool removeDevice(int _idx);

  void setScanInterval(int _val) { scaninterval = _val; invalidate(); }
  void setValidateBDADDR(int _val) { validate_bdaddr = _val; invalidate(); }
  void setValidateName(int _val) { validate_name = _val; invalidate(); }
  void setValidateDeviceType(int _val){ validate_devtype = _val; invalidate(); }

  int isChanged() const{ return changed; }

private:
  static kbluelockrc* _instance; // singleton pattern instance
  KConfig* config;

  int scaninterval;
  int validate_bdaddr;
  int validate_name;
  int validate_devtype;
  QStringList dev_addrs;
  QStringList dev_names;
  QStringList dev_types;
  int changed;

  void invalidate() { changed = TRUE; }
  void validate() { changed = FALSE; }

};
#endif
