/***************************************************************************
                          irmcsynckonnector.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003-2005 by Simone Gotti
	
	from the threaded konnector of Mathias Froehlich <Mathias.Froehlich@web.de>
	
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IRMCSYNCKONNECTOR_H
#define IRMCSYNCKONNECTOR_H

#include <qiconset.h>
#include <qptrlist.h>

#include <konnector.h>

#include "clientmanager.h"
#include "irmcsyncconfig.h"
#include "device.h"

namespace KSync
{

	/**
	 * This plugin gets loaded by the KonnectorManager
	 * this is the key to the KonnectorWorld
	 * we need to implement the interface to fully support it...
	 */
	class ThreadedPlugin
				: public KSync::Konnector
	{
		Q_OBJECT
	public:
    enum Type { Bluetooth, Serial };

		/**
		 * @param parent the Parent Object
		 * @param name the name
		 * @param strlist a QStringList which is not used but necessary for KGenericFactory
		 */
		ThreadedPlugin( const KConfig *config );
		~ThreadedPlugin();
		
		
		IrMCSyncConfig *mConfigWidget;

		void writeConfig( KConfig *cfg );
		
		SynceeList syncees();

		bool readSyncees();
		bool writeSyncees();

		bool connectDevice();
		bool disconnectDevice();

		/** the state and some information */
		KSync::KonnectorInfo info() const;
    virtual QStringList supportedFilterTypes() const;

    IrMCSyncHelper::Device::Model phoneModel() const { return mPhoneModel; }
    void setPhoneModel( IrMCSyncHelper::Device::Model phoneModel ) { mPhoneModel = phoneModel; }

    Type type() const { return mType; }
    void setType( Type type ) { mType = type; }

    // BlueTooth specific
		void setDeviceBtAddress( const QString &deviceBtAddress ) { mDeviceBtAddress = deviceBtAddress; }
		QString deviceBtAddress() const { return mDeviceBtAddress; }
		
    // Serial specific
    void setDevice( const QString &device ) { mDevicePath = device; }
    QString device() const { return mDevicePath; }

    void setDeviceSpeed( int speed ) { mDeviceSpeed = speed; }
    int deviceSpeed() const { return mDeviceSpeed; }

		void setSyncCalendar( const bool &syncCalendar ) { mSyncCalendar = syncCalendar; }
		bool syncCalendar() const { return mSyncCalendar; };

		void setSyncAddressBook( const bool &syncAddressBook ) { mSyncAddressBook = syncAddressBook; }
		bool syncAddressBook()  const { return mSyncAddressBook; };

    void init();

	private slots:
		void slotSynceeReaded( KSync::Syncee* );
		void slotSynceeWrited();

	private:
    
    IrMCSyncHelper::Device::Model mPhoneModel;
    Type mType;
    
    // BlueTooth specific
		QString mDeviceBtAddress;

    // Serial specific
    QString mDevicePath;
    int mDeviceSpeed;

		bool mSyncCalendar;
		bool mSyncAddressBook;

		int threadsNumber;
		int readedSynceesNumber;
		
		/* The Obex Client */
		Client *mObex;

		/* sync data */
		SynceeList mSyncees;

		ClientManager* mCalendarClientManager;
		ClientManager* mAddressBookClientManager;
	};
} 

#endif
