/*
    This file is part of KitchenSync.

    Copyright (c) 2005 Simone Gotti <simone.gotti@email.it>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KSYNC_DEVICES_H
#define KSYNC_DEVICES_H

#include <qbitarray.h>
#include <qstring.h>
#include <qmap.h>

#include <kstaticdeleter.h>

namespace KSync{
  class Merger;
}

namespace IrMCSyncHelper {
    class Device {
    public:
        enum Model {
            T68i,
            Other
        };
        enum PIM {
            Calendar,
            Addressbook
        };
        Device(enum Model);
        ~Device();
        int model()const;
        void setModel(int mod );

        KSync::Merger* merger( enum PIM );

    private:
        KSync::Merger* T68iCalendarMerger();
        KSync::Merger* T68iAddressBookMerger();

        int m_model;

        KSync::Merger *mABookMerger;
        KSync::Merger *mCalendarMerger;
    };
}


#endif
