/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <qobject.h>

/**
 * This class defines the interface for a controller class
 * to control a specific application.
 * @author Fred Schaettgen
 */
class Controller : public QObject
{
Q_OBJECT
public:
    struct SongInfo {
        unsigned char playState;
        unsigned int length;
        unsigned int currentTime;
        bool shuffle;
        bool repeat;
        QString trackName;
    };

    struct ControllerInfo {
        QString name;
        bool active;
        QString fileExts;
        QString pathToApp;
        QString playlistMgr;
    };

    Controller(QObject *parent);
    ~Controller();

    bool initialCommand;

    bool isActive();
    void setActive(bool a);
    QString launchApp();

    virtual QString name();
    virtual QString fileExts();
    virtual QString pathToApp();
    virtual QString playlistManager();

    virtual void commandDINF(unsigned int &bitrate,
        unsigned int &sampleRate, unsigned int &channels) = 0;
    virtual void commandFADE() = 0;
    virtual void commandFFWD() = 0;
    virtual SongInfo commandINFO() = 0;
    virtual SongInfo commandINF2() = 0;
    virtual void commandLADD(QString filename) = 0;
    virtual void commandNEXT() = 0;
    virtual void commandPAUS() = 0;
    virtual void commandPLAY(QString filename, bool clear = false) = 0;
    virtual QStringList commandPLST(int &curPos, bool useFilenames = false) = 0;
    virtual void commandPREV() = 0;
    virtual void commandREPT(bool repeat) = 0;
    virtual void commandRMAL() = 0;
    virtual void commandRWND() = 0;
    virtual void commandSHFL(bool shuffle) = 0;
    virtual void commandSLCT(Q_UINT16 index) = 0;
    virtual void commandSTEN() = 0;
    virtual void commandSTOP() = 0;
    virtual void commandSTRT() = 0;
    virtual bool commandFULL() = 0;
    virtual void commandSEEK(Q_UINT32 seconds) = 0;
    virtual Q_UINT32 commandPLEN() = 0;
    virtual bool commandGVOL(Q_UINT8 &volume) = 0;
    virtual int currentIndex() = 0;

    /** Sets the volume
     * @arg volume value between 0 and 255
     */
    virtual void commandVOLM(Q_UINT8 volume) = 0;

    // TODO: Create separate PlayList class?
    virtual void loadPlaylist();
    virtual void savePlaylist();

protected:
    ControllerInfo controllerInfo;

};

#endif
