#ifndef ANTISTRING_H
#define ANTISTRING_H

#include <qobject.h>
#include "usergroup.h"
#include <qmap.h>

#include "configuration_aware_object.h"
#include "main_configuration_window.h"

class Protocol;
class QListBox;
class QSpinBox;
class QLineEdit;

class Antistring : public ConfigurationUiHandler, ConfigurationAwareObject
{
	Q_OBJECT

	private:
		QListBox *conditionList;
		QSpinBox *factor;
		QLineEdit *condition;
		QMap<int,QString> conditions1;
		QMap<int,int> conditions;

		int points(QCString& msg);
		void admonish(UserListElements senders);
		void writeLog(UserListElements uin, QString msg);
		void conditionsSave();
		void conditionsRead();
		void updateConditionList();
		void addDefaultConfiguration();

	private slots:
		void addCondition();
		void changeCondition();
		void deleteCondition();
		void wordSelected(int);

	public:
		Antistring();
		~Antistring();
		virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);

	public slots:
		void messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop);

	protected:
		virtual void configurationUpdated();
};

#endif

