#ifndef DCOPEXPORTIFACE_H
#define DCOPEXPORTIFACE_H

#include <dcopobject.h>
#include <qstringlist.h>

/**
 * Interfejs do DCOP niektrych funkcji Kadu
 */
class DCOPExportIface : virtual public DCOPObject
{
	K_DCOP

	k_dcop:
	virtual ASYNC sendMessage (const QString &uin, const QString &message) = 0;
	virtual ASYNC sendMessageWithHistory (const QString &uin, const QString &message) = 0;

	virtual QStringList getGroups () = 0;
	virtual QStringList getUsersInGroup (QString group) = 0;
	virtual QStringList getUserInfo (QString uin) = 0;

	virtual QString description () = 0;
	virtual ASYNC setDescription (QString desc) = 0;

	virtual ASYNC setOnline () = 0;
	virtual ASYNC setOnline (const QString& desc) = 0;
	virtual bool isOnline () = 0;

	virtual ASYNC setBusy () = 0;
	virtual ASYNC setBusy (const QString& desc) = 0;
	virtual bool isBusy () = 0;

	virtual ASYNC setInvisible () = 0;
	virtual ASYNC setInvisible (const QString& desc) = 0;
	virtual bool isInvisible () = 0;

	virtual ASYNC setOffline () = 0;
	virtual ASYNC setOffline (const QString& desc) = 0;
	virtual bool isOffline () = 0;

	virtual ASYNC setFriendsOnly (bool b) = 0;
	virtual bool isFriendsOnly () = 0;

	virtual ASYNC openChat (QString uins) = 0;
	virtual ASYNC openSearchDialog (QString uin) = 0;
	virtual ASYNC showHistory (QString uins) = 0;

	virtual ASYNC openUrl (const QString& url) = 0;

	virtual ASYNC showMessage (QString type, QString text) = 0;
	virtual QStringList getMessageTypes () = 0;

	virtual QString readEntry (const QString &group, const QString &name, const QString &def = QString::null) = 0;
	virtual int readNumEntry (const QString &group, const QString &name, int def = 0) = 0;
	virtual double readDoubleNumEntry (const QString &group, const QString &name, double def = 0.0) = 0;
	virtual bool readBoolEntry (const QString &group, const QString &name, bool def = false) = 0;
	virtual QString passwordHash (const QString &s) = 0;

	virtual ASYNC writeEntry(const QString &group, const QString &name, const QString &value) = 0;
	virtual ASYNC sendFile (const QString &uin, const QString &path) = 0;

	virtual bool exportUserList () = 0;

	virtual bool sendUserSMS (const QString &sender, const QString &altnick, const QString &message) = 0;
	virtual bool sendSMS (const QString &sender, const QString &number, const QString &message) = 0;
	
	virtual ASYNC quit () = 0;
};

#endif // DCOPEXPORTIFACE_H
