/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "formula_widget.h"

#include "debug.h"

const int MimeTeX::FormulaWidget::margin = 5;
const int formulaViewMinWidth = 300;
const int formulaViewMinHeight = 250;

MimeTeX::FormulaWidget::FormulaWidget(QString fileName, QWidget *parent, const char *name)
: QWidget(parent, name)
{
	kdebugf();
	tmpFileName = fileName;
	formulaPixmap.load(tmpFileName);
	resize(width(), height());
	fillView();
	setMinimumSize(formulaViewMinWidth, formulaViewMinHeight);
	setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding));
	kdebugf2();
}

MimeTeX::FormulaWidget::~FormulaWidget()
{
	kdebugf();
	kdebugf();
}

void MimeTeX::FormulaWidget::cleanView()
{
	kdebugf();
	QPixmap::setDefaultOptimization(QPixmap::MemoryOptim);
	cleanPixmap.resize(width(), height());
	cleanPixmap.fill(Qt::white);
	bitBlt(this, 0, 0, &cleanPixmap, 0, 0, -1, -1, Qt::CopyROP, FALSE);
	kdebugf2();
}

void MimeTeX::FormulaWidget::fillView()
{
	kdebugf();
	const int formulaViewMinWidth = 300;
	const int formulaViewMinHeight = 250;
	cleanView();
	formulaPixmap.fill(Qt::white);
	formulaPixmap.load(tmpFileName);
	kdebugm(KDEBUG_INFO, "width()=%d, height=%d\n", formulaPixmap.width(), formulaPixmap.height());
	if(formulaPixmap.width() > formulaViewMinWidth)
	{
		kdebugm(KDEBUG_INFO, "Zmieniam szerokosc formulaView na %d\n", formulaPixmap.width());
		setMinimumWidth(formulaPixmap.width() + 2 * margin);
	}
	if(formulaPixmap.height() > formulaViewMinHeight)
	{
		kdebugm(KDEBUG_INFO, "Zmieniam wysokosc formulaView na %d\n", formulaPixmap.height());
		setMinimumHeight(formulaPixmap.height() + 2 * margin);
	}
	bitBlt(this, margin, margin, &formulaPixmap, 0, 0, -1, -1, Qt::CopyROP, FALSE);
	kdebugf2();
}

void MimeTeX::FormulaWidget::paintEvent (QPaintEvent *paintEvent)
{
	kdebugf();
	fillView();
	kdebugf2();
}
