/*  Simple bitmap font rendering example.
 *
 *  font.h
 *
 *  Inti Translation of the GtkGLExt bitmap font rendering example
 *  written by Naofumi Yasufuku <naofumi@users.sourceforge.net>.
 */

#include <inti/main.h>
#include <inti/core.h>
#include <inti/gdk/gl/config.h>
#include <inti/gtk/gl/drawingarea.h>

using namespace Inti;

/*  GLDrawingArea
 */

class GLDrawingArea : public Gtk::GL::DrawingArea
{
	unsigned int font_list_base;
	int font_height;

	static void examine_attrib(Gdk::GL::Config& glconfig);
	static void print_attrib(Gdk::GL::Config& glconfig, const char *attrib_str, int attrib, bool is_boolean);

protected:
	virtual void on_realize();
	virtual bool on_configure_event(const Gdk::EventConfigure& event);
	virtual bool on_expose_event(const Gdk::EventExpose& event);

public:
	GLDrawingArea(Gdk::GL::Config *glconfig);
	virtual ~GLDrawingArea();
};

/* Window
 */

class Window : public Gtk::Window
{
public:
	Window(Gdk::GL::Config *glconfig);
	virtual ~Window();
};

