/* intparse.h - Functions to parse integers from strings.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <sys/types.h>
#include <stdint.h>
#include "common.h"

bool parse_int8(const char *instr, int8_t *outint);
bool parse_int16(const char *instr, int16_t *outint);
bool parse_int32(const char *instr, int32_t *outint);
bool parse_int64(const char *instr, int64_t *outint);

bool parse_uint8(const char *instr, uint8_t *outint);
bool parse_uint16(const char *instr, uint16_t *outint);
bool parse_uint32(const char *instr, uint32_t *outint);
bool parse_uint64(const char *instr, uint64_t *outint);
