#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __htmlh__
  #include "../html.h"
#endif
#ifndef __parammaph__
  #include "../parammap.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __tables_entitiesh__
  #include "../tables/entities.h"
#endif
#include "../fdstream.h"

using namespace std;

#include <fstream>
#include <cstdio>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
//#include <ghttp.h>

class dsoNotifyMod :public Plugin{
public:
  dsoNotifyMod();
  virtual void Init();
  static HTMLStream::iterator EMAIL(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
  //static HTMLStream::iterator SMS(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
};

static dsoNotifyMod initmodule;

dsoNotifyMod::dsoNotifyMod() {
  RegisterPlugin("notify",1);
};

void dsoNotifyMod::Init() {
  SetNamespace("NOTIFY");
  RegisterCommand("EMAIL",&EMAIL);
  //RegisterCommand("SMS",&SMS);
}

HTMLStream::iterator dsoNotifyMod::EMAIL(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  string from,to,subject,message;
  if (!paramMap.Retrieve("TO",to)) {
    Error(*Cur,"Recipient must be named in TO value");
  }
  if (!paramMap.Retrieve("MESSAGE",message)) {
    Error(*Cur,"No MESSAGE specified - nothing to send");
  }
  paramMap.Retrieve("FROM",from);
  paramMap.Retrieve("SUBJECT",subject);
  if ((!from.empty() && (from[0]=='-')) || to.empty() || to[0]=='-') {
    Error(*Cur,"FROM or TO are invalid. Rejected");
  }
  int pipedes[2];
  pipe(pipedes);
  if (fork()==0) {
    dup2(pipedes[0],STDIN_FILENO);
    if (!from.empty()) {
      from="-f"+from;
      execl("/usr/lib/sendmail","hitop-notify",from.c_str(),to.c_str(),NULL);
    } else {
      execl("/usr/lib/sendmail","hitop-notify",to.c_str(),NULL);
    }
  }
  fdostream sendmail(pipedes[1]);
  message=Entities::Unescape(message);
  if (!subject.empty()) {
    sendmail << "Subject: "<<subject<<endl<<endl;
  }
  HTMLStream::Slice(sendmail,message);
  sendmail<<endl<<"."<<endl;
  wait(NULL);
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}

/*HTMLStream::iterator dsoNotifyMod::SMS(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  string to,message,host,port,username,password;
  if (!paramMap.Retrieve("TO",to)) {
    Error(*Cur,"Recipient must be named in TO value");
  }
  if (!paramMap.Retrieve("MESSAGE",message)) {
    Error(*Cur,"No MESSAGE specified - nothing to send");
  }
  if (!paramMap.Retrieve("GATEWAY",host)) {
    Error(*Cur,"The sms GATEWAY host must be defined");
  }
  if (!paramMap.Retrieve("PORT",port)) {
    Error(*Cur,"The sms gateway PORT must be defined");
  }
  if (!paramMap.Retrieve("USERNAME",username)) {
    Error(*Cur,"The sms gateway USERNAME must be defined");
  }
  if (!paramMap.Retrieve("PASSWORD",password)) {
    Error(*Cur,"The sms gateway PASSWORD must be defined");
  }
  if (to.empty() || message.empty()) {
    Error(*Cur,"Either TO or MESSAGE was empty. Unable to send");
  }
  for (string::iterator i=to.begin(); i!=to.end(); ++i) {
    if (!isdigit(*i)) Error(*Cur,"TO must be a valid MSISDN - numbers only, including international code (eg 447xxxxxxxxx)");
  }
  username=escape(username);
  password=escape(password);
  to=escape(to);
  message=Entities::Unescape(message);
  message=escape(message);
  string URL = "http:/" "/"+host+":"+port+"/cgi-bin/sendsms?username="+username+"&password="+password+"&to="+to+"&text="+message;
  ghttp_request* req=ghttp_request_new();
  if (-1==ghttp_set_uri(req, const_cast<char*>(URL.c_str()))) {
    Error(*Cur,"Invalid SMS Request");
  }
  ghttp_set_type(req, ghttp_type_get);
  if (-1==ghttp_prepare(req)) {
      Error(*Cur,"Invalid SMS Request");
  }
  ghttp_process(req);
  ghttp_request_destroy(req);
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}*/


