#ifndef __parammaph__
#define __parammaph__

#ifndef __tokenmaph__
  #include "tokenmap.h"
#endif

#include <map>
#include <string>

class ParamMap:public map<string,string>{
public:
  inline bool Defined(const string& name)const{return find(name)!=end();}
  inline bool Retrieve(const string& name,string& value)const{
    const_iterator pos;
    if((pos=find(name))==end()) return false;
    value=pos->second;
    return true;
  }
  inline bool Test(const string& name)const{
    return(find(name)!=end());
  }
  inline bool RetrieveToken(const string& name,TokenMap::Token& value)const{
    string temp;
    if(!Retrieve(name,temp)){
      value=-1;
      return false;
    }
    value=TokenMap::NameToTokenNum(temp);
    return true;
  }
  inline bool RetrieveNum(const string& name,int& value)const{
    const_iterator pos;
    if((pos=find(name))==end()) return false;
    value=atoi(pos->second.c_str());
    return true;
  }
};

#endif
