//$Id: widget-combo.cc,v 1.7 2001/11/06 12:54:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu;
using std::string;
using std::set;
using std::vector;

GUI::WidgetCombo::WidgetCombo (Resources::Form       *form_,
			       Widgets::Type          type_,
			       Properties::WidgetRef &property_):
    Gtk::HBox (false, 5),
    form (form_),
    button_edit (_("Edit...")),
    type (type_),
    property (property_)
{
    combo.set_value_in_list (true, true);
    combo.set_use_arrows (true);
    combo.set_case_sensitive (false);
    combo.get_entry ()->set_editable (false);
    
    set<Widgets::Widget*> widget_set = form->get_widgets ();

    Gtk::ListItem *item = new Gtk::ListItem ("");
    item->set_user_data (0);
    item->show ();
    combo.get_list ()->add (*manage (item));
    for (set<Widgets::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	add_widget ((*i));

    button_edit.clicked.connect (slot (this, &WidgetCombo::edit_cb));

    form->widget_created.connect (slot (this, &WidgetCombo::add_widget));
    form->widget_removed.connect (slot (this, &WidgetCombo::remove_widget));

    combo.get_entry ()->changed.connect (slot (this, &WidgetCombo::entry_cb));
    
    pack_start (combo);
    pack_start (button_edit);

    property.changed.connect (slot (this, &WidgetCombo::update));
    update ();
}

void GUI::WidgetCombo::add_widget (Widgets::Widget *widget)
{
    if (widget->get_type () != type)
	return;
    
    update_block = true;

    Gtk::ListItem *item = new Gtk::ListItem (widget->id ());
    item->set_user_data (widget);
    item->show ();
    combo.get_list ()->add (*manage (item));

    widget->changed.connect (bind (slot (this, &WidgetCombo::widget_changed_cb),
				   widget));
    
    update_block = false;
}

void GUI::WidgetCombo::remove_widget (Widgets::Widget *widget)
{
    if (widget->get_type () != type)
	return;
    
    update_block = true;
    
    Gtk::List::ItemList listitems = combo.get_list ()->items ();
    for (Gtk::List::ItemList::iterator i = listitems.begin ();
         i != listitems.end (); i++)
    {
        if ((*i)->get_user_data () == widget)
            i = listitems.erase (i);
    }
    
    update_block = false;
}

void GUI::WidgetCombo::update ()
{
    update_block = true;
    
    combo.get_entry ()->set_text (property);
    
    update_block = false;
}

void GUI::WidgetCombo::edit_cb ()
{
    Widgets::Widget *widget = form->get_widget (property);
    g_return_if_fail (widget != 0);
    
    set<Widgets::Widget*> widget_set = form->get_widgets ();
    for (set<Widgets::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	(*i)->selected (false);
    
    widget->selected (true);
    widget->request_edit ();
}

void GUI::WidgetCombo::entry_cb ()
{
    if (!update_block)
    {
	property = combo.get_entry ()->get_text ();
    }
    
    if (property != "")
	button_edit.set_sensitive (true);
    else
	button_edit.set_sensitive (false);
}

void GUI::WidgetCombo::widget_changed_cb (Widgets::Widget *widget)
{
    update_block = true;

    using namespace Gtk::List_Helpers;

    ItemList& itemlist = combo.get_list ()->items ();
    ItemList::iterator i = itemlist.begin ();
    while (i != itemlist.end () && (*i)->get_user_data () != widget)
	i++;
    g_return_if_fail (i != itemlist.end ());
    
    (*i)->remove ();
    (*i)->add_label (widget->id);
    
    update_block = false;
}
