//$Id: form-win-helpers.cc,v 1.8 2001/11/18 10:59:50 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-win-helpers.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/box.h>
#include <gtk--/pixmap.h>
#include <gnome--/app-helper.h>
#include <libgnomeui/gnome-stock.h>

#include <list>

#include "form-editor/widget-util.h"

namespace {
#include "pixmaps/form.xpm"
}

using namespace Guikachu::GUI::FormWindow_Helpers;

/***********************************
 * WidgetTreeItem
 ***********************************/

WidgetTreeItem::WidgetTreeItem (Widgets::Widget *widget_):
    widget (widget_)
{
    using namespace Gnome;

    Gtk::Pixmap *pixmap = new Gtk::Pixmap (Widgets::type_icon (widget->get_type ()));
    Gtk::Box    *box    = new Gtk::HBox   (false, 5);

    label.set_alignment (0, 0.5);
    box->pack_start (*manage (pixmap), false);
    box->pack_start (label);
    box->show_all ();    
    add (*manage (box));

    set_user_data (widget);

    std::list <UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_TRASH),
		  _("Remove"), menu_remove.slot ()));
    UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));
    
    button_press_event.connect (slot (this, &WidgetTreeItem::button_press_cb));
    
    widget->selected.connect (slot (this, &WidgetTreeItem::widget_selected_cb));
    widget->changed.connect  (slot (this, &WidgetTreeItem::update));
    update ();
}

void WidgetTreeItem::update ()
{
    label.set_text (widget->id ());
}

int WidgetTreeItem::button_press_cb (GdkEventButton *e)
{
    if (e->type == GDK_BUTTON_PRESS && e->button == 1)
	activate ();
    
    if (e->button == 3)
	popup_menu.popup (e->button, e->time);
    
    return false;
}

void WidgetTreeItem::widget_selected_cb (bool selected)
{
    if (selected)
	select ();
    else
	deselect ();
}

/***********************************
 * TopTreeItem
 ***********************************/

TopTreeItem::TopTreeItem (Resources::Form *res_):
    res (res_)
{
    Gtk::Pixmap *pixmap = new Gtk::Pixmap (form_xpm);
    Gtk::Box    *box    = new Gtk::HBox   (false, 5);

    label.set_alignment (0, 0.5);
    box->pack_start (*manage (pixmap), false);
    box->pack_start (label);
    box->show_all ();
    add (*manage (box));
    
    set_user_data (res);
    
    res->changed.connect (slot (this, &TopTreeItem::update));
    button_press_event.connect (slot (this, &TopTreeItem::button_press_cb));

    update ();
}

void TopTreeItem::update ()
{
    label.set_text (res->id);
}

int TopTreeItem::button_press_cb (GdkEventButton *e)
{
    if (e->type == GDK_BUTTON_PRESS && e->button == 1)
	activate ();
    
    return false;
}
