//$Id: form-res.cc,v 1.27 2001/11/06 12:54:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-res.h"
#include "form-win.h"

#include "form-editor/widget.h"
#include "form-editor/widget-util.h"

#include "form-editor/label.h"
#include "form-editor/button.h"
#include "form-editor/pushbutton.h"
#include "form-editor/graffiti.h"
#include "form-editor/selector-trigger.h"
#include "form-editor/checkbox.h"
#include "form-editor/list.h"
#include "form-editor/popup-trigger.h"
#include "form-editor/scrollbar.h"
#include "form-editor/text-field.h"
#include "form-editor/table.h"
#include "form-editor/gadget.h"

using namespace Guikachu::Resources;
using namespace Guikachu;

Form::Form (const std::string& id):
    Resource (id),
    gui (0),
    title (changed, id),
    help_id (changed),
    menu_id (changed),
    modal (changed, false),
    frame (changed, true),
    savebehind (changed, true),
    def_button (changed, this),
    x (changed),
    y (changed),
    width (changed, 160),
    height (changed, 160)
{
}

Form::~Form ()
{
    for (std::set<Widgets::Widget*>::iterator i = widgets.begin ();
	 i != widgets.end (); i++)
    {
	ResourceManager::unregister_id ((*i)->id);
	delete (*i);
	widgets.erase (i);
    }
    
    delete gui;
}

void Form::show_ui ()
{
    if (!gui)
	gui = new GUI::FormWindow (this);

    gui->show ();
}

Widgets::Widget* Form::create_widget (Widgets::Type type,
				      std::string   id = "")
{
    id = ResourceManager::validate_id (id);
    
    if (id == "")
	id = ResourceManager::create_id (Widgets::type_id_from_type (type));
    
    if (!ResourceManager::register_id (id))
	return 0;
	
    Widgets::Widget *widget = 0;

    switch (type)
    {
    case Widgets::WIDGET_LABEL:
	widget = new Widgets::Label (this, id);
	break;
    case Widgets::WIDGET_BUTTON:
	widget = new Widgets::Button (this, id);
	break;
    case Widgets::WIDGET_PUSHBUTTON:
	widget = new Widgets::PushButton (this, id);
	break;
    case Widgets::WIDGET_GRAFFITI:
	widget = new Widgets::Graffiti (this, id);
	break;
    case Widgets::WIDGET_SELECTOR_TRIGGER:
	widget = new Widgets::SelectorTrigger (this, id);
	break;
    case Widgets::WIDGET_CHECKBOX:
	widget = new Widgets::Checkbox (this, id);
	break;
    case Widgets::WIDGET_LIST:
	widget = new Widgets::List (this, id);
	break;
    case Widgets::WIDGET_POPUP_TRIGGER:
	widget = new Widgets::PopupTrigger (this, id);
	break;
    case Widgets::WIDGET_SCROLLBAR:
	widget = new Widgets::ScrollBar (this, id);
	break;
    case Widgets::WIDGET_TEXT_FIELD:
	widget = new Widgets::TextField (this, id);
	break;
    case Widgets::WIDGET_TABLE:
	widget = new Widgets::Table (this, id);
	break;
    case Widgets::WIDGET_GADGET:
	widget = new Widgets::Gadget (this, id);
	break;
    case Widgets::WIDGET_NONE:
    default:
	g_assert_not_reached ();
	return 0;
	break;
    }
    
    widgets.insert (widget);
    widget->changed.connect (widget_changed.slot());
    
    widget_created (widget);

    changed ();
    
    return widget;
}

void Form::remove_widget (Widgets::Widget *widget)
{
    widget_removed.emit (widget);

    widgets.erase (widget);
    ResourceManager::unregister_id (widget->id);
    
    delete widget;

    changed ();
}

Widgets::Widget* Form::get_widget (const std::string& id) const
{
    std::set<Widgets::Widget*>::const_iterator found;

    found = widgets.begin ();
    while (found != widgets.end () && (*found)->id != id)
	found++;

    if (found == widgets.end ())
	return 0;
    else
	return (*found);
}
