//$Id: widget-prop.cc,v 1.1 2001/08/19 15:02:33 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/pos-entry.h"

using namespace Guikachu::GUI::FormEditor;

void WidgetProperties::add_position_controls (Widgets::Widget     *res,
					      GUI::PropertyTable &proptable)
{
    Gtk::Widget *control;

    /* X */
    control = new GUI::PosEntry (res->x);
    proptable.add (_("_X:"), *manage (control),
		   _("Horizontal position of the widget, relative "
		     "to the parent form"));

    /* Y */
    control = new GUI::PosEntry (res->y);
    proptable.add (_("_Y:"), *manage (control),
		   _("Vertical position of the widget, relative "
		     "to the parent form"));

}

void WidgetProperties::add_general_controls (Widgets::Widget    *res,
					     GUI::PropertyTable &proptable)
{
    Gtk::Widget *control;

    /* Resource ID */
    control = new GUI::Entry (false, res->id);
    proptable.add (_("Resource _ID:"), *manage (control));
}
