/* GStreamer x264 plugin
 * Copyright (C) 2005 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_X264ENC_H__
#define __GST_X264ENC_H__

#include <gst/gst.h>
#include "_stdint.h"
#include <x264.h>

GST_DEBUG_CATEGORY_EXTERN (x264_debug);
#define GST_CAT_DEFAULT x264_debug

#define GST_TYPE_X264ENC \
  (gst_x264enc_get_type ())
#define GST_X264ENC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GST_TYPE_X264ENC, GstX264Enc))

typedef struct _GstX264Enc {
  GstElement parent;

  /* pads */
  GstPad *srcpad, *sinkpad;

  /* x264 objects */
  x264_t *ctx;
  x264_param_t params;
  gdouble fps;
  gboolean resync;
} GstX264Enc;

typedef struct _GstX264EncClass {
  GstElementClass parent_class;
} GstX264EncClass;

GType	gst_x264enc_get_type	(void);

#endif /* __GST_X264ENC_H__ */
