/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _POCKET_H_
#define _POCKET_H_

#include <list>

#include <gtk/gtk.h>

#include "ball.h"
#include "element.h"

class Pocket : public Element {
protected:
   GtkWidget*	_table;
   Element*	_element;
   Ball* 	_ball;
 
   GdkBitmap*	_mask;
   GdkPixmap*	_red_pixmap;
   GdkPixmap* 	_green_pixmap;
   GdkPixmap*  	_blue_pixmap;
   GdkPixmap*  	_yellow_pixmap;
   GtkWidget*  	_pixmapwid;   

   bool Contains(Ball::Color color);
   void InsertInTable(int row, int col, GdkPixmap* pixmap);
   GdkPixmap* CreateFromXpm(char** data);
public:
   Pocket(GtkWidget* table);
   virtual void ConnectLeft(Element* element) {}
   virtual void ConnectTop(Element* element) {}
   virtual void ConnectRight(Element* element) {}
   virtual void ConnectBottom(Element* element) {}
   void PutBall(Ball* ball);
   virtual void MoveBall(Ball* ball) = 0;
   virtual void Eject() = 0;
   virtual bool HasRightBall() = 0;
};

class SetOffPockets {
   std::list<Pocket*> _set;
public:
   SetOffPockets() {}
   void Add(Pocket* pocket) {_set.push_back(pocket);}
   void MakeEmpty() {_set.erase(_set.begin(), _set.end());}
   void Eject();
   bool HasRightBalls();
};

class LeftPocket : public Pocket {
public:
   LeftPocket(GtkWidget* table, int row, int col);
   void ConnectRight(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Red);}
   void MoveBall(Ball* ball);
};

class UpperPocket : public Pocket {
public:
   UpperPocket(GtkWidget* table, int row, int col);
   void ConnectBottom(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Green);}
   void MoveBall(Ball* ball);
};

class RightPocket : public Pocket {
public:
   RightPocket(GtkWidget* table, int row, int col);
   void ConnectLeft(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Blue);}
   void MoveBall(Ball* ball);
};

class LowerPocket : public Pocket {
public:
   LowerPocket(GtkWidget* table, int row, int col);
   void ConnectTop(Element* element) {_element = element;}
   void Eject();
   bool HasRightBall() {return Contains(Ball::Yellow);}
   void MoveBall(Ball* ball);
};

#endif // _POCKET_H_
