/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <pwd.h>
#include <unistd.h>

#include "game.h"
#include "intl.h"
#include "new_highscore_dialog.h"

#include "pixmaps/champagne.xpm"

NewHighScoreDialog::NewHighScoreDialog(Game* game) : 
   Dialog(_("New Highscore")), _game(game)
{
   GtkWidget* table = gtk_table_new(2, 2, FALSE);
   gtk_container_border_width(GTK_CONTAINER(table), 10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->vbox), table, TRUE, TRUE, 
		      10);
   gtk_table_set_row_spacings(GTK_TABLE(table), 10);
   gtk_table_set_col_spacings(GTK_TABLE(table), 5);
   gtk_widget_show(table);

   // Create champagne icon.
   GtkStyle* style = gtk_widget_get_style(table);
   GdkBitmap* mask;
   GdkPixmap* data = gdk_pixmap_colormap_create_from_xpm_d(
      table->window, gtk_widget_get_colormap(table), &mask,
      &style->bg[GTK_STATE_NORMAL], champagne_xpm);
   GtkWidget* champagne = gtk_pixmap_new(data, mask);

   gtk_widget_show(champagne);
   gtk_table_attach_defaults(GTK_TABLE(table), champagne, 0, 1, 0, 1);

   GtkWidget* label = gtk_label_new(_("Congratulations, a new highscore!"));
   gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 2, 0, 1);
   gtk_widget_show(label);

   GtkWidget* name_label = gtk_label_new(_("Name:"));
   gtk_table_attach_defaults(GTK_TABLE(table), name_label, 0, 1, 1, 2);
   gtk_widget_show(name_label);

   _name = gtk_entry_new();
   gtk_table_attach_defaults(GTK_TABLE(table), _name, 1, 2, 1, 2);
   gtk_widget_show(_name);
}

void
NewHighScoreDialog::OnOk()
{
   _game->AddHighScore(gtk_entry_get_text(GTK_ENTRY(_name)));
   _game->ShowHighScore();
}

char*
NewHighScoreDialog::GetLoginName()
{
   char* login_name;
   if (!(login_name = getenv("LOGNAME"))
       && !(login_name = getlogin())
       && !(login_name = getenv("USER"))) {
      struct passwd * passwd_entry = getpwuid(getuid());
      if (!passwd_entry) passwd_entry = getpwuid(geteuid());
      login_name = passwd_entry ? passwd_entry->pw_name : (char*) "nobody";
   }
   return login_name;
}

std::string
NewHighScoreDialog::GetUserName()
{
   char* login_name = GetLoginName();
   struct passwd* passwd_entry = login_name ? getpwnam(login_name) : 0;
   std::string gecos_field = (passwd_entry && passwd_entry->pw_gecos)
      ? passwd_entry->pw_gecos : (login_name ? login_name : "Anonymous");
   
   size_t pos = gecos_field.find(',');
   return (pos == std::string::npos) 
      ? gecos_field : gecos_field.substr(0, pos);
}

void
NewHighScoreDialog::DoDialog()
{
   std::string user_name = GetUserName();
   gtk_entry_set_text(GTK_ENTRY(_name), user_name.c_str());
   Dialog::DoDialog();
   gtk_widget_grab_focus(_name);
}
