/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <iostream.h>

#include "dialog.h"
#include "intl.h"

gint 
Dialog::DeleteCB(GtkWidget *widget, GdkEvent *event, gpointer data)
{
   ((Dialog*) data)->OnCancel();
   return TRUE;
}

Dialog::Dialog(const char* title)
{
   _window = gtk_dialog_new();
   gtk_window_set_title(GTK_WINDOW(_window), title);

   // Ok button
   GtkWidget* button = gtk_button_new_with_label(_("Ok"));
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC(Dialog::OkCB), this);
   gtk_signal_connect(GTK_OBJECT(_window), "delete_event",
		      GTK_SIGNAL_FUNC(Dialog::DeleteCB), this);

   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->action_area), button, TRUE,
		      TRUE, 0);
   gtk_widget_grab_default(button);
   gtk_widget_show(button);
}

void
Dialog::OnCancel()
{
   gtk_widget_hide(_window);
}

void
Dialog::OkCB(GtkWidget *widget, gpointer data)
{
   Dialog* dialog = (Dialog*) data;
   gtk_widget_hide(dialog->_window);
   dialog->OnOk();
}

void
Dialog::CancelCB(GtkWidget *widget, gpointer data)
{
   ((Dialog*) data)->OnCancel();
}

void
Dialog::AddCancelButton()
{
   GtkWidget* button = gtk_button_new_with_label(_("Cancel"));
   gtk_signal_connect(GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC(Dialog::CancelCB), (gpointer) this);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->action_area), button, TRUE,
		      TRUE, 0);
   gtk_widget_show(button);
}





