/* nibbles-game.c generated by valac 0.40.8, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <string.h>


#define TYPE_GAME_STATUS (game_status_get_type ())

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
enum  {
	NIBBLES_GAME_0_PROPERTY,
	NIBBLES_GAME_START_LEVEL_PROPERTY,
	NIBBLES_GAME_CURRENT_LEVEL_PROPERTY,
	NIBBLES_GAME_SPEED_PROPERTY,
	NIBBLES_GAME_TILE_SIZE_PROPERTY,
	NIBBLES_GAME_NUMHUMANS_PROPERTY,
	NIBBLES_GAME_NUMAI_PROPERTY,
	NIBBLES_GAME_NUMWORMS_PROPERTY,
	NIBBLES_GAME_WORMS_PROPERTY,
	NIBBLES_GAME_BONI_PROPERTY,
	NIBBLES_GAME_WARP_MANAGER_PROPERTY,
	NIBBLES_GAME_WORM_PROPS_PROPERTY,
	NIBBLES_GAME_IS_RUNNING_PROPERTY,
	NIBBLES_GAME_IS_PAUSED_PROPERTY,
	NIBBLES_GAME_FAKES_PROPERTY,
	NIBBLES_GAME_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_properties[NIBBLES_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef struct _BoniPrivate BoniPrivate;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
enum  {
	NIBBLES_GAME_WORM_MOVED_SIGNAL,
	NIBBLES_GAME_BONUS_APPLIED_SIGNAL,
	NIBBLES_GAME_LOG_SCORE_SIGNAL,
	NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL,
	NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL,
	NIBBLES_GAME_NUM_SIGNALS
};
static guint nibbles_game_signals[NIBBLES_GAME_NUM_SIGNALS] = {0};

typedef enum  {
	GAME_STATUS_GAMEOVER,
	GAME_STATUS_VICTORY,
	GAME_STATUS_NEWROUND
} GameStatus;

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _NibblesGamePrivate {
	gint _start_level;
	gint _current_level;
	gint _speed;
	gint _tile_size;
	gint _numhumans;
	gint _numai;
	gint _numworms;
	GeeLinkedList* _worms;
	Boni* _boni;
	WarpManager* _warp_manager;
	GeeHashMap* _worm_props;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	guint add_bonus_id;
	gboolean _fakes;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};


static gpointer nibbles_game_parent_class = NULL;

GType game_status_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType boni_get_type (void) G_GNUC_CONST;
GType warp_manager_get_type (void) G_GNUC_CONST;
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
#define NIBBLES_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_GAME, NibblesGamePrivate))
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_GAMEDELAY 35
#define NIBBLES_GAME_BONUSDELAY 100
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_AI 5
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_MAX_SPEED 4
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WORMCHAR 'w'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type,
                                     GSettings* settings);
gint nibbles_game_get_numworms (NibblesGame* self);
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type,
                      gint numworms);
static void nibbles_game_set_boni (NibblesGame* self,
                            Boni* value);
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
static void nibbles_game_set_warp_manager (NibblesGame* self,
                                    WarpManager* value);
static void nibbles_game_set_worms (NibblesGame* self,
                             GeeLinkedList* value);
static void nibbles_game_set_worm_props (NibblesGame* self,
                                  GeeHashMap* value);
static void nibbles_game_set_is_paused (NibblesGame* self,
                                 gboolean value);
void nibbles_game_load_properties (NibblesGame* self,
                                   GSettings* settings);
gint nibbles_game_get_start_level (NibblesGame* self);
static void nibbles_game_set_current_level (NibblesGame* self,
                                     gint value);
void nibbles_game_start (NibblesGame* self);
static void nibbles_game_set_is_running (NibblesGame* self,
                                  gboolean value);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self);
gboolean nibbles_game_add_bonus_cb (NibblesGame* self);
static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self);
void nibbles_game_stop (NibblesGame* self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_reset (NibblesGame* self);
static void nibbles_game_end (NibblesGame* self);
GameStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _game_status_equal (const GameStatus * s1,
                             const GameStatus * s2);
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
gint worm_get_score (Worm* self);
gint nibbles_game_get_current_level (NibblesGame* self);
Worm* nibbles_game_get_winner (NibblesGame* self);
void nibbles_game_move_worms (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self,
                                gint value);
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type,
                      gint id);
void nibbles_game_bonus_found_cb (NibblesGame* self,
                                  Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                                    gpointer self);
void nibbles_game_warp_found_cb (NibblesGame* self,
                                 Worm* worm);
static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender,
                                                  gpointer self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void nibbles_game_add_worms (NibblesGame* self);
void worm_spawn (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
Boni* nibbles_game_get_boni (NibblesGame* self);
GType bonus_get_type (void) G_GNUC_CONST;
#define BONI_MAX_MISSED 2
void worm_set_score (Worm* self,
                     gint value);
GType bonus_type_get_type (void) G_GNUC_CONST;
void boni_remove_bonus (Boni* self,
                        gint* board,
                        int board_length1,
                        int board_length2,
                        Bonus* bonus);
void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_ai_move (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2,
                   gint numworms,
                   GeeLinkedList* worms);
gboolean worm_will_collide_with_head (Worm* self,
                                      Worm* other_worm);
gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           int board_length1,
                           int board_length2,
                           gint numworms);
void worm_move (Worm* self,
                gint* board,
                int board_length1,
                int board_length2);
gint worm_get_lives (Worm* self);
void worm_reset (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
static void nibbles_game_reverse_worms (NibblesGame* self,
                                 Worm* worm);
void worm_reverse (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2);
gboolean nibbles_game_get_fakes (NibblesGame* self);
void boni_add_bonus (Boni* self,
                     gint* board,
                     int board_length1,
                     int board_length2,
                     gint x,
                     gint y,
                     BonusType type,
                     gboolean fake,
                     gint countdown);
void nibbles_game_apply_bonus (NibblesGame* self,
                               Bonus* bonus,
                               Worm* worm);
void worm_get_head (Worm* self,
                    Position * result);
#define WORM_GROW_FACTOR 4
gint worm_get_length (Worm* self);
void worm_reduce_tail (Worm* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint erase_size);
void worm_add_life (Worm* self);
Bonus* boni_get_bonus (Boni* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint x,
                       gint y);
GType warp_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
Warp* warp_manager_get_warp (WarpManager* self,
                             gint x,
                             gint y);
void worm_warp (Worm* self,
                Warp* warp);
static GameStatus* _game_status_dup (GameStatus* self);
void nibbles_game_set_tile_size (NibblesGame* self,
                                 gint value);
static void nibbles_game_set_start_level (NibblesGame* self,
                                   gint value);
void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
void nibbles_game_save_properties (NibblesGame* self,
                                   GSettings* settings);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gint worm_get_id (Worm* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval);
gboolean nibbles_game_get_is_running (NibblesGame* self);
gboolean worm_handle_keypress (Worm* self,
                               guint keyval,
                               GeeHashMap* worm_props);
void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void nibbles_game_finalize (GObject * obj);
static void _vala_nibbles_game_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);


GType
game_status_get_type (void)
{
	static volatile gsize game_status_type_id__volatile = 0;
	if (g_once_init_enter (&game_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_STATUS_GAMEOVER, "GAME_STATUS_GAMEOVER", "gameover"}, {GAME_STATUS_VICTORY, "GAME_STATUS_VICTORY", "victory"}, {GAME_STATUS_NEWROUND, "GAME_STATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
		GType game_status_type_id;
		game_status_type_id = g_enum_register_static ("GameStatus", values);
		g_once_init_leave (&game_status_type_id__volatile, game_status_type_id);
	}
	return game_status_type_id__volatile;
}


NibblesGame*
nibbles_game_construct (GType object_type,
                        GSettings* settings)
{
	NibblesGame * self = NULL;
	gint _tmp0_;
	Boni* _tmp1_;
	Boni* _tmp2_;
	WarpManager* _tmp3_;
	WarpManager* _tmp4_;
	gint* _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	time_t _tmp10_;
	gint _tmp11_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (NibblesGame*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_numworms;
	_tmp1_ = boni_new (_tmp0_);
	_tmp2_ = _tmp1_;
	nibbles_game_set_boni (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = warp_manager_new ();
	_tmp4_ = _tmp3_;
	nibbles_game_set_warp_manager (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_new0 (gint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
	self->board = (g_free (self->board), NULL);
	self->board = _tmp5_;
	self->board_length1 = NIBBLES_GAME_WIDTH;
	self->board_length2 = NIBBLES_GAME_HEIGHT;
	_tmp6_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp7_ = _tmp6_;
	nibbles_game_set_worms (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) worm_properties_dup, (GDestroyNotify) worm_properties_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp9_ = _tmp8_;
	nibbles_game_set_worm_props (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	nibbles_game_set_is_paused (self, FALSE);
	_tmp10_ = time (NULL);
	g_random_set_seed ((guint32) _tmp10_);
	nibbles_game_load_properties (self, settings);
	_tmp11_ = self->priv->_start_level;
	nibbles_game_set_current_level (self, _tmp11_);
	return self;
}


NibblesGame*
nibbles_game_new (GSettings* settings)
{
	return nibbles_game_construct (TYPE_NIBBLES_GAME, settings);
}


static gboolean
_nibbles_game_main_loop_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_game_main_loop_cb ((NibblesGame*) self);
	return result;
}


static gboolean
_nibbles_game_add_bonus_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_game_add_bonus_cb ((NibblesGame*) self);
	return result;
}


void
nibbles_game_start (NibblesGame* self)
{
	gint _tmp0_;
	guint _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, TRUE);
	_tmp0_ = self->priv->_speed;
	self->priv->main_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * _tmp0_), _nibbles_game_main_loop_cb_gsource_func, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->main_id;
	g_source_set_name_by_id (_tmp1_, "[Nibbles] main_loop_cb");
	_tmp2_ = self->priv->_speed;
	self->priv->add_bonus_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_BONUSDELAY * _tmp2_), _nibbles_game_add_bonus_cb_gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->add_bonus_id;
	g_source_set_name_by_id (_tmp3_, "[Nibbles] add_bonus_cb");
}


void
nibbles_game_stop (NibblesGame* self)
{
	guint _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, FALSE);
	_tmp0_ = self->priv->main_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->main_id;
		g_source_remove (_tmp1_);
		self->priv->main_id = (guint) 0;
	}
	_tmp2_ = self->priv->add_bonus_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_;
		_tmp3_ = self->priv->add_bonus_id;
		g_source_remove (_tmp3_);
		self->priv->add_bonus_id = (guint) 0;
	}
}


void
nibbles_game_pause (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, TRUE);
	nibbles_game_stop (self);
}


void
nibbles_game_unpause (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, FALSE);
	nibbles_game_start (self);
}


void
nibbles_game_reset (NibblesGame* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_start_level;
	nibbles_game_set_current_level (self, _tmp0_);
}


static void
nibbles_game_end (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_stop (self);
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
}


static gboolean
_game_status_equal (const GameStatus * s1,
                    const GameStatus * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


gboolean
nibbles_game_main_loop_cb (NibblesGame* self)
{
	gboolean result = FALSE;
	GameStatus* status = NULL;
	GameStatus* _tmp0_;
	GameStatus* _tmp1_;
	GameStatus _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = nibbles_game_get_game_status (self);
	status = _tmp0_;
	_tmp1_ = status;
	_tmp2_ = GAME_STATUS_GAMEOVER;
	if (_game_status_equal (_tmp1_, &_tmp2_) == TRUE) {
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		Worm* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		nibbles_game_end (self);
		_tmp3_ = self->priv->_worms;
		_tmp4_ = gee_linked_list_first (_tmp3_);
		_tmp5_ = (Worm*) _tmp4_;
		_tmp6_ = worm_get_score (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_current_level;
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp7_, _tmp8_);
		_g_object_unref0 (_tmp5_);
		result = G_SOURCE_REMOVE;
		_g_free0 (status);
		return result;
	} else {
		GameStatus* _tmp9_;
		GameStatus _tmp10_;
		_tmp9_ = status;
		_tmp10_ = GAME_STATUS_VICTORY;
		if (_game_status_equal (_tmp9_, &_tmp10_) == TRUE) {
			Worm* winner = NULL;
			Worm* _tmp11_;
			Worm* _tmp12_;
			Worm* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			nibbles_game_end (self);
			_tmp11_ = nibbles_game_get_winner (self);
			winner = _tmp11_;
			_tmp12_ = winner;
			if (_tmp12_ == NULL) {
				result = G_SOURCE_REMOVE;
				_g_object_unref0 (winner);
				_g_free0 (status);
				return result;
			}
			_tmp13_ = winner;
			_tmp14_ = worm_get_score (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->_current_level;
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp15_, _tmp16_);
			result = G_SOURCE_REMOVE;
			_g_object_unref0 (winner);
			_g_free0 (status);
			return result;
		} else {
			GameStatus* _tmp17_;
			GameStatus _tmp18_;
			_tmp17_ = status;
			_tmp18_ = GAME_STATUS_NEWROUND;
			if (_game_status_equal (_tmp17_, &_tmp18_) == TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				nibbles_game_stop (self);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL], 0);
				_tmp19_ = self->priv->_current_level;
				nibbles_game_set_current_level (self, _tmp19_ + 1);
				_tmp20_ = self->priv->_current_level;
				if (_tmp20_ == (NIBBLES_GAME_MAX_LEVEL + 1)) {
					GeeLinkedList* _tmp21_;
					gpointer _tmp22_;
					Worm* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					_tmp21_ = self->priv->_worms;
					_tmp22_ = gee_linked_list_first (_tmp21_);
					_tmp23_ = (Worm*) _tmp22_;
					_tmp24_ = worm_get_score (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = self->priv->_current_level;
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp25_, _tmp26_);
					_g_object_unref0 (_tmp23_);
				}
				result = G_SOURCE_REMOVE;
				_g_free0 (status);
				return result;
			}
		}
	}
	nibbles_game_move_worms (self);
	result = G_SOURCE_CONTINUE;
	_g_free0 (status);
	return result;
}


static void
_nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                               gpointer self)
{
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
}


static void
_nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender,
                                             gpointer self)
{
	nibbles_game_warp_found_cb ((NibblesGame*) self, _sender);
}


void
nibbles_game_create_worms (NibblesGame* self)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_worms;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_numai;
	_tmp2_ = self->priv->_numhumans;
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				Worm* worm = NULL;
				gint _tmp7_;
				Worm* _tmp8_;
				Worm* _tmp9_;
				Worm* _tmp10_;
				Worm* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GeeLinkedList* _tmp14_;
				Worm* _tmp15_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_numworms;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = worm_new (_tmp7_);
				worm = _tmp8_;
				_tmp9_ = worm;
				g_signal_connect_object (_tmp9_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
				_tmp10_ = worm;
				g_signal_connect_object (_tmp10_, "warp-found", (GCallback) _nibbles_game_warp_found_cb_worm_warp_found, self, 0);
				_tmp11_ = worm;
				_tmp12_ = i;
				_tmp13_ = self->priv->_numhumans;
				_tmp11_->is_human = _tmp12_ < _tmp13_;
				_tmp14_ = self->priv->_worms;
				_tmp15_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
				_g_object_unref0 (worm);
			}
		}
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
nibbles_game_add_worms (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			Worm* _tmp12_;
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			g_signal_emit_by_name (_tmp11_, "added");
			_tmp12_ = worm;
			_tmp13_ = self->board;
			_tmp13__length1 = self->board_length1;
			_tmp13__length2 = self->board_length2;
			worm_spawn (_tmp12_, _tmp13_, _tmp13__length1, _tmp13__length2);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


void
nibbles_game_move_worms (NibblesGame* self)
{
	Boni* _tmp0_;
	gint _tmp1_;
	GeeLinkedList* found = NULL;
	GeeLinkedList* _tmp19_;
	Boni* _tmp51_;
	GeeLinkedList* _tmp52_;
	GeeLinkedList* _tmp53_;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp54_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_boni;
	_tmp1_ = _tmp0_->missed;
	if (_tmp1_ > BONI_MAX_MISSED) {
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp2_;
			GeeLinkedList* _tmp3_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _worm_index = 0;
			_tmp2_ = self->priv->_worms;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_worm_list = _tmp3_;
			_tmp4_ = _worm_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_worm_size = _tmp6_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				Worm* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				_tmp7_ = _worm_index;
				_worm_index = _tmp7_ + 1;
				_tmp8_ = _worm_index;
				_tmp9_ = _worm_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _worm_list;
				_tmp11_ = _worm_index;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
				worm = (Worm*) _tmp12_;
				_tmp13_ = worm;
				_tmp14_ = worm_get_score (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ > 0) {
					Worm* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp16_ = worm;
					_tmp17_ = worm_get_score (_tmp16_);
					_tmp18_ = _tmp17_;
					worm_set_score (_tmp16_, _tmp18_ - 1);
				}
				_g_object_unref0 (worm);
			}
			_g_object_unref0 (_worm_list);
		}
	}
	_tmp19_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	found = _tmp19_;
	{
		GeeLinkedList* _bonus_list = NULL;
		Boni* _tmp20_;
		GeeLinkedList* _tmp21_;
		GeeLinkedList* _tmp22_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _bonus_index = 0;
		_tmp20_ = self->priv->_boni;
		_tmp21_ = _tmp20_->bonuses;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_bonus_list = _tmp22_;
		_tmp23_ = _bonus_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_bonus_size = _tmp25_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_;
			Bonus* _tmp32_;
			gint _tmp33_;
			_tmp26_ = _bonus_index;
			_bonus_index = _tmp26_ + 1;
			_tmp27_ = _bonus_index;
			_tmp28_ = _bonus_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _bonus_list;
			_tmp30_ = _bonus_index;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
			bonus = (Bonus*) _tmp31_;
			_tmp32_ = bonus;
			_tmp33_ = _tmp32_->countdown;
			_tmp32_->countdown = _tmp33_ - 1;
			if (_tmp33_ == 0) {
				gboolean _tmp34_ = FALSE;
				Bonus* _tmp35_;
				BonusType _tmp36_;
				_tmp35_ = bonus;
				_tmp36_ = _tmp35_->type;
				if (_tmp36_ == BONUS_TYPE_REGULAR) {
					Bonus* _tmp37_;
					gboolean _tmp38_;
					_tmp37_ = bonus;
					_tmp38_ = _tmp37_->fake;
					_tmp34_ = !_tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					GeeLinkedList* _tmp39_;
					Bonus* _tmp40_;
					Boni* _tmp41_;
					gint* _tmp42_;
					gint _tmp42__length1;
					gint _tmp42__length2;
					Bonus* _tmp43_;
					Boni* _tmp44_;
					gint _tmp45_;
					_tmp39_ = found;
					_tmp40_ = bonus;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
					_tmp41_ = self->priv->_boni;
					_tmp42_ = self->board;
					_tmp42__length1 = self->board_length1;
					_tmp42__length2 = self->board_length2;
					_tmp43_ = bonus;
					boni_remove_bonus (_tmp41_, _tmp42_, _tmp42__length1, _tmp42__length2, _tmp43_);
					_tmp44_ = self->priv->_boni;
					_tmp45_ = _tmp44_->missed;
					_tmp44_->missed = _tmp45_ + 1;
					nibbles_game_add_bonus (self, TRUE);
				} else {
					GeeLinkedList* _tmp46_;
					Bonus* _tmp47_;
					Boni* _tmp48_;
					gint* _tmp49_;
					gint _tmp49__length1;
					gint _tmp49__length2;
					Bonus* _tmp50_;
					_tmp46_ = found;
					_tmp47_ = bonus;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
					_tmp48_ = self->priv->_boni;
					_tmp49_ = self->board;
					_tmp49__length1 = self->board_length1;
					_tmp49__length2 = self->board_length2;
					_tmp50_ = bonus;
					boni_remove_bonus (_tmp48_, _tmp49_, _tmp49__length1, _tmp49__length2, _tmp50_);
				}
			}
			_g_object_unref0 (bonus);
		}
		_g_object_unref0 (_bonus_list);
	}
	_tmp51_ = self->priv->_boni;
	_tmp52_ = _tmp51_->bonuses;
	_tmp53_ = found;
	gee_collection_remove_all ((GeeCollection*) _tmp52_, (GeeCollection*) _tmp53_);
	_tmp54_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dead_worms = _tmp54_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp55_;
		GeeLinkedList* _tmp56_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _worm_index = 0;
		_tmp55_ = self->priv->_worms;
		_tmp56_ = _g_object_ref0 (_tmp55_);
		_worm_list = _tmp56_;
		_tmp57_ = _worm_list;
		_tmp58_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_worm_size = _tmp59_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			Worm* _tmp66_;
			gboolean _tmp67_;
			Worm* _tmp68_;
			GeeLinkedList* _tmp69_;
			GeeLinkedList* _tmp70_;
			gboolean _tmp71_;
			gboolean _tmp72_;
			Worm* _tmp73_;
			gboolean _tmp74_;
			Worm* _tmp106_;
			gint* _tmp107_;
			gint _tmp107__length1;
			gint _tmp107__length2;
			gint _tmp108_;
			Worm* _tmp111_;
			gint* _tmp112_;
			gint _tmp112__length1;
			gint _tmp112__length2;
			_tmp60_ = _worm_index;
			_worm_index = _tmp60_ + 1;
			_tmp61_ = _worm_index;
			_tmp62_ = _worm_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _worm_list;
			_tmp64_ = _worm_index;
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
			worm = (Worm*) _tmp65_;
			_tmp66_ = worm;
			_tmp67_ = _tmp66_->is_stopped;
			if (_tmp67_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp68_ = worm;
			_tmp69_ = worm_get_list (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = gee_collection_get_is_empty ((GeeCollection*) _tmp70_);
			_tmp72_ = _tmp71_;
			if (_tmp72_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp73_ = worm;
			_tmp74_ = _tmp73_->is_human;
			if (!_tmp74_) {
				Worm* _tmp75_;
				gint* _tmp76_;
				gint _tmp76__length1;
				gint _tmp76__length2;
				gint _tmp77_;
				GeeLinkedList* _tmp78_;
				_tmp75_ = worm;
				_tmp76_ = self->board;
				_tmp76__length1 = self->board_length1;
				_tmp76__length2 = self->board_length2;
				_tmp77_ = self->priv->_numworms;
				_tmp78_ = self->priv->_worms;
				worm_ai_move (_tmp75_, _tmp76_, _tmp76__length1, _tmp76__length2, _tmp77_, _tmp78_);
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp79_;
				GeeLinkedList* _tmp80_;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				gint _other_worm_index = 0;
				_tmp79_ = self->priv->_worms;
				_tmp80_ = _g_object_ref0 (_tmp79_);
				_other_worm_list = _tmp80_;
				_tmp81_ = _other_worm_list;
				_tmp82_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp81_);
				_tmp83_ = _tmp82_;
				_other_worm_size = _tmp83_;
				_other_worm_index = -1;
				while (TRUE) {
					gint _tmp84_;
					gint _tmp85_;
					gint _tmp86_;
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp87_;
					gint _tmp88_;
					gpointer _tmp89_;
					gboolean _tmp90_ = FALSE;
					gboolean _tmp91_ = FALSE;
					Worm* _tmp92_;
					Worm* _tmp93_;
					_tmp84_ = _other_worm_index;
					_other_worm_index = _tmp84_ + 1;
					_tmp85_ = _other_worm_index;
					_tmp86_ = _other_worm_size;
					if (!(_tmp85_ < _tmp86_)) {
						break;
					}
					_tmp87_ = _other_worm_list;
					_tmp88_ = _other_worm_index;
					_tmp89_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _tmp88_);
					other_worm = (Worm*) _tmp89_;
					_tmp92_ = worm;
					_tmp93_ = other_worm;
					if (_tmp92_ != _tmp93_) {
						Worm* _tmp94_;
						gboolean _tmp95_;
						_tmp94_ = other_worm;
						_tmp95_ = _tmp94_->is_stopped;
						_tmp91_ = !_tmp95_;
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						Worm* _tmp96_;
						Worm* _tmp97_;
						_tmp96_ = worm;
						_tmp97_ = other_worm;
						_tmp90_ = worm_will_collide_with_head (_tmp96_, _tmp97_);
					} else {
						_tmp90_ = FALSE;
					}
					if (_tmp90_) {
						GeeLinkedList* _tmp98_;
						Worm* _tmp99_;
						GeeLinkedList* _tmp102_;
						Worm* _tmp103_;
						_tmp98_ = dead_worms;
						_tmp99_ = worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp98_, _tmp99_)) {
							GeeLinkedList* _tmp100_;
							Worm* _tmp101_;
							_tmp100_ = dead_worms;
							_tmp101_ = worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp101_);
						}
						_tmp102_ = dead_worms;
						_tmp103_ = other_worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp102_, _tmp103_)) {
							GeeLinkedList* _tmp104_;
							Worm* _tmp105_;
							_tmp104_ = dead_worms;
							_tmp105_ = other_worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, _tmp105_);
						}
						_g_object_unref0 (other_worm);
						continue;
					}
					_g_object_unref0 (other_worm);
				}
				_g_object_unref0 (_other_worm_list);
			}
			_tmp106_ = worm;
			_tmp107_ = self->board;
			_tmp107__length1 = self->board_length1;
			_tmp107__length2 = self->board_length2;
			_tmp108_ = self->priv->_numworms;
			if (!worm_can_move_to (_tmp106_, _tmp107_, _tmp107__length1, _tmp107__length2, _tmp108_)) {
				GeeLinkedList* _tmp109_;
				Worm* _tmp110_;
				_tmp109_ = dead_worms;
				_tmp110_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp110_);
				_g_object_unref0 (worm);
				continue;
			}
			_tmp111_ = worm;
			_tmp112_ = self->board;
			_tmp112__length1 = self->board_length1;
			_tmp112__length2 = self->board_length2;
			worm_move (_tmp111_, _tmp112_, _tmp112__length1, _tmp112__length2);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp113_;
		GeeLinkedList* _tmp114_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _worm_index = 0;
		_tmp113_ = dead_worms;
		_tmp114_ = _g_object_ref0 (_tmp113_);
		_worm_list = _tmp114_;
		_tmp115_ = _worm_list;
		_tmp116_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_worm_size = _tmp117_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			gint _tmp124_;
			Worm* _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			_tmp118_ = _worm_index;
			_worm_index = _tmp118_ + 1;
			_tmp119_ = _worm_index;
			_tmp120_ = _worm_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _worm_list;
			_tmp122_ = _worm_index;
			_tmp123_ = gee_abstract_list_get ((GeeAbstractList*) _tmp121_, _tmp122_);
			worm = (Worm*) _tmp123_;
			_tmp124_ = self->priv->_numworms;
			if (_tmp124_ > 1) {
				Worm* _tmp125_;
				Worm* _tmp126_;
				gint _tmp127_;
				gint _tmp128_;
				_tmp125_ = worm;
				_tmp126_ = worm;
				_tmp127_ = worm_get_score (_tmp126_);
				_tmp128_ = _tmp127_;
				worm_set_score (_tmp125_, (_tmp128_ * 7) / 10);
			}
			_tmp129_ = worm;
			_tmp130_ = worm_get_lives (_tmp129_);
			_tmp131_ = _tmp130_;
			if (_tmp131_ > 0) {
				Worm* _tmp132_;
				gint* _tmp133_;
				gint _tmp133__length1;
				gint _tmp133__length2;
				_tmp132_ = worm;
				_tmp133_ = self->board;
				_tmp133__length1 = self->board_length1;
				_tmp133__length2 = self->board_length2;
				worm_reset (_tmp132_, _tmp133_, _tmp133__length1, _tmp133__length2);
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_g_object_unref0 (dead_worms);
	_g_object_unref0 (found);
}


static void
nibbles_game_reverse_worms (NibblesGame* self,
                            Worm* worm)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_worm_list = _tmp1_;
		_tmp2_ = _other_worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_worm_size = _tmp4_;
		_other_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			_tmp5_ = _other_worm_index;
			_other_worm_index = _tmp5_ + 1;
			_tmp6_ = _other_worm_index;
			_tmp7_ = _other_worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_worm_list;
			_tmp9_ = _other_worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_worm = (Worm*) _tmp10_;
			_tmp11_ = other_worm;
			if (worm != _tmp11_) {
				Worm* _tmp12_;
				gint* _tmp13_;
				gint _tmp13__length1;
				gint _tmp13__length2;
				_tmp12_ = other_worm;
				_tmp13_ = self->board;
				_tmp13__length1 = self->board_length1;
				_tmp13__length2 = self->board_length2;
				worm_reverse (_tmp12_, _tmp13_, _tmp13__length1, _tmp13__length2);
			}
			_g_object_unref0 (other_worm);
		}
		_g_object_unref0 (_other_worm_list);
	}
}


void
nibbles_game_add_bonus (NibblesGame* self,
                        gboolean regular)
{
	gboolean good = FALSE;
	gint x = 0;
	gint y = 0;
	g_return_if_fail (self != NULL);
	good = FALSE;
	x = 0;
	y = 0;
	if (!regular) {
		if (g_random_int_range ((gint32) 0, (gint32) 50) != ((gint32) 0)) {
			return;
		}
	}
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint* _tmp2_;
			gint _tmp2__length1;
			gint _tmp2__length2;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint* _tmp6_;
			gint _tmp6__length1;
			gint _tmp6__length2;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp10__length2;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint* _tmp14_;
			gint _tmp14__length1;
			gint _tmp14__length2;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			if (!_tmp0_) {
				gboolean _tmp1_;
				_tmp1_ = good;
				if (!(!_tmp1_)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			good = TRUE;
			x = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
			y = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
			_tmp2_ = self->board;
			_tmp2__length1 = self->board_length1;
			_tmp2__length2 = self->board_length2;
			_tmp3_ = x;
			_tmp4_ = y;
			_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
			if (_tmp5_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp6_ = self->board;
			_tmp6__length1 = self->board_length1;
			_tmp6__length2 = self->board_length2;
			_tmp7_ = x;
			_tmp8_ = y;
			_tmp9_ = _tmp6_[((_tmp7_ + 1) * _tmp6__length2) + _tmp8_];
			if (_tmp9_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp10_ = self->board;
			_tmp10__length1 = self->board_length1;
			_tmp10__length2 = self->board_length2;
			_tmp11_ = x;
			_tmp12_ = y;
			_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + (_tmp12_ + 1)];
			if (_tmp13_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp14_ = self->board;
			_tmp14__length1 = self->board_length1;
			_tmp14__length2 = self->board_length2;
			_tmp15_ = x;
			_tmp16_ = y;
			_tmp17_ = _tmp14_[((_tmp15_ + 1) * _tmp14__length2) + (_tmp16_ + 1)];
			if (_tmp17_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
		}
	}
	if (regular) {
		gboolean _tmp18_ = FALSE;
		Boni* _tmp41_;
		gint* _tmp42_;
		gint _tmp42__length1;
		gint _tmp42__length2;
		gint _tmp43_;
		gint _tmp44_;
		if (g_random_int_range ((gint32) 0, (gint32) 7) == ((gint32) 0)) {
			gboolean _tmp19_;
			_tmp19_ = self->priv->_fakes;
			_tmp18_ = _tmp19_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			Boni* _tmp20_;
			gint* _tmp21_;
			gint _tmp21__length1;
			gint _tmp21__length2;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = self->priv->_boni;
			_tmp21_ = self->board;
			_tmp21__length1 = self->board_length1;
			_tmp21__length2 = self->board_length2;
			_tmp22_ = x;
			_tmp23_ = y;
			boni_add_bonus (_tmp20_, _tmp21_, _tmp21__length1, _tmp21__length2, _tmp22_, _tmp23_, BONUS_TYPE_REGULAR, TRUE, 300);
		}
		good = FALSE;
		while (TRUE) {
			gboolean _tmp24_;
			gint* _tmp25_;
			gint _tmp25__length1;
			gint _tmp25__length2;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint* _tmp29_;
			gint _tmp29__length1;
			gint _tmp29__length2;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint* _tmp33_;
			gint _tmp33__length1;
			gint _tmp33__length2;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint* _tmp37_;
			gint _tmp37__length1;
			gint _tmp37__length2;
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp24_ = good;
			if (!(!_tmp24_)) {
				break;
			}
			good = TRUE;
			x = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
			y = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
			_tmp25_ = self->board;
			_tmp25__length1 = self->board_length1;
			_tmp25__length2 = self->board_length2;
			_tmp26_ = x;
			_tmp27_ = y;
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
			if (_tmp28_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp29_ = self->board;
			_tmp29__length1 = self->board_length1;
			_tmp29__length2 = self->board_length2;
			_tmp30_ = x;
			_tmp31_ = y;
			_tmp32_ = _tmp29_[((_tmp30_ + 1) * _tmp29__length2) + _tmp31_];
			if (_tmp32_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp33_ = self->board;
			_tmp33__length1 = self->board_length1;
			_tmp33__length2 = self->board_length2;
			_tmp34_ = x;
			_tmp35_ = y;
			_tmp36_ = _tmp33_[(_tmp34_ * _tmp33__length2) + (_tmp35_ + 1)];
			if (_tmp36_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp37_ = self->board;
			_tmp37__length1 = self->board_length1;
			_tmp37__length2 = self->board_length2;
			_tmp38_ = x;
			_tmp39_ = y;
			_tmp40_ = _tmp37_[((_tmp38_ + 1) * _tmp37__length2) + (_tmp39_ + 1)];
			if (_tmp40_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
		}
		_tmp41_ = self->priv->_boni;
		_tmp42_ = self->board;
		_tmp42__length1 = self->board_length1;
		_tmp42__length2 = self->board_length2;
		_tmp43_ = x;
		_tmp44_ = y;
		boni_add_bonus (_tmp41_, _tmp42_, _tmp42__length1, _tmp42__length2, _tmp43_, _tmp44_, BONUS_TYPE_REGULAR, FALSE, 300);
	} else {
		Boni* _tmp45_;
		gint _tmp46_;
		_tmp45_ = self->priv->_boni;
		_tmp46_ = _tmp45_->missed;
		if (_tmp46_ <= BONI_MAX_MISSED) {
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_;
			if (g_random_int_range ((gint32) 0, (gint32) 7) != ((gint32) 0)) {
				good = FALSE;
			} else {
				good = TRUE;
			}
			_tmp48_ = good;
			if (_tmp48_) {
				gboolean _tmp49_;
				_tmp49_ = self->priv->_fakes;
				_tmp47_ = !_tmp49_;
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				return;
			}
			switch (g_random_int_range ((gint32) 0, (gint32) 21)) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				{
					Boni* _tmp50_;
					gint* _tmp51_;
					gint _tmp51__length1;
					gint _tmp51__length2;
					gint _tmp52_;
					gint _tmp53_;
					gboolean _tmp54_;
					_tmp50_ = self->priv->_boni;
					_tmp51_ = self->board;
					_tmp51__length1 = self->board_length1;
					_tmp51__length2 = self->board_length2;
					_tmp52_ = x;
					_tmp53_ = y;
					_tmp54_ = good;
					boni_add_bonus (_tmp50_, _tmp51_, _tmp51__length1, _tmp51__length2, _tmp52_, _tmp53_, BONUS_TYPE_HALF, _tmp54_, 200);
					break;
				}
				case 10:
				case 11:
				case 12:
				case 13:
				case 14:
				{
					Boni* _tmp55_;
					gint* _tmp56_;
					gint _tmp56__length1;
					gint _tmp56__length2;
					gint _tmp57_;
					gint _tmp58_;
					gboolean _tmp59_;
					_tmp55_ = self->priv->_boni;
					_tmp56_ = self->board;
					_tmp56__length1 = self->board_length1;
					_tmp56__length2 = self->board_length2;
					_tmp57_ = x;
					_tmp58_ = y;
					_tmp59_ = good;
					boni_add_bonus (_tmp55_, _tmp56_, _tmp56__length1, _tmp56__length2, _tmp57_, _tmp58_, BONUS_TYPE_DOUBLE, _tmp59_, 150);
					break;
				}
				case 15:
				{
					Boni* _tmp60_;
					gint* _tmp61_;
					gint _tmp61__length1;
					gint _tmp61__length2;
					gint _tmp62_;
					gint _tmp63_;
					gboolean _tmp64_;
					_tmp60_ = self->priv->_boni;
					_tmp61_ = self->board;
					_tmp61__length1 = self->board_length1;
					_tmp61__length2 = self->board_length2;
					_tmp62_ = x;
					_tmp63_ = y;
					_tmp64_ = good;
					boni_add_bonus (_tmp60_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_, _tmp63_, BONUS_TYPE_LIFE, _tmp64_, 100);
					break;
				}
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				{
					gint _tmp65_;
					_tmp65_ = self->priv->_numworms;
					if (_tmp65_ > 1) {
						Boni* _tmp66_;
						gint* _tmp67_;
						gint _tmp67__length1;
						gint _tmp67__length2;
						gint _tmp68_;
						gint _tmp69_;
						gboolean _tmp70_;
						_tmp66_ = self->priv->_boni;
						_tmp67_ = self->board;
						_tmp67__length1 = self->board_length1;
						_tmp67__length2 = self->board_length2;
						_tmp68_ = x;
						_tmp69_ = y;
						_tmp70_ = good;
						boni_add_bonus (_tmp66_, _tmp67_, _tmp67__length1, _tmp67__length2, _tmp68_, _tmp69_, BONUS_TYPE_REVERSE, _tmp70_, 150);
					}
					break;
				}
				default:
				break;
			}
		}
	}
}


void
nibbles_game_apply_bonus (NibblesGame* self,
                          Bonus* bonus,
                          Worm* worm)
{
	gboolean _tmp0_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	Position _tmp3_ = {0};
	Position _tmp4_;
	gint _tmp5_;
	Position _tmp6_ = {0};
	Position _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = bonus->fake;
	if (_tmp0_) {
		gint* _tmp1_;
		gint _tmp1__length1;
		gint _tmp1__length2;
		_tmp1_ = self->board;
		_tmp1__length1 = self->board_length1;
		_tmp1__length2 = self->board_length2;
		worm_reverse (worm, _tmp1_, _tmp1__length1, _tmp1__length2);
		return;
	}
	_tmp2_ = self->board;
	_tmp2__length1 = self->board_length1;
	_tmp2__length2 = self->board_length2;
	worm_get_head (worm, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.x;
	worm_get_head (worm, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_.y;
	_tmp9_ = _tmp2_[(_tmp5_ * _tmp2__length2) + _tmp8_];
	switch (_tmp9_ - 'A') {
		case BONUS_TYPE_REGULAR:
		{
			Boni* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			Boni* _tmp13_;
			gint _tmp14_;
			Boni* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			Boni* _tmp19_;
			gint _tmp20_;
			Boni* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp10_ = self->priv->_boni;
			_tmp11_ = _tmp10_->numleft;
			_tmp10_->numleft = _tmp11_ - 1;
			_tmp12_ = worm->change;
			_tmp13_ = self->priv->_boni;
			_tmp14_ = _tmp13_->numboni;
			_tmp15_ = self->priv->_boni;
			_tmp16_ = _tmp15_->numleft;
			worm->change = _tmp12_ + ((_tmp14_ - _tmp16_) * WORM_GROW_FACTOR);
			_tmp17_ = worm_get_score (worm);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->_boni;
			_tmp20_ = _tmp19_->numboni;
			_tmp21_ = self->priv->_boni;
			_tmp22_ = _tmp21_->numleft;
			_tmp23_ = self->priv->_current_level;
			worm_set_score (worm, _tmp18_ + ((_tmp20_ - _tmp22_) * _tmp23_));
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp24_ = worm_get_score (worm);
			_tmp25_ = _tmp24_;
			_tmp26_ = worm_get_length (worm);
			_tmp27_ = _tmp26_;
			_tmp28_ = worm->change;
			_tmp29_ = self->priv->_current_level;
			worm_set_score (worm, _tmp25_ + ((_tmp27_ + _tmp28_) * _tmp29_));
			_tmp30_ = worm->change;
			_tmp31_ = worm_get_length (worm);
			_tmp32_ = _tmp31_;
			_tmp33_ = worm->change;
			worm->change = _tmp30_ + (_tmp32_ + _tmp33_);
			break;
		}
		case BONUS_TYPE_HALF:
		{
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			_tmp34_ = worm_get_length (worm);
			_tmp35_ = _tmp34_;
			_tmp36_ = worm->change;
			if ((_tmp35_ + _tmp36_) > 2) {
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint* _tmp43_;
				gint _tmp43__length1;
				gint _tmp43__length2;
				gint _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				_tmp37_ = worm_get_score (worm);
				_tmp38_ = _tmp37_;
				_tmp39_ = worm_get_length (worm);
				_tmp40_ = _tmp39_;
				_tmp41_ = worm->change;
				_tmp42_ = self->priv->_current_level;
				worm_set_score (worm, _tmp38_ + ((_tmp40_ + (_tmp41_ / 2)) * _tmp42_));
				_tmp43_ = self->board;
				_tmp43__length1 = self->board_length1;
				_tmp43__length2 = self->board_length2;
				_tmp44_ = worm_get_length (worm);
				_tmp45_ = _tmp44_;
				worm_reduce_tail (worm, _tmp43_, _tmp43__length1, _tmp43__length2, _tmp45_ / 2);
				_tmp46_ = worm->change;
				_tmp47_ = worm_get_length (worm);
				_tmp48_ = _tmp47_;
				_tmp49_ = worm->change;
				worm->change = _tmp46_ - ((_tmp48_ + _tmp49_) / 2);
			}
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			worm_add_life (worm);
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			nibbles_game_reverse_worms (self, worm);
			break;
		}
		default:
		break;
	}
}


gboolean
nibbles_game_add_bonus_cb (NibblesGame* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	nibbles_game_add_bonus (self, FALSE);
	result = G_SOURCE_CONTINUE;
	return result;
}


void
nibbles_game_bonus_found_cb (NibblesGame* self,
                             Worm* worm)
{
	Bonus* bonus = NULL;
	Boni* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	Position _tmp2_ = {0};
	Position _tmp3_;
	gint _tmp4_;
	Position _tmp5_ = {0};
	Position _tmp6_;
	gint _tmp7_;
	Bonus* _tmp8_;
	Bonus* _tmp9_;
	Bonus* _tmp10_;
	Bonus* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	Position _tmp14_ = {0};
	Position _tmp15_;
	gint _tmp16_;
	Position _tmp17_ = {0};
	Position _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->_boni;
	_tmp1_ = self->board;
	_tmp1__length1 = self->board_length1;
	_tmp1__length2 = self->board_length2;
	worm_get_head (worm, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_.x;
	worm_get_head (worm, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_.y;
	_tmp8_ = boni_get_bonus (_tmp0_, _tmp1_, _tmp1__length1, _tmp1__length2, _tmp4_, _tmp7_);
	bonus = _tmp8_;
	_tmp9_ = bonus;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (bonus);
		return;
	}
	_tmp10_ = bonus;
	nibbles_game_apply_bonus (self, _tmp10_, worm);
	_tmp11_ = bonus;
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL], 0, _tmp11_, worm);
	_tmp13_ = self->board;
	_tmp13__length1 = self->board_length1;
	_tmp13__length2 = self->board_length2;
	worm_get_head (worm, &_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_.x;
	worm_get_head (worm, &_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_.y;
	_tmp20_ = _tmp13_[(_tmp16_ * _tmp13__length2) + _tmp19_];
	if (_tmp20_ == ((gint) (BONUS_TYPE_REGULAR + 'A'))) {
		Bonus* _tmp21_;
		gboolean _tmp22_;
		_tmp21_ = bonus;
		_tmp22_ = _tmp21_->fake;
		_tmp12_ = !_tmp22_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		Boni* _tmp23_;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint _tmp24__length2;
		Bonus* _tmp25_;
		Boni* _tmp26_;
		GeeLinkedList* _tmp27_;
		Bonus* _tmp28_;
		Boni* _tmp29_;
		gint _tmp30_;
		_tmp23_ = self->priv->_boni;
		_tmp24_ = self->board;
		_tmp24__length1 = self->board_length1;
		_tmp24__length2 = self->board_length2;
		_tmp25_ = bonus;
		boni_remove_bonus (_tmp23_, _tmp24_, _tmp24__length1, _tmp24__length2, _tmp25_);
		_tmp26_ = self->priv->_boni;
		_tmp27_ = _tmp26_->bonuses;
		_tmp28_ = bonus;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = self->priv->_boni;
		_tmp30_ = _tmp29_->numleft;
		if (_tmp30_ != 0) {
			nibbles_game_add_bonus (self, TRUE);
		}
	} else {
		Boni* _tmp31_;
		gint* _tmp32_;
		gint _tmp32__length1;
		gint _tmp32__length2;
		Bonus* _tmp33_;
		Boni* _tmp34_;
		GeeLinkedList* _tmp35_;
		Bonus* _tmp36_;
		_tmp31_ = self->priv->_boni;
		_tmp32_ = self->board;
		_tmp32__length1 = self->board_length1;
		_tmp32__length2 = self->board_length2;
		_tmp33_ = bonus;
		boni_remove_bonus (_tmp31_, _tmp32_, _tmp32__length1, _tmp32__length2, _tmp33_);
		_tmp34_ = self->priv->_boni;
		_tmp35_ = _tmp34_->bonuses;
		_tmp36_ = bonus;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp35_, _tmp36_);
	}
	_g_object_unref0 (bonus);
}


void
nibbles_game_warp_found_cb (NibblesGame* self,
                            Worm* worm)
{
	Warp* warp = NULL;
	WarpManager* _tmp0_;
	Position _tmp1_ = {0};
	Position _tmp2_;
	gint _tmp3_;
	Position _tmp4_ = {0};
	Position _tmp5_;
	gint _tmp6_;
	Warp* _tmp7_;
	Warp* _tmp8_;
	Warp* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->_warp_manager;
	worm_get_head (worm, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.x;
	worm_get_head (worm, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_.y;
	_tmp7_ = warp_manager_get_warp (_tmp0_, _tmp3_, _tmp6_);
	warp = _tmp7_;
	_tmp8_ = warp;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (warp);
		return;
	}
	_tmp9_ = warp;
	worm_warp (worm, _tmp9_);
	_g_object_unref0 (warp);
}


static GameStatus*
_game_status_dup (GameStatus* self)
{
	GameStatus* dup;
	dup = g_new0 (GameStatus, 1);
	memcpy (dup, self, sizeof (GameStatus));
	return dup;
}


static gpointer
__game_status_dup0 (gpointer self)
{
	return self ? _game_status_dup (self) : NULL;
}


GameStatus*
nibbles_game_get_game_status (NibblesGame* self)
{
	GameStatus* result = NULL;
	gint worms_left = 0;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_;
	Boni* _tmp31_;
	gint _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	worms_left = 0;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			_tmp12_ = worm_get_lives (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				gint _tmp14_;
				_tmp14_ = worms_left;
				worms_left = _tmp14_ + 1;
			} else {
				gboolean _tmp15_ = FALSE;
				Worm* _tmp16_;
				gboolean _tmp17_;
				_tmp16_ = worm;
				_tmp17_ = _tmp16_->is_human;
				if (_tmp17_) {
					Worm* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp18_ = worm;
					_tmp19_ = worm_get_lives (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp15_ = _tmp20_ <= 0;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					GameStatus _tmp21_;
					GameStatus* _tmp22_;
					_tmp21_ = GAME_STATUS_GAMEOVER;
					_tmp22_ = __game_status_dup0 (&_tmp21_);
					result = _tmp22_;
					_g_object_unref0 (worm);
					_g_object_unref0 (_worm_list);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp24_ = worms_left;
	if (_tmp24_ == 1) {
		gint _tmp25_;
		_tmp25_ = self->priv->_numworms;
		_tmp23_ = _tmp25_ > 1;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GameStatus _tmp26_;
		GameStatus* _tmp27_;
		_tmp26_ = GAME_STATUS_VICTORY;
		_tmp27_ = __game_status_dup0 (&_tmp26_);
		result = _tmp27_;
		return result;
	} else {
		gint _tmp28_;
		_tmp28_ = worms_left;
		if (_tmp28_ == 0) {
			GameStatus _tmp29_;
			GameStatus* _tmp30_;
			_tmp29_ = GAME_STATUS_GAMEOVER;
			_tmp30_ = __game_status_dup0 (&_tmp29_);
			result = _tmp30_;
			return result;
		}
	}
	_tmp31_ = self->priv->_boni;
	_tmp32_ = _tmp31_->numleft;
	if (_tmp32_ == 0) {
		GameStatus _tmp33_;
		GameStatus* _tmp34_;
		_tmp33_ = GAME_STATUS_NEWROUND;
		_tmp34_ = __game_status_dup0 (&_tmp33_);
		result = _tmp34_;
		return result;
	}
	result = NULL;
	return result;
}


Worm*
nibbles_game_get_winner (NibblesGame* self)
{
	Worm* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			_tmp12_ = worm_get_lives (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				result = worm;
				_g_object_unref0 (_worm_list);
				return result;
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	result = NULL;
	return result;
}


void
nibbles_game_load_properties (NibblesGame* self,
                              GSettings* settings)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	nibbles_game_set_tile_size (self, g_settings_get_int (settings, "tile-size"));
	nibbles_game_set_start_level (self, g_settings_get_int (settings, "start-level"));
	nibbles_game_set_speed (self, g_settings_get_int (settings, "speed"));
	nibbles_game_set_fakes (self, g_settings_get_boolean (settings, "fakes"));
}


void
nibbles_game_save_properties (NibblesGame* self,
                              GSettings* settings)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_tile_size;
	g_settings_set_int (settings, "tile-size", _tmp0_);
	_tmp1_ = self->priv->_start_level;
	g_settings_set_int (settings, "start-level", _tmp1_);
	_tmp2_ = self->priv->_speed;
	g_settings_set_int (settings, "speed", _tmp2_);
	_tmp3_ = self->priv->_fakes;
	g_settings_set_boolean (settings, "fakes", _tmp3_);
}


void
nibbles_game_load_worm_properties (NibblesGame* self,
                                   GeeArrayList* worm_settings)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm_settings != NULL);
	_tmp0_ = self->priv->_worm_props;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_worm_list = _tmp2_;
		_tmp3_ = _worm_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_worm_size = _tmp5_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			WormProperties properties = {0};
			Worm* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			GSettings* _tmp16_;
			Worm* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			GSettings* _tmp21_;
			Worm* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_;
			GSettings* _tmp26_;
			Worm* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			GSettings* _tmp31_;
			Worm* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			GSettings* _tmp36_;
			GeeHashMap* _tmp37_;
			Worm* _tmp38_;
			WormProperties _tmp39_;
			_tmp6_ = _worm_index;
			_worm_index = _tmp6_ + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = _worm_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			worm = (Worm*) _tmp11_;
			memset (&properties, 0, sizeof (WormProperties));
			_tmp12_ = worm;
			_tmp13_ = worm_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp14_);
			_tmp16_ = (GSettings*) _tmp15_;
			properties.color = g_settings_get_enum (_tmp16_, "color");
			_g_object_unref0 (_tmp16_);
			_tmp17_ = worm;
			_tmp18_ = worm_get_id (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp19_);
			_tmp21_ = (GSettings*) _tmp20_;
			properties.up = (guint) g_settings_get_int (_tmp21_, "key-up");
			_g_object_unref0 (_tmp21_);
			_tmp22_ = worm;
			_tmp23_ = worm_get_id (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp24_);
			_tmp26_ = (GSettings*) _tmp25_;
			properties.down = (guint) g_settings_get_int (_tmp26_, "key-down");
			_g_object_unref0 (_tmp26_);
			_tmp27_ = worm;
			_tmp28_ = worm_get_id (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp29_);
			_tmp31_ = (GSettings*) _tmp30_;
			properties.left = (guint) g_settings_get_int (_tmp31_, "key-left");
			_g_object_unref0 (_tmp31_);
			_tmp32_ = worm;
			_tmp33_ = worm_get_id (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp34_);
			_tmp36_ = (GSettings*) _tmp35_;
			properties.right = (guint) g_settings_get_int (_tmp36_, "key-right");
			_g_object_unref0 (_tmp36_);
			_tmp37_ = self->priv->_worm_props;
			_tmp38_ = worm;
			_tmp39_ = properties;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, _tmp38_, &_tmp39_);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


gboolean
nibbles_game_handle_keypress (NibblesGame* self,
                              guint keyval)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_worm_list = _tmp2_;
		_tmp3_ = _worm_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_worm_size = _tmp5_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			Worm* _tmp12_;
			gboolean _tmp13_;
			_tmp6_ = _worm_index;
			_worm_index = _tmp6_ + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = _worm_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			worm = (Worm*) _tmp11_;
			_tmp12_ = worm;
			_tmp13_ = _tmp12_->is_human;
			if (_tmp13_) {
				Worm* _tmp14_;
				GeeHashMap* _tmp15_;
				_tmp14_ = worm;
				_tmp15_ = self->priv->_worm_props;
				if (worm_handle_keypress (_tmp14_, keyval, _tmp15_)) {
					result = TRUE;
					_g_object_unref0 (worm);
					_g_object_unref0 (_worm_list);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	result = FALSE;
	return result;
}


gint
nibbles_game_get_start_level (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_start_level;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_start_level (NibblesGame* self,
                              gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_start_level (self) != value) {
		self->priv->_start_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY]);
	}
}


gint
nibbles_game_get_current_level (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_level;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_current_level (NibblesGame* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_current_level (self) != value) {
		self->priv->_current_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY]);
	}
}


gint
nibbles_game_get_speed (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_speed;
	result = _tmp0_;
	return result;
}


void
nibbles_game_set_speed (NibblesGame* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_speed (self) != value) {
		self->priv->_speed = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY]);
	}
}


gint
nibbles_game_get_tile_size (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_tile_size;
	result = _tmp0_;
	return result;
}


void
nibbles_game_set_tile_size (NibblesGame* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_tile_size (self) != value) {
		self->priv->_tile_size = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_TILE_SIZE_PROPERTY]);
	}
}


gint
nibbles_game_get_numhumans (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_numhumans;
	result = _tmp0_;
	return result;
}


void
nibbles_game_set_numhumans (NibblesGame* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_numhumans (self) != value) {
		self->priv->_numhumans = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY]);
	}
}


gint
nibbles_game_get_numai (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_numai;
	result = _tmp0_;
	return result;
}


void
nibbles_game_set_numai (NibblesGame* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_numai (self) != value) {
		self->priv->_numai = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY]);
	}
}


gint
nibbles_game_get_numworms (NibblesGame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_numworms;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_numworms (NibblesGame* self,
                           gint value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_numworms (self) != value) {
		self->priv->_numworms = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY]);
	}
}


GeeLinkedList*
nibbles_game_get_worms (NibblesGame* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worms;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_worms (NibblesGame* self,
                        GeeLinkedList* value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_worms (self) != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_worms);
		self->priv->_worms = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY]);
	}
}


Boni*
nibbles_game_get_boni (NibblesGame* self)
{
	Boni* result;
	Boni* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_boni;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_boni (NibblesGame* self,
                       Boni* value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_boni (self) != value) {
		Boni* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_boni);
		self->priv->_boni = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_BONI_PROPERTY]);
	}
}


WarpManager*
nibbles_game_get_warp_manager (NibblesGame* self)
{
	WarpManager* result;
	WarpManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_warp_manager;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_warp_manager (NibblesGame* self,
                               WarpManager* value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_warp_manager (self) != value) {
		WarpManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_warp_manager);
		self->priv->_warp_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WARP_MANAGER_PROPERTY]);
	}
}


GeeHashMap*
nibbles_game_get_worm_props (NibblesGame* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worm_props;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_worm_props (NibblesGame* self,
                             GeeHashMap* value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_worm_props (self) != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_worm_props);
		self->priv->_worm_props = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY]);
	}
}


gboolean
nibbles_game_get_is_running (NibblesGame* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_is_running (NibblesGame* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_is_running (self) != value) {
		self->priv->_is_running = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY]);
	}
}


gboolean
nibbles_game_get_is_paused (NibblesGame* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}


static void
nibbles_game_set_is_paused (NibblesGame* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_is_paused (self) != value) {
		self->priv->_is_paused = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_PAUSED_PROPERTY]);
	}
}


gboolean
nibbles_game_get_fakes (NibblesGame* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_fakes;
	result = _tmp0_;
	return result;
}


void
nibbles_game_set_fakes (NibblesGame* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_game_get_fakes (self) != value) {
		self->priv->_fakes = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY]);
	}
}


static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void
nibbles_game_class_init (NibblesGameClass * klass)
{
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesGamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_START_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY] = g_param_spec_int ("start-level", "start-level", "start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY] = g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_TILE_SIZE_PROPERTY, nibbles_game_properties[NIBBLES_GAME_TILE_SIZE_PROPERTY] = g_param_spec_int ("tile-size", "tile-size", "tile-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY] = g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMAI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY] = g_param_spec_int ("numai", "numai", "numai", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY] = g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY] = g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_BONI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_BONI_PROPERTY] = g_param_spec_object ("boni", "boni", "boni", TYPE_BONI, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WARP_MANAGER_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WARP_MANAGER_PROPERTY] = g_param_spec_object ("warp-manager", "warp-manager", "warp-manager", TYPE_WARP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY] = g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_PAUSED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_PAUSED_PROPERTY] = g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES_PROPERTY, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY] = g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	nibbles_game_signals[NIBBLES_GAME_WORM_MOVED_SIGNAL] = g_signal_new ("worm-moved", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WORM);
	nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL] = g_signal_new ("bonus-applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_BONUS, TYPE_WORM);
	nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL] = g_signal_new ("log-score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL] = g_signal_new ("animate-end-game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL] = g_signal_new ("level-completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
nibbles_game_instance_init (NibblesGame * self)
{
	self->priv = NIBBLES_GAME_GET_PRIVATE (self);
	self->priv->_is_running = FALSE;
	self->priv->main_id = (guint) 0;
	self->priv->add_bonus_id = (guint) 0;
}


static void
nibbles_game_finalize (GObject * obj)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	self->board = (g_free (self->board), NULL);
	_g_object_unref0 (self->priv->_worms);
	_g_object_unref0 (self->priv->_boni);
	_g_object_unref0 (self->priv->_warp_manager);
	_g_object_unref0 (self->priv->_worm_props);
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
}


GType
nibbles_game_get_type (void)
{
	static volatile gsize nibbles_game_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
		GType nibbles_game_type_id;
		nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_game_type_id__volatile, nibbles_game_type_id);
	}
	return nibbles_game_type_id__volatile;
}


static void
_vala_nibbles_game_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_game_get_start_level (self));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_game_get_current_level (self));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		g_value_set_int (value, nibbles_game_get_speed (self));
		break;
		case NIBBLES_GAME_TILE_SIZE_PROPERTY:
		g_value_set_int (value, nibbles_game_get_tile_size (self));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numhumans (self));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numai (self));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numworms (self));
		break;
		case NIBBLES_GAME_WORMS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worms (self));
		break;
		case NIBBLES_GAME_BONI_PROPERTY:
		g_value_set_object (value, nibbles_game_get_boni (self));
		break;
		case NIBBLES_GAME_WARP_MANAGER_PROPERTY:
		g_value_set_object (value, nibbles_game_get_warp_manager (self));
		break;
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worm_props (self));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
		break;
		case NIBBLES_GAME_IS_PAUSED_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_is_paused (self));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_nibbles_game_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
		nibbles_game_set_start_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		nibbles_game_set_current_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		nibbles_game_set_speed (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_TILE_SIZE_PROPERTY:
		nibbles_game_set_tile_size (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		nibbles_game_set_numhumans (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		nibbles_game_set_numai (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		nibbles_game_set_numworms (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_WORMS_PROPERTY:
		nibbles_game_set_worms (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_BONI_PROPERTY:
		nibbles_game_set_boni (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_WARP_MANAGER_PROPERTY:
		nibbles_game_set_warp_manager (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
		nibbles_game_set_worm_props (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_IS_PAUSED_PROPERTY:
		nibbles_game_set_is_paused (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



