/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* timer.h
 *
 * Copyright (C) 2001  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _TIMER_H_
#define _TIMER_H_

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define TYPE_TIMER			(timer_get_type ())
#define TIMER(obj)			(GTK_CHECK_CAST ((obj), TYPE_TIMER, Timer))
#define TIMER_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_TIMER, TimerClass))
#define IS_TIMER(obj)			(GTK_CHECK_TYPE ((obj), TYPE_TIMER))
#define IS_TIMER_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_TIMER))


typedef struct _Timer        Timer;
typedef struct _TimerPrivate TimerPrivate;
typedef struct _TimerClass   TimerClass;

struct _Timer {
	GtkLabel parent;

	TimerPrivate *priv;
};

struct _TimerClass {
	GtkLabelClass parent_class;

	void (*expired) (Timer *timer);
};


GtkType    timer_get_type (void);
GtkWidget *timer_new      (gint secs);

gint timer_get   (Timer *timer);
void timer_set   (Timer *timer,
		  gint   secs);
void timer_start (Timer *timer);
void timer_stop  (Timer *timer);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _TIMER_H_ */
