/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#ifdef USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "debug.h"
#include "makros.h"
#include "prefs.h"
#include "engine_local.h"
#include "engine_ics.h"
#include "engine-pgn.h"
#include "board-window.h"
 
/* Command line variables */
static gint *ics = 0;
static char *icshost = NULL;
static char *icsuser = NULL;
static char *icspass = NULL;
static char *icsport = NULL;
static char *icstelnetprogram = NULL;
static char *fcp = NULL;
static char **startup_files = NULL;

static poptContext ctx;

static const struct poptOption gnome_chess_popt_options [] = {
	{ "debug", '\0', POPT_ARG_INT, &debug, 0,
	  N_("Enables some debugging functions"), N_("LEVEL") },
	{ "fcp", '\0', POPT_ARG_STRING, &fcp, 0,
	  N_("First Chess Program"),   N_("PROGRAM") },
	{ "ics", '\0', POPT_ARG_NONE, &ics, 0,
	  N_("Start in ICS mode"), NULL },
	{ "icshost", '\0', POPT_ARG_STRING, &icshost, 0,
	  N_("ICS Server"), N_("SERVER") },
	{ "icsuser", '\0', POPT_ARG_STRING, &icsuser, 0,
	  N_("ICS User"), N_("USERNAME") },
	{ "icspass", '\0', POPT_ARG_STRING, &icspass, 0,
	  N_("ICS Password"), N_("PASSWORD") },
	{ "icsport", '\0', POPT_ARG_STRING, &icsport, 0,
	  N_("ICS Port"), N_("PORT") },
	{ "icstelnetprogram", '\0', POPT_ARG_STRING, &icstelnetprogram, 0,
	  N_("ICS Telnet Programm"), N_("TELNET") },

	{ NULL, '\0', 0, NULL, 0 }
};

GtkWidget *main_board_window = NULL;

int 
main (int argc, char *argv []) 
{
	GtkObject *engine;
	GtkWidget *view;
	int i = 0;
	
	/* Internationalization */
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	/* Command Line Args */
	gnome_init_with_popt_table ("Gnome Chess", 
				    VERSION, 
				    argc, argv, 
				    gnome_chess_popt_options,
				    0, &ctx);

#ifdef USE_WM_ICONS
	gnome_window_icon_set_default_from_file (GNOME_ICONDIR 
						 "/gnome-chess.png");
#endif
	/* Initialize the preferences */
	prefs_init();

	/* Initialize glade */
	glade_gnome_init();

	main_board_window = board_window_new ();
	gtk_widget_show (main_board_window);

	if (fcp != NULL) {
		engine = engine_local_new (fcp, NULL);
		view = game_view_new_with_engine (ENGINE (engine));
		board_window_add_view (BOARD_WINDOW (main_board_window), 
				       GAME_VIEW (view));
	}

	if (ics && icshost != NULL)
		engine = engine_ics_new (icshost, icsport, icsuser, icspass, NULL);

	/* open the files */
	startup_files = (char **)poptGetArgs (ctx);
	for (i = 0; startup_files && startup_files[i]; i++)
		engine_pgn_new (startup_files[i]);
	poptFreeContext (ctx);
	
	/* Begin the event loop */
	gtk_main ();

	return 0;
}

