/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 *       Changes by Diego Delgado Lages <dlages@dcc.ufrj.br> on 1999/08/07
 *       Changes by Olivier Aubin <ogaubin@ucalgary.ca>, 1999
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "sources.h"

#include "tooltips.h"

#include "sources-wizard.h"

#include <apt-pkg/sourcelist.h>

Sources::Sources()
  : list_(0), dialog_(0), pkglist_(0),
    clist_(0), b_add_(0), b_del_(0), b_edit_(0),
    edit_dialog_(0), edit_dialog_dist_(0), edit_dialog_uri_(0),
    edit_dialog_section_(0), selected_row_(-1)
{


}

Sources::~Sources()
{
  if (dialog_) gtk_widget_destroy(dialog_);
}

void 
Sources::edit()
{
  g_return_if_fail(pkglist_ != 0);

  if (dialog_ != 0) {
    gdk_window_show(dialog_->window);
    gdk_window_raise(dialog_->window);
    return;
  }

  list_ = new pkgSourceList;

  if (list_->ReadMainList() == false)
    {
      GtkWidget* dialog = gnome_error_dialog(_("The list of sources could not be read."));
      gnome_apt_setup_dialog(dialog);
      delete list_;
      list_ = 0;
      return;
    }

  dialog_ = gnome_property_box_new();

  gnome_apt_setup_dialog(dialog_);

  gtk_window_set_policy(GTK_WINDOW(dialog_),
                        TRUE, TRUE, FALSE);

  gtk_window_set_title(GTK_WINDOW(dialog_), _("Gnome Apt Source List"));

  gtk_signal_connect (GTK_OBJECT(dialog_),
                      "apply",
                      GTK_SIGNAL_FUNC(apply_cb),
                      this);

  gtk_signal_connect (GTK_OBJECT(dialog_),
                      "help",
                      GTK_SIGNAL_FUNC(help_cb),
                      this);

  gtk_signal_connect (GTK_OBJECT(dialog_),
                      "close",
                      GTK_SIGNAL_FUNC(close_cb),
                      this);

  GtkWidget* frame = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(frame), GNOME_PAD);
  GtkWidget* vbox  = gtk_vbox_new(FALSE, GNOME_PAD);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD);  

  char* titles[] = {
    _("Distribution"),
    _("Uniform Resource Identifier"),
    _("Section")
  };

  clist_ = gtk_clist_new_with_titles(3, titles);

  gtk_signal_connect(GTK_OBJECT(clist_),
                     "select_row",
                     GTK_SIGNAL_FUNC(select_row_cb),
                     this);

  gtk_signal_connect(GTK_OBJECT(clist_),
                     "unselect_row",
                     GTK_SIGNAL_FUNC(unselect_row_cb),
                     this);

  gtk_clist_set_reorderable(GTK_CLIST(clist_),
                            TRUE);

  gtk_widget_set_usize(clist_, -1, 100);

  GtkWidget* sw = gtk_scrolled_window_new(NULL,NULL);

  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);

  gtk_container_add(GTK_CONTAINER(sw), clist_);

  gtk_box_pack_start(GTK_BOX(vbox),
                     sw,
                     TRUE, TRUE, 0);

  char* text[] = { 0, 0, 0 };

  pkgSourceList::const_iterator i = list_->begin();
  while (i != list_->end())
    {
      text[0] = const_cast<char*>((*i).Dist.c_str());
      text[1] = const_cast<char*>((*i).URI.c_str());
      text[2] = const_cast<char*>((*i).Section.c_str());

      gtk_clist_append (GTK_CLIST(clist_),
                        text);

      ++i;
    }

  GtkWidget* hbox = gtk_hbox_new(0,FALSE);

  gtk_box_pack_start(GTK_BOX(vbox),
                     hbox,
					 FALSE,FALSE,0);

  gtk_widget_show(hbox);

  b_add_ = gnome_pixmap_button(gnome_stock_pixmap_widget(dialog_,GNOME_STOCK_PIXMAP_ADD),
                               _("Add source"));
  
  gtk_box_pack_start(GTK_BOX(hbox),
                     b_add_,
					 TRUE,TRUE,0);

  gtk_widget_show(b_add_);

  b_del_ = gnome_pixmap_button(gnome_stock_pixmap_widget(dialog_, GNOME_STOCK_PIXMAP_REMOVE),
                               _("Remove source"));
  
  gtk_box_pack_start(GTK_BOX(hbox),
                     b_del_,
					 TRUE,TRUE,0);

  gtk_widget_show(b_del_);

  b_edit_ = gnome_pixmap_button(gnome_stock_pixmap_widget(dialog_,GNOME_STOCK_PIXMAP_PROPERTIES),
                               _("Edit source"));
  
  gtk_box_pack_start(GTK_BOX(hbox),
                     b_edit_,
					 TRUE,TRUE,0);

  gtk_widget_show(b_edit_);

  gtk_signal_connect (GTK_OBJECT(b_add_),
                      "clicked",
                      GTK_SIGNAL_FUNC(add_wizard_cb),
                      this);

  gtk_signal_connect (GTK_OBJECT(b_del_),
                      "clicked",
                      GTK_SIGNAL_FUNC(delete_source_cb),
                      this);
 
  gtk_signal_connect (GTK_OBJECT(b_edit_),
                      "clicked",
                      GTK_SIGNAL_FUNC(edit_source_cb),
                      this);

  gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog_),
                                 vbox,
                                 gtk_label_new(_("Sources")));

  gtk_widget_show_all(dialog_);
}

/*
 * Add a source to the list (usually called by the wizard).
 * Error means that the source was NOT ADDED.
 *
 */
Sources::SourceAddResult
Sources::add_source(gchar* dist, gchar* uri, gchar* section)
{
  SourceAddResult error = Ok;

  // FIXME - Check the data and set error accordingly

  if (error == Ok)
    {
      gchar* row_data[] = { dist, uri, section };
      
      gtk_clist_append(GTK_CLIST(clist_),
                       row_data);
      changed();
    }
  
  return error;
}

void
Sources::setup_dialog(GtkWindow* w)
{
  g_return_if_fail(w != 0);
  
  if (dialog_ != 0)
    {
      if (GNOME_IS_DIALOG(w))
        gnome_dialog_set_parent(GNOME_DIALOG(w), GTK_WINDOW(dialog_));
      else
        gtk_window_set_transient_for(w, GTK_WINDOW(dialog_));
    }
}

void 
Sources::apply_cb (GtkWidget* w, gint page, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  p->apply(page);
}

void 
Sources::help_cb  (GtkWidget* w, gint page, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  p->help(page);
}

void 
Sources::apply(gint page)
{
  // FIXME - Save the current contents of clist_

  // only apply on final emission.
  if (page != -1) return;
}

void 
Sources::help (gint page)
{
  gnome_ok_dialog("There is no help yet.");
}

gint 
Sources::close_cb (GtkWidget* w, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  return p->close();
}
 
gint
Sources::close()
{
  if(edit_dialog_ != 0)
    return TRUE;

  gnome_apt_sources_wizard_shutdown();

  dialog_ = 0;
  if (list_) delete list_;
  list_ = 0;

  return FALSE;
}

void 
Sources::changed_cb (GtkWidget* w, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  p->changed();
}

void 
Sources::changed()
{
  gnome_property_box_changed(GNOME_PROPERTY_BOX(dialog_));
}

void
Sources::add_wizard_cb (GtkWidget* w, gpointer data)
{
  gnome_apt_sources_wizard()->add();
}

void
Sources::delete_source_cb (GtkWidget* w, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  p->delete_source();
}

void
Sources::delete_source()
{
  if(selected_row_ < 0)
    return;

  gtk_clist_remove(GTK_CLIST(clist_),
                   selected_row_);

  selected_row_ = -1;

  //  gtk_clist_unselect_all(GTK_CLIST(clist_));

  changed();
}

void
Sources::edit_source_cb(GtkWidget* w, gpointer data)
{
  Sources* p = static_cast<Sources*>(data);

  p->edit_source();
}

void
Sources::edit_source()
{
  if(selected_row_ < 0)
    return;

  edit_dialog_ = gnome_dialog_new("Edit source",
                                  GNOME_STOCK_BUTTON_OK,
                                  GNOME_STOCK_BUTTON_CANCEL,
                                  NULL);

  gnome_dialog_set_parent(GNOME_DIALOG(edit_dialog_),
                          GTK_WINDOW(dialog_));

  GtkWidget* label = gtk_label_new("Edit the source here");
  
  GtkWidget* hbox = gtk_hbox_new(FALSE, 0);

  GtkWidget* vbox_labels = gtk_vbox_new(TRUE, 0);

  GtkWidget* label_dist = gtk_label_new("Distribution");

  gtk_misc_set_alignment(GTK_MISC(label_dist), 0.0, 0.5);

  gtk_box_pack_start(GTK_BOX(vbox_labels),
                     label_dist,
                     TRUE, TRUE, GNOME_PAD_SMALL);

  GtkWidget* label_uri = gtk_label_new("URI");

  gtk_misc_set_alignment(GTK_MISC(label_uri), 0.0, 0.5);

  gtk_box_pack_start(GTK_BOX(vbox_labels),
                     label_uri,
                     TRUE, TRUE, GNOME_PAD_SMALL);

  GtkWidget* label_section = gtk_label_new("Section");

  gtk_misc_set_alignment(GTK_MISC(label_section), 0.0, 0.5);

  gtk_box_pack_start(GTK_BOX(vbox_labels),
                     label_section,
                     TRUE, TRUE, GNOME_PAD_SMALL);

  gtk_box_pack_start(GTK_BOX(hbox),
                     vbox_labels,
                     TRUE, TRUE, GNOME_PAD_SMALL);

  GtkWidget* vbox_edit = gtk_vbox_new(TRUE, 0);

  gchar* ptr_dist;
  gchar* ptr_uri;
  gchar* ptr_section;

  gtk_clist_get_text(GTK_CLIST(clist_),
                     selected_row_, 0,
                     &ptr_dist);

  gtk_clist_get_text(GTK_CLIST(clist_),
                     selected_row_, 1,
                     &ptr_uri);

  gtk_clist_get_text(GTK_CLIST(clist_),
                     selected_row_, 2,
                     &ptr_section);

  edit_dialog_dist_ = gtk_entry_new();

  gtk_entry_set_text(GTK_ENTRY(edit_dialog_dist_),
                     ptr_dist);

  gtk_entry_set_position(GTK_ENTRY(edit_dialog_dist_), -1);

  gtk_box_pack_start(GTK_BOX(vbox_edit),
                     edit_dialog_dist_,
                     TRUE, FALSE, GNOME_PAD_SMALL);

  edit_dialog_uri_ = gtk_entry_new();

  gtk_entry_set_text(GTK_ENTRY(edit_dialog_uri_),
                     ptr_uri);

  gtk_entry_set_position(GTK_ENTRY(edit_dialog_uri_), -1);

  gtk_box_pack_start(GTK_BOX(vbox_edit),
                     edit_dialog_uri_,
                     TRUE, FALSE, GNOME_PAD_SMALL);

  edit_dialog_section_ = gtk_entry_new();

  gtk_entry_set_text(GTK_ENTRY(edit_dialog_section_),
                     ptr_section);

  gtk_entry_set_position(GTK_ENTRY(edit_dialog_section_), -1);

  gtk_box_pack_start(GTK_BOX(vbox_edit),
                     edit_dialog_section_,
                     TRUE, FALSE, GNOME_PAD_SMALL);

  gtk_box_pack_start(GTK_BOX(hbox),
                     vbox_edit,
                     TRUE, TRUE, GNOME_PAD_SMALL);

  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(edit_dialog_)->vbox),
                     hbox,
                     TRUE, TRUE, 0);

  gtk_widget_show_all(edit_dialog_);

  gtk_signal_connect(GTK_OBJECT(edit_dialog_),
                     "close",
                     GTK_SIGNAL_FUNC(edit_source_close_cb),
                     this);

  gtk_signal_connect(GTK_OBJECT(edit_dialog_),
                     "clicked",
                     GTK_SIGNAL_FUNC(edit_source_click_cb),
                     this);

  //  gtk_clist_freeze(GTK_CLIST(clist_));

  gtk_widget_set_sensitive(dialog_,
                           FALSE);
}

gint
Sources::edit_source_close_cb(GnomeDialog* d, gpointer data)
{
  Sources* ptr = static_cast<Sources*>(data);

  ptr->edit_source_close();

  return TRUE; /* don't destroy the dialog since we do it ourselves */
}

void

Sources::edit_source_close()
{
  if(edit_dialog_ != 0)
    gtk_widget_destroy(edit_dialog_);

  edit_dialog_ = 0;

  gtk_widget_set_sensitive(dialog_,
                           TRUE);
}

void
Sources::edit_source_click_cb(GnomeDialog* d, gint arg, gpointer data)
{
  Sources* ptr = static_cast<Sources*>(data);

  if(arg == 0)
    {
      ptr->edit_source_ok();
    }

  ptr->edit_source_close();
}

void
Sources::edit_source_ok()
{
  gchar* dist = gtk_entry_get_text(GTK_ENTRY(edit_dialog_dist_));

  gchar* uri = gtk_entry_get_text(GTK_ENTRY(edit_dialog_uri_));

  gchar* section = gtk_entry_get_text(GTK_ENTRY(edit_dialog_section_));
  
  // FIXME - check the validity of input
  
  gtk_clist_set_text(GTK_CLIST(clist_),
                     selected_row_, 0, dist);
  
  gtk_clist_set_text(GTK_CLIST(clist_),
                     selected_row_, 1, uri);
  
  gtk_clist_set_text(GTK_CLIST(clist_),
                     selected_row_, 2, section);
  
  changed();
}

void
Sources::select_row_cb(GtkCList* clist, gint row, gint column, GdkEventButton* e, gpointer data)
{
  Sources* ptr = static_cast<Sources*>(data);

  ptr->select_row(row, column);
}

void
Sources::select_row(gint row, gint column)
{
  selected_row_ = row;
}

void
Sources::unselect_row_cb(GtkCList* clist, gint row, gint column, GdkEventButton* e, gpointer data)
{
  Sources* ptr = static_cast<Sources*>(data);

  ptr->unselect_row(row, column);
}

void
Sources::unselect_row(gint row, gint column)
{
  selected_row_ = -1;
}

static Sources* sources = 0;

Sources*
gnome_apt_sources()
{
  if (sources == 0)
    sources = new Sources;

  return sources;
}

void     
gnome_apt_sources_shutdown()
{
  gnome_apt_sources_wizard_shutdown();

  if (sources != 0)
    delete sources;

  sources = 0;
}
