/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_CACHE_H
#define GNOME_APT_CACHE_H

#include <gnome-apt.h>

#include <apt-pkg/error.h>
#include <apt-pkg/cmndline.h>
#include <apt-pkg/init.h>
#include <apt-pkg/depcache.h>
#include <apt-pkg/sourcelist.h>
#include <apt-pkg/pkgcachegen.h>
#include <apt-pkg/algorithms.h>
#include <apt-pkg/pkgsystem.h>
#include <apt-pkg/pkgrecords.h>

#include <set>

using namespace std;

// This is useless now, it's here so we can easily add features.
class GAptCache : public pkgDepCache {
public:
  GAptCache(pkgCache *Cache);

private:

};


class GAptCacheFile
{  
  FileFd *file_;
  MMap *map_;
  GAptCache *cache_;
  pkgRecords* records_;

public:
  GAptCache* cache() { return cache_; }
  pkgRecords* records() { return records_; }


#if 0  
  inline operator GAptCache &() {return *cache_;};
  inline GAptCache *operator ->() {return cache_;};
  inline GAptCache &operator *() {return *cache_;};
#endif  

  bool Open();

  // An update run (like apt-get update)
  bool UpdateAndReopen();

  // A whole Install run (install whatever is selected)
  bool Install();

  // Mark packages that can be upgraded without removals
  //  or installs (apt-get upgrade)
  void MarkUpgrades();

  // apt-get dist-upgrade - Mark packages, allowing removals/installs
  void SmartMarkUpgrades();

  // Fix broken packages
  void Fix();

  GAptCacheFile() : file_(0), map_(0), cache_(0), records_(0) {};
  ~GAptCacheFile()
    {
      clear();
    }   

  class CacheView {
  public:
    virtual void set_cache(GAptCache* cache) = 0;
  };

  void add_view(CacheView* v) {
#ifdef GNOME_ENABLE_DEBUG
    set<CacheView*>::iterator i = views_.find(v);
    if (i != views_.end()) g_warning("Adding view twice!");
#endif
    views_.insert(v);
    v->set_cache(cache_);
  }
  
  void remove_view(CacheView* v) {
    set<CacheView*>::iterator i = views_.find(v);
    if (i != views_.end())
      views_.erase(i);
#ifdef GNOME_ENABLE_DEBUG
    else g_warning("View not in list!");
#endif
    v->set_cache(0);
  }

  const vector<string> & sections() { return sections_; }

private:
  
  set<CacheView*> views_;

  void clear();

  vector<string> sections_;
};

// Return our cache file, or 0 if the cache file is not created
//  or was not created successfully.
GAptCacheFile* gnome_apt_cache_file     (void);

void       gnome_apt_cache_file_init    ();
void       gnome_apt_cache_file_shutdown();

#endif
