-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/lsodbc.adb,v $
--  Description     : ls command to explore an odbc command                  --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/05/10 16:24:03 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  This programm allows to explore an odbc interface                        --
--       								     --
--     lsodbc [ source login passwd { -t | -a } ]                            --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Text_IO;		use Ada.Text_IO;
with Ada.Command_Line;          use Ada.Command_Line;
with Ada.Strings.Unbounded;     use Ada.Strings.Unbounded;
with Tools;                     use Tools;
with ODBC;      		use ODBC;
with Tools;

procedure lsodbc is
   Version : constant String := "$Id";

   SI      : Source_Information;
   DB      : ODBC.Object;
   Login   : Unbounded_String;
   Pwd     : Unbounded_String;
   Argc    : Natural := 1;
   Info    : Boolean := False;
   Quiet   : Boolean := False;

   Error, Message : Unbounded_String;

   ----------
   -- Help --
   ----------
   procedure Help is
   begin
      Put_Line("usage : " );
      Put_Line("    lsodbc [ [-u <login> [ -l <passwd> ]] [ <source> ] ] " );
      Put_Line("");
   end Help;
   ------------------------
   -- Source_Information --  
   ------------------------ 
   procedure Source_Information( 
      S     : in String ) is
      -- get all information from a source we can get.
      Tabs  : String_Array_Access;
   begin
      Info := True;
      Put_Line("Data Source: " & S  );	
        
      Authorization( DB, To_String(Login), To_String(Pwd) );
      Data_Source( DB, S );
      Connect( DB );

      Put_Line("   Tables: " );
      Tabs := Tables( DB, "%", "%" );
      for i in Tabs'Range loop
         Put_Line("      " & To_String( Tabs(i) ) );
      end loop;

      Disconnect( DB );
   end Source_Information;

begin 
   Initialize(DB);

   -- Handle the command line arguments
   while Argc in 1..Argument_Count loop
      declare
         Arg : constant String := Argument( Argc );
      begin
         if Arg = "-u" then
            Argc := Argc + 1;
            Login := To_Unbounded_String( Argument( Argc ) );
         elsif Arg = "-p" then
            Argc := Argc + 1;
            Pwd := To_Unbounded_String( Argument( Argc ) );
         elsif Arg = "-h" then
	    Help;
	    return;
         elsif Arg(1) /= '-' then
            Source_Information( Arg );
	 elsif Arg = "-q" then
	    Quiet := True;
         else
	    Help;
	    return;
	 end if;
         Argc := Argc + 1;
      end;
   end loop;

   if not Quiet then
      Put_Line("GNADE ODBC information programm, Version " & Tools.Version);
      Put_Line("Copyright (C) 2003, Michael Erdmann (michael.erdmann@snafu.de)");
   end if;     

   -- if no information has been given so far list the information for all
   -- data source known to the ODBC driver.    
   if not Info then
      SI := Data_Source( DB, First => True );
      while SI.Server /= Null_Unbounded_String loop
         declare
            Server : constant String := To_String( SI.Server );
         begin
            Source_Information( Server );
         exception
            when Others =>
	      Put_Line("  *** No information available *** " );
         end;

         SI := Data_Source( DB );
      end loop; 
   end if;

   Finalize(DB);
   Set_Exit_Status( Success );
   
exception
   when Others =>
      Get_Error( DB, Error, Message );
      Put_Line( To_String( Error ) & ":" & To_String( Message ) );	   
      Set_Exit_Status( Failure );
      
      Set_Exit_Status( Failure ); 
end lsodbc;
