-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/contents_manager.ads,v $
--  Description     : contents handler package                               --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/03 19:56:03 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--                                                                           --
--                                                                           --
--  Author                                                                   --
--  ======                                                                   --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;              use Ada.Strings.Unbounded;
with Contents_Handler;                   use Contents_Handler;

package Contents_Manager is

   type Element_ID is private;

   Null_Element_ID     : constant Element_ID;
   Max_Nbr_Of_Elements : constant Positive;

   Instanciation_Error : exception;

   -- a constructor for a document component
   type Constructor_Access is access function(
          Key : in String ) return Contents_Handler.Handle;

   -- register a constructor for a document class.
   procedure Register(
      Class_Name  : in String;
      Constructor : in Constructor_Access );

   function  Create(
      Class_Name  : in String;
      Name        : in String ) return Contents_Handler.Handle;

   function  Create(
      Class_Name  : in Unbounded_String;
      Name        : in Unbounded_String ) return Contents_Handler.Handle;

   -- initialize the contents handler with the selected class
   procedure Initialize(
      Class_Name : in String;
      Parent     : in Element_ID);

   -- copy all all object of the given class into the project file
   procedure Finalize(
      Class_Name : in String := "" );

   procedure Selected(
      Id      : in Element_ID );

   -- add a element to the contents manager.
   function Add_Contents_Element(
      Name    : in Unbounded_String;
      Handler : in Contents_Handler.Handle;
      Parent  : in Element_ID := Null_Element_ID ) return Element_ID;

   procedure Remove_Contents_Element(
      Id      : in Element_ID );

   -- name of the instance
   function Element_Name(
      Id      : in Element_ID ) return Unbounded_String;

   function Contents(
      Id      : in Element_ID ) return Contents_Handler.Handle;

   function Contents(
      Cls     : in Unbounded_String;
      Name    : in Unbounded_String ) return Contents_Handler.Handle;

   No_More_Elements  : exception;
   Element_Not_Found : exception;

   --------------------------------------------------------------------------

private
   Max_Nbr_Of_Elements : constant Positive := 1000;

   type Element_ID is new Natural range 0..Max_Nbr_Of_Elements;
   Null_Element_ID : constant Element_ID := 0;

   function Get_Element_ID(
      Name   : in String;
      Parent : in Element_ID) return Element_ID;

end Contents_Manager;
