#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <gtk/gtk.h>

#include "defines.h"
#include "gui.h"
#include "actions.h"
#include "remove.h"

void remove_callback (GtkWidget *widget, gpointer data)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *btn_yes,
    *btn_no;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(window), "GkDial");
  gtk_signal_connect_object (GTK_OBJECT(window), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(window));
  gtk_container_set_border_width (GTK_CONTAINER(window), 3);

  frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(frame), 4);
  gtk_container_add (GTK_CONTAINER(window), frame);
  gtk_widget_show (frame);

  table = gtk_table_new (2, 2, TRUE);
  gtk_container_add (GTK_CONTAINER(frame), table);
  gtk_widget_show (table);

  label = gtk_label_new (_("Are you sure you want to remove\n"
			   "the peer you selected?"));
  gtk_label_set_justify (GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_widget_show (label);

  btn_yes = gtk_button_new_with_label (_("Yes"));
  gtk_signal_connect (GTK_OBJECT(btn_yes), "clicked",
		      GTK_SIGNAL_FUNC(remove_conf), data);
  gtk_signal_connect_object (GTK_OBJECT(btn_yes), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(window));
  gtk_widget_show (btn_yes);

  btn_no = gtk_button_new_with_label (_("No"));
  gtk_signal_connect_object (GTK_OBJECT(btn_no), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(window));
  gtk_widget_show (btn_no);

  gtk_table_attach (GTK_TABLE(table), label, 0, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND, 2, 2);
  gtk_table_attach (GTK_TABLE(table), btn_yes, 0, 1, 1, 2,
		    GTK_FILL, GTK_EXPAND, 2, 2);
  gtk_table_attach (GTK_TABLE(table), btn_no, 1, 2, 1, 2,
		    GTK_FILL, GTK_EXPAND, 2, 2);

  gtk_widget_show (window);
}

int
remove_entry (const char* name, const char* file)
{
  FILE *f;
  char backup[FILENAME_MAX];
  char search_for[1024];
  char **buffer;
  int i;

  umask (0117);

  sprintf (search_for, "## GKDIAL: %s ##", name);

  f = fopen (file, "r");
  if (f == NULL)
    {
      char str[1024];

      sprintf (str, _("Error trying to clean %s. You will need to\n"
		      "edit it by hand and remove the correct entry\n"
		      "for this connection."), file);
      gk_diag (str);
      return -1;
    }

  buffer = (char**)malloc (sizeof(char*)*1);
  for (i = 1 ; !feof (f) ; i++)
    {
      buffer = (char**)realloc (buffer, sizeof(char*)*i);
      buffer[i-1] = (char*)malloc (sizeof(char)*1024);

      bzero(buffer[i-1], sizeof(char)*1024);
      
      fgets (buffer[i-1], 1024, f);

      if (strstr(buffer[i-1], search_for))
	{
	  free (buffer[i-1]);
	  i--;
	}
    }
  fclose (f);
  buffer = (char**)realloc (buffer, sizeof(char*)*i);
  buffer[i-1] = NULL;

  strncpy (backup, file, FILENAME_MAX-1);
  strcat (backup, "~");
  rename (file, backup);

  printf ("\n");

  f = fopen (file, "w");
  for (i = 0 ; buffer[i] != NULL ; i++)
    {
      printf ("i: %d - buffer[i]: %s\n", i, buffer[i]);
      fprintf (f, "%s", buffer[i]);
      free (buffer[i]);
    }
  fclose(f);
  free (buffer[i]);
  free (buffer);

  unlink (backup);

  return 0;
}

int remove_conf (GtkWidget *w, gpointer data)
{
  gchar *wich_one;
  gchar filename[FILENAME_MAX];

  wich_one = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(data)->entry));

  /*Remove peer definition */
  sprintf (filename, PEERS_DIR"/%s", wich_one);

  /* Gets the name of the user used by this connection */
  if (unlink (filename) == -1)
    {
      gk_diag (_("I could not delete the peer file.\n"
		 "Are you running as root? Only root\n"
		 "Should be able to add/remove peers"));
      return 1;
    }

  /* Remove chatscrip */
  sprintf (filename, CHAT_DIR"/%s", wich_one);
  unlink (filename);

  /* removes entry from both pap and chap secrets */
  remove_entry (wich_one, "/etc/ppp/pap-secrets");
  remove_entry (wich_one, "/etc/ppp/chap-secrets");

  /*  gk_diag (_("All went fine, the passwords stored in\n"
	     "/etc/ppp/pap-secrets or /etc/ppp/chap-secrets\n"
	     "must be removed by hand."));*/

  combo_insert_options (main_combo);

  return 0;
}
