{-# OPTIONS -#include <stdlib.h> #-}
{-# OPTIONS -#include "StdDIS_stub_ffi.h" #-}
--
-- StdDIS for GHC
--
-- (c) Thomas Nordin and Alastair Reid, 1997
--

module StdDIS
        ( StablePtr
        , ForeignObj
        , module Int
        , module Word
        , module Addr
        , module IOExts
        , MbString
        , marshall_bool_,      unmarshall_bool_
        , marshall_string_,    unmarshall_string_
        , marshall_stringLen_, unmarshall_stringLen_
        , makeStablePtr, deRefStablePtr, freeStablePtr
        , malloc, free
        , makeForeignObj
	, makeForeignObjPrim

	   -- re-exporting base Prelude types
	   -- (useful when generating source that
	   --  import StdDIS qualified.)
	, Float
	, Double
	, Word
	, Int
	, Char
        ) where


import Int
import Word
import Addr
import IOExts
import Monad( zipWithM_ )
import Foreign ( StablePtr, ForeignObj,
                 makeStablePtr, deRefStablePtr, 
                 freeStablePtr, addForeignFinalizer,
		 makeForeignObj
	       )
import ForeignObj ( mkForeignObj )

import CCall







marshall_bool_ :: Bool -> IO Int
marshall_bool_ True  = return 1
marshall_bool_ False = return 0

unmarshall_bool_ :: Int -> IO Bool
unmarshall_bool_ 0 = return False
unmarshall_bool_ _ = return True

-- Ignore "IO" part of result type

----------------------------------------------------------------
-- Strings
----------------------------------------------------------------


type MbString      = Maybe String

marshall_string_ :: [Char] -> IO Addr
marshall_string_ cs =
 do arr <- allocCharStar (1 + length cs)
    zipWithM_ (writeCharAddr arr) [0..] (cs ++ "\0")
    return arr

marshall_stringLen_ :: [Char] -> IO (Addr, Int)
marshall_stringLen_ cs =
 do let l = length cs
    arr <- allocCharStar (l+1)
    zipWithM_ (writeCharAddr arr) [0..] (cs ++ "\0")
    return (arr,l)

unmarshall_string_ :: Addr -> IO String
unmarshall_string_ ptr = reads "" 0
  where
    reads str i =
      readCharAddr ptr i >>= \c ->
      if c == '\0' then
        return (reverse str)
      else
        reads (c:str) (i+1)

unmarshall_stringLen_ :: Addr -> Int -> IO String
unmarshall_stringLen_ ptr l = mapM (readCharAddr ptr) [0..l-1]

writeCharAddr :: Addr -> Int -> Char -> IO ()
writeCharAddr s i v =
  prim_writeCharAddr s i v
foreign import  ccall "prim_writeCharAddr" unsafe prim_writeCharAddr :: Addr -> Int -> Char -> IO ()
 
readCharAddr :: Addr -> Int -> IO Char
readCharAddr s i =
  prim_readCharAddr s i
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_readCharAddr" unsafe prim_readCharAddr :: Addr -> Int -> IO (Char)

allocCharStar :: Int -> IO Addr
allocCharStar arg1 =
  prim_allocCharStar arg1
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_allocCharStar" unsafe prim_allocCharStar :: Int -> IO (Addr)

----------------------------------------------------------------
-- malloc/free
----------------------------------------------------------------


malloc :: Word32 -> IO Addr
malloc arg1 =
  prim_malloc arg1
  >>= \ gc_result ->
  access_prim_malloc_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_malloc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_malloc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_malloc" unsafe prim_malloc :: Word32 -> IO (Addr)
foreign import ccall "access_prim_malloc_res1" unsafe access_prim_malloc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_malloc_gc_failed" unsafe access_prim_malloc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_malloc_gc_failstring" unsafe access_prim_malloc_gc_failstring :: Addr -> IO (Addr)
 
free :: Addr -> IO ()
free arg1 =
  prim_free arg1
foreign import  ccall "prim_free" unsafe prim_free :: Addr -> IO ()

----------------------------------------------------------------
-- Stable pointers
----------------------------------------------------------------

--
-- Use "stable" to create a stable pointer
-- 
-- Use "stablePtr" to manipulate (previously constructed) stable pointers 
-- in Haskell.
--


----------------------------------------------------------------
-- Foreign Objects
----------------------------------------------------------------

-- %foreign will convert an Addr into a ForeignObj


-- due to recent Foreign(Obj) breakage, we're forced to
-- re-define the old version.
makeForeignObjPrim :: Addr -> Addr -> IO ForeignObj
makeForeignObjPrim obj finalizer = do
   fobj <- mkForeignObj obj
   addForeignFinalizer fobj (app0 finalizer fobj)
   return fobj

foreign import dynamic unsafe app0 :: Addr -> (ForeignObj -> IO ())

----------------------------------------------------------------
-- End of StdDIS
----------------------------------------------------------------
