module StdWindow ( Dialogs(..), module StdWindowDef
                 , closeWindow, closeActiveWindow, getActiveWindow
                 ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdWindow defines functions on windows.
--	********************************************************************************


import CleanStdMisc
import Commondef
import Controlvalidate
import Id
import IOstate
import StdControlClass
import StdWindowDef
import StdWindowAttribute
import Windowaccess
import Windowcreate
import Windowdevice
import Windowdispose
import Windowvalidate
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


--	Functions applied to non-existent windows or unknown ids have no effect.
class Dialogs ddef where
#if MVAR
	openDialog :: ddef -> GUI ErrorReport
#else
	openDialog :: ls -> ddef ls ps -> ps -> GUI ps (ErrorReport,ps)
#endif


instance (Controls c) => Dialogs (Dialog c) where
	openDialog IF_MVAR(,ls) (Dialog title controls atts) IF_MVAR(,ps)
		= do {
			IF_MVAR(,ps1 <-) dOpen windowFunctions IF_MVAR(,ps);
			maybe_okId <- validateWindowId maybe_id;
			if   isNothing maybe_okId
#if MVAR
			then return ErrorIdsInUse
#else
			then return (ErrorIdsInUse,ps1)
#endif
			else
			do {
				cs   <- controlToHandles controls;
				it   <- ioStGetIdTable;
				ioId <- accIOEnv ioStGetIOId;
				let itemHs          = map controlStateToWElementHandle cs
				    okId            = fromJust maybe_okId
				    (ok,itemHs1,it1)= controlIdsAreConsistent ioId okId itemHs it
				    it2             = if   ok
				                      then snd (addIdToIdTable okId (IdParent {idpIOId=ioId,idpDevice=WindowDevice,idpId=okId}) it1)
				                      else it1
				in
				do {
					ioStSetIdTable it2;
					if   not ok
#if MVAR
					then return ErrorIdsInUse
#else
					then return (ErrorIdsInUse,ps1)
#endif
					else 
					do {
#if MVAR
						openwindow okId (initWindowHandle title IsDialog itemHs1 atts);
						return NoError
#else
						ps2 <- openwindow okId (WindowLSHandle {wlsState=ls,wlsHandle=initWindowHandle title IsDialog itemHs1 atts}) ps1;
						return (NoError,ps2)
#endif
					}
				}
			}
		}
		where
			maybe_id = getWindowIdAttribute atts

getWindowIdAttribute :: [WindowAttribute IF_MVAR(,ls ps)] -> Maybe Id
getWindowIdAttribute atts
	| hasIdAtt  = Just (getWindowIdAtt idAtt)
	| otherwise = Nothing
	where
		(hasIdAtt,idAtt) = cselect isWindowId undef atts


{-	closeWindow closes the indicated window.
-}
closeWindow :: Id -> IF_MVAR(GUI (),ps -> GUI ps ps)
closeWindow id IF_MVAR(,ps)
	= disposeWindow (toWID id) IF_MVAR(,ps)

closeActiveWindow :: IF_MVAR(GUI (),ps -> GUI ps ps)
closeActiveWindow IF_MVAR(,ps)
	= do {
		maybeId <- getActiveWindow;
		if   isNothing maybeId
		then return IF_MVAR((),ps)
		else closeWindow (fromJust maybeId) IF_MVAR(,ps)
	  }


{-	getActiveWindow returns the Id of the currently active window.
-}
getActiveWindow :: GUI IF_MVAR(,ps) (Maybe Id)
getActiveWindow
	= do {
		(found,wDevice) <- accIOEnv (ioStGetDevice WindowDevice);
		if   not found
		then return Nothing
		else let
			windows               = windowSystemStateGetWindowHandles wDevice
			(activeWIDS,windows1) = getWindowHandlesActiveWindow windows
		in do {
			appIOEnv (ioStSetDevice (WindowSystemState windows1));
			return (fmap wId activeWIDS)
		   }
	  }
