module CleanStdTuple where

--	********************************************************************************
--	Clean to Haskell Standard Env library.
--	
--	CleanStdTuple defines all functions in Clean StdTuple (StdEnv) that are
--	not member of the Haskell Prelude. 
--	********************************************************************************

-- Standard Functions on Tuples:

fst3 :: (a,b,c) -> a
fst3 (t1, _, _) = t1

snd3 :: (a,b,c) -> b
snd3 (_, t2, _) = t2

thd3 :: (a,b,c) -> c
thd3 (_, _, t3) = t3

app2 :: (a -> b,c -> d) -> (a,c) -> (b,d)
app2 (f1, f2) (x1,x2) = (f1 x1,f2 x2)

app3 :: (a -> b,c -> d,e -> f) -> (a,c,e) -> (b,d,f)
app3 (f1, f2, f3) (x1,x2,x3) = (f1 x1,f2 x2,f3 x3)
