# ##############################################################################
# $Id: boilerplate.mk,v 1.9.2.1 2002/01/04 11:13:52 simonmar Exp $
#
# Hslibs boilerplate.mk
# (c) The GHC Team 1999
# #############################################################################


# Begin by slurping in the boilerplate from one level up.
# Remember, TOP is the top level of the innermost level
# (FPTOOLS_TOP is the fptools top)

# We need to set TOP to be the TOP that the next level up expects!
# The TOP variable is reset after the inclusion of the fptools
# boilerplate, so we stash TOP away first:
HSLIBS_TOP := $(TOP)
TOP:=$(TOP)/..

# Include version.mk so that libdir &c. are set for GHC's make install.
# Should really test $(HsLibsFor) here and include relative to FPTOOLS_TOP,
# but they're not defined until $(TOP)/mk/boilerplate.mk is read.

-include $(TOP)/ghc/mk/version.mk
include $(TOP)/mk/boilerplate.mk

# Reset TOP
TOP:=$(HSLIBS_TOP)

# -----------------------------------------------------------------
# Everything after this point
# augments or overrides previously set variables.
# -----------------------------------------------------------------

-include $(TOP)/mk/paths.mk
-include $(TOP)/mk/opts.mk
-include $(TOP)/mk/suffix.mk

# Urk! ToDo.
GHC_INCLUDE_DIR=$(FPTOOLS_TOP)/ghc/includes
GHC_LIB_DIR=$(FPTOOLS_TOP)/ghc/lib
GHC_IO_INCLUDE_DIR=$(GHC_LIB_DIR)/std/cbits
