{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 3.4 (Line Segments) of the OpenGL 1.2.1
specs.
-}

module GL_LineSeg (
   lineWidth, LineSmooth(..),
   lineStipple, LineStipple(..)
) where

import GL_Constants     (gl_LINE_SMOOTH, gl_LINE_STIPPLE)
import GL_BasicTypes    (GLushort, GLint, GLfloat, Capability(..))

---------------------------------------------------------------------------

foreign import "glLineWidth" unsafe lineWidth :: GLfloat -> IO ()

data LineSmooth = LineSmooth deriving (Eq,Ord)

instance Capability LineSmooth where
   marshalCapability LineSmooth = gl_LINE_SMOOTH

---------------------------------------------------------------------------
-- Section 3.4.2. (Other Line Segments Features)

foreign import "glLineStipple" unsafe lineStipple :: GLint -> GLushort -> IO ()

data LineStipple = LineStipple deriving (Eq,Ord)

instance Capability LineStipple where
   marshalCapability LineStipple = gl_LINE_STIPPLE
