/*
Header to support the inclusion of GPC compiled code into C programs

Author: Frank Heckenbach <frank@pascal.gnu.de>

Released to the public domain.
*/

#ifndef __GPC_IN_C_H
#define __GPC_IN_C_H

/*
  If you want to call GPC compiled code from C programs where the C
  code contains the `main' function, you need to call the following
  Pascal routines from your C code.

  Furthermore, you have to tell GPC not to create a `main' function.
  You do this with the command line option `--gpc-main=Dummy' to GPC
  or the compiler directive `{$gpc-main=Dummy}' in the Pascal
  program's source.

  GPC will then create a function called `Dummy' instead of `main'.
  Don't call this function from your C code. It would call the three
  routines mentioned here and the Pascal main program in a row (just
  like `main' does in normal GPC compiled programs), and give you no
  chance to do anything in between. If you call the three routines
  explicitly, you can safely ignore `Dummy'. (You can choose any
  other name instead of `Dummy' as long as it doesn't conflict with
  your global C symbols.)

  For a complete example, see the demo program `gpc_c_pas.pas',
  together with `gpc_c_unit.pas' and `gpc_c_c.c'.
*/

/*
  _p_initialize() (part of GPC's Run Time System) must be called
  before calling any routines written in Pascal, including the
  Pascal initializers (see below), unless you know very well what
  you're doing. The meaning of the parameters should be obvious to
  any C programmer. envp can be omitted (i.e., passed as NULL) if
  your system supports the `environ' variable. If you don't know if
  it does, you can check HAVE_ENVIRON in p/rts/rts-config.h after
  building GPC on your system.
*/
extern void _p_initialize (int argc, char **argv, char **envp);

/*
  If there is a Pascal program, init_pascal_main_program() is
  generated by GPC. It initializes the main program's and all
  units' and modules' variables, and runs all unit and module
  initializers.

  If you have a unit or module called `foo' written in Pascal, you
  can declare

  extern void init_Foo ();

  instead (note the case) and call it to initialize the variables
  and run the constructors of the mentioned unit/module and all
  units/modules used by it.
*/
extern void init_pascal_main_program ();

/*
  _p_finalize() (also part of GPC's Run Time System) should be
  called at the end of the program to run all units' and modules'
  finalizers and clean up the RTS (otherwise, e.g., some files might
  not get flushed). After calling it, you should not call any
  routines written in Pascal.
*/
extern void _p_finalize ();

#endif
