program fjf395;

uses GPC;

type
  ta = ByteBool;
  tb = ShortBool;
  tc = WordBool;
  td = MedBool;
  te = LongBool;
  tf = LongestBool;
  tg = Boolean (1);
  th = Boolean (15);
  ti = Boolean (42);
  tj = Boolean (64);

var
  aa : ByteCard;
  ab : ShortCard;
  ac : Cardinal;
  ad : MedCard;
  ae : LongCard;
  af : LongestCard;
  ag : Cardinal (1);
  ah : Cardinal (15);
  ai : Cardinal (42);
  aj : Cardinal (64);
  t  : Cardinal = 42;

procedure Error (const Msg : String);
begin
  Writeln (Msg);
  Halt
end;

{$define TEST(x)
  var b##x : t##x;
  if (SizeOf (b##x) <> SizeOf (a##x))
    or (BitSizeOf (b##x) <> BitSizeOf (a##x))
    or (AlignOf (b##x) <> AlignOf (a##x)) then Error (#x + ' Size');
  b##x := False;  if Ord (b##x) <> 0 then Error (#x + ' False 1');
  b##x := t < 42; if Ord (b##x) <> 0 then Error (#x + ' False 2');
  b##x := True;   if Ord (b##x) <> 1 then Error (#x + ' True 1');
  b##x := t = 42; if Ord (b##x) <> 1 then Error (#x + ' True 2');
  for a##x := Max (-999, Low (a##x)) to Min (999, High (a##x)) do
    begin
      b##x := t##x (a##x);
      if b##x xor (a##x <> 0) then Error (#x + ' Value ' + Integer2String (a##x));
      if Ord (b##x) <> a##x then Error (#x + ' Ord ' + Integer2String (a##x))
    end;
}

begin
  TEST (a);
  TEST (b);
  TEST (c);
  TEST (d);
  TEST (e);
  TEST (f);
  TEST (g);
  TEST (h);
  TEST (i);
  TEST (j);
  Writeln ('OK')
end.
