/* 
   gcardscheme - GNOME applet to control PCMCIA card schemes
   
   Copyright (C) 2000 Brian Bassett

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

GtkWidget*
create_select (void)
{
  GtkWidget *select;
  GtkWidget *dialog_vbox;
  GtkWidget *frame;
  GtkWidget *scrolling;
  GtkWidget *list;
  GtkWidget *label2;
  GtkWidget *dialog_action_area;
  GtkWidget *okButton;
  GtkWidget *cancelButton;

  select = gnome_dialog_new (_("Select Scheme"), NULL);
  gtk_widget_set_name (select, "select");
  gtk_object_set_data (GTK_OBJECT (select), "select", select);
  gnome_dialog_close_hides (GNOME_DIALOG (select), TRUE);

  dialog_vbox = GNOME_DIALOG (select)->vbox;
  gtk_widget_set_name (dialog_vbox, "dialog_vbox");
  gtk_object_set_data (GTK_OBJECT (select), "dialog_vbox", dialog_vbox);
  gtk_widget_show (dialog_vbox);

  frame = gtk_frame_new (_("PC Card Schemes"));
  gtk_widget_set_name (frame, "frame");
  gtk_widget_ref (frame);
  gtk_object_set_data_full (GTK_OBJECT (select), "frame", frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame, TRUE, TRUE, 0);

  scrolling = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolling, "scrolling");
  gtk_widget_ref (scrolling);
  gtk_object_set_data_full (GTK_OBJECT (select), "scrolling", scrolling,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolling);
  gtk_container_add (GTK_CONTAINER (frame), scrolling);
  gtk_container_set_border_width (GTK_CONTAINER (scrolling), 6);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolling), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  list = gtk_clist_new (1);
  gtk_widget_set_name (list, "list");
  gtk_widget_ref (list);
  gtk_object_set_data_full (GTK_OBJECT (select), "list", list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list);
  gtk_container_add (GTK_CONTAINER (scrolling), list);
  gtk_clist_set_column_width (GTK_CLIST (list), 0, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (list));

  label2 = gtk_label_new (_("label2"));
  gtk_widget_set_name (label2, "label2");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (select), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_clist_set_column_widget (GTK_CLIST (list), 0, label2);

  dialog_action_area = GNOME_DIALOG (select)->action_area;
  gtk_widget_set_name (dialog_action_area, "dialog_action_area");
  gtk_object_set_data (GTK_OBJECT (select), "dialog_action_area", dialog_action_area);
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area), 8);

  gnome_dialog_append_button (GNOME_DIALOG (select), GNOME_STOCK_BUTTON_OK);
  okButton = g_list_last (GNOME_DIALOG (select)->buttons)->data;
  gtk_widget_set_name (okButton, "okButton");
  gtk_widget_ref (okButton);
  gtk_object_set_data_full (GTK_OBJECT (select), "okButton", okButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (okButton);
  GTK_WIDGET_SET_FLAGS (okButton, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (select), GNOME_STOCK_BUTTON_CANCEL);
  cancelButton = g_list_last (GNOME_DIALOG (select)->buttons)->data;
  gtk_widget_set_name (cancelButton, "cancelButton");
  gtk_widget_ref (cancelButton);
  gtk_object_set_data_full (GTK_OBJECT (select), "cancelButton", cancelButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancelButton);
  GTK_WIDGET_SET_FLAGS (cancelButton, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (list), "select_row",
                      GTK_SIGNAL_FUNC (list_select),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (list), "unselect_row",
                      GTK_SIGNAL_FUNC (list_unselect),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (okButton), "clicked",
                      GTK_SIGNAL_FUNC (select_ok),
                      select);
  gtk_signal_connect (GTK_OBJECT (cancelButton), "clicked",
                      GTK_SIGNAL_FUNC (select_cancel),
                      select);

  return select;
}

GtkWidget*
create_about (void)
{
  const gchar *authors[] = {
    "Brian Bassett <bbassett@bbassett.net>",
    "http://www.bbassett.net/linux/gcardscheme.html",
    NULL
  };
  GtkWidget *about;

  about = gnome_about_new ("GCardScheme", VERSION,
                        _("(C) 2000 Brian Bassett"),
                        authors,
                        _("A GNOME panel applet to change the PCMCIA-CS card scheme."),
                        NULL);
  gtk_widget_set_name (about, "about");
  gtk_object_set_data (GTK_OBJECT (about), "about", about);
  gtk_window_set_modal (GTK_WINDOW (about), TRUE);

  return about;
}

GtkWidget*
create_add_remove (void)
{
  GtkWidget *add_remove;
  GtkWidget *notebook;
  GtkWidget *hbox;
  GtkWidget *scrolledwindow1;
  GtkWidget *list;
  GtkWidget *label1;
  GtkWidget *buttons;
  GtkWidget *addButton;
  GtkWidget *removeButton;
  GtkWidget *label;

  add_remove = gnome_property_box_new ();
  gtk_widget_set_name (add_remove, "add_remove");
  gtk_object_set_data (GTK_OBJECT (add_remove), "add_remove", add_remove);
  gtk_widget_set_usize (add_remove, -2, 300);

  notebook = GNOME_PROPERTY_BOX (add_remove)->notebook;
  gtk_widget_set_name (notebook, "notebook");
  gtk_object_set_data (GTK_OBJECT (add_remove), "notebook", notebook);
  gtk_widget_show (notebook);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox, "hbox");
  gtk_widget_ref (hbox);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "hbox", hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (notebook), hbox);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox), scrolledwindow1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 6);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  list = gtk_clist_new (1);
  gtk_widget_set_name (list, "list");
  gtk_widget_ref (list);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "list", list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), list);
  gtk_clist_set_column_width (GTK_CLIST (list), 0, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (list));

  label1 = gtk_label_new (_("label1"));
  gtk_widget_set_name (label1, "label1");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_clist_set_column_widget (GTK_CLIST (list), 0, label1);

  buttons = gtk_vbutton_box_new ();
  gtk_widget_set_name (buttons, "buttons");
  gtk_widget_ref (buttons);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "buttons", buttons,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttons);
  gtk_box_pack_start (GTK_BOX (hbox), buttons, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (buttons), GTK_BUTTONBOX_START);

  addButton = gtk_button_new_with_label (_("Add Scheme..."));
  gtk_widget_set_name (addButton, "addButton");
  gtk_widget_ref (addButton);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "addButton", addButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (addButton);
  gtk_container_add (GTK_CONTAINER (buttons), addButton);
  GTK_WIDGET_SET_FLAGS (addButton, GTK_CAN_DEFAULT);

  removeButton = gtk_button_new_with_label (_("Remove Scheme..."));
  gtk_widget_set_name (removeButton, "removeButton");
  gtk_widget_ref (removeButton);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "removeButton", removeButton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (removeButton);
  gtk_container_add (GTK_CONTAINER (buttons), removeButton);
  GTK_WIDGET_SET_FLAGS (removeButton, GTK_CAN_DEFAULT);

  label = gtk_label_new (_("PC Card Schemes"));
  gtk_widget_set_name (label, "label");
  gtk_widget_ref (label);
  gtk_object_set_data_full (GTK_OBJECT (add_remove), "label", label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);

  gtk_signal_connect (GTK_OBJECT (add_remove), "apply",
                      GTK_SIGNAL_FUNC (apply_schemes),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (list), "select_row",
                      GTK_SIGNAL_FUNC (list_select),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (list), "unselect_row",
                      GTK_SIGNAL_FUNC (list_unselect),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (addButton), "clicked",
                      GTK_SIGNAL_FUNC (add_remove_add),
                      add_remove);
  gtk_signal_connect (GTK_OBJECT (removeButton), "clicked",
                      GTK_SIGNAL_FUNC (add_remove_remove),
                      add_remove);

  return add_remove;
}

GtkWidget*
create_add_newname (void)
{
  GtkWidget *add_newname;
  GtkWidget *dialog_vbox3;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *dialog_action_area3;
  GtkWidget *ok;
  GtkWidget *cancel;

  add_newname = gnome_dialog_new (_("Add Scheme"), NULL);
  gtk_widget_set_name (add_newname, "add_newname");
  gtk_object_set_data (GTK_OBJECT (add_newname), "add_newname", add_newname);
  GTK_WINDOW (add_newname)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_default_size (GTK_WINDOW (add_newname), 375, -1);
  gtk_window_set_policy (GTK_WINDOW (add_newname), TRUE, TRUE, FALSE);

  dialog_vbox3 = GNOME_DIALOG (add_newname)->vbox;
  gtk_widget_set_name (dialog_vbox3, "dialog_vbox3");
  gtk_object_set_data (GTK_OBJECT (add_newname), "dialog_vbox3", dialog_vbox3);
  gtk_widget_show (dialog_vbox3);

  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (box, "box");
  gtk_widget_ref (box);
  gtk_object_set_data_full (GTK_OBJECT (add_newname), "box", box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (box);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), box, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (box), 5);

  label = gtk_label_new (_("Enter name of new scheme:"));
  gtk_widget_set_name (label, "label");
  gtk_widget_ref (label);
  gtk_object_set_data_full (GTK_OBJECT (add_newname), "label", label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 7.45058e-09, 0.5);

  entry = gtk_entry_new ();
  gtk_widget_set_name (entry, "entry");
  gtk_widget_ref (entry);
  gtk_object_set_data_full (GTK_OBJECT (add_newname), "entry", entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (box), entry, FALSE, FALSE, 5);

  dialog_action_area3 = GNOME_DIALOG (add_newname)->action_area;
  gtk_widget_set_name (dialog_action_area3, "dialog_action_area3");
  gtk_object_set_data (GTK_OBJECT (add_newname), "dialog_action_area3", dialog_action_area3);
  gtk_widget_show (dialog_action_area3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area3), 8);

  gnome_dialog_append_button (GNOME_DIALOG (add_newname), GNOME_STOCK_BUTTON_OK);
  ok = g_list_last (GNOME_DIALOG (add_newname)->buttons)->data;
  gtk_widget_set_name (ok, "ok");
  gtk_widget_ref (ok);
  gtk_object_set_data_full (GTK_OBJECT (add_newname), "ok", ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ok);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (add_newname), GNOME_STOCK_BUTTON_CANCEL);
  cancel = g_list_last (GNOME_DIALOG (add_newname)->buttons)->data;
  gtk_widget_set_name (cancel, "cancel");
  gtk_widget_ref (cancel);
  gtk_object_set_data_full (GTK_OBJECT (add_newname), "cancel", cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);

  return add_newname;
}

