/* 
   gcardscheme - GNOME applet to control PCMCIA card schemes
   
   Copyright (C) 2000 Brian Bassett

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#include <unistd.h>

int
main (int argc, char **argv)
{
    int ruid, euid, result;
    
    /* Check the arguments */
    if (argc != 2)
	exit (10);	/* Must call with exactly one parameter */

    /* Make our uid 0 by swapping uid <-> euid. */
    ruid = getuid ();
    euid = geteuid ();
    result = setreuid (euid, ruid);
    if (result != 0)
	exit (11);	/* Something went wrong with the permissions */
	
    /* Exec the real thing */
    execl (CARDCTL, "cardctl", "scheme", argv[1], (char *)0);
    _exit (126);
}
