/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"


extern char global_hwaddr[1024];
extern char global_ipaddr[1024];
extern char global_hostname[1024];


void select_first_host(struct w *widgets)
{
    GtkTreePath *path;
    GtkTreeIter iter;
    GtkTreeModel *list_store;
    gchar *hostname=NULL, *ipaddr=NULL, *hwaddr=NULL;

    path = gtk_tree_path_new_first();
    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(widgets->host_treeview));

    if( ! gtk_tree_model_get_iter(list_store, &iter, path) )
    {
	gtk_tree_path_free(path);
        return;
    }
    
    gtk_tree_model_get(list_store, &iter, 0, &hostname, -1);
    gtk_tree_model_get(list_store, &iter, 1, &ipaddr, -1);
    gtk_tree_model_get(list_store, &iter, 2, &hwaddr, -1);

    if( hostname==NULL || ipaddr==NULL || hwaddr==NULL )
      return;

    snprintf(global_hostname, 1000, "%s", (gchar *)hostname);
    snprintf(global_ipaddr, 1000, "%s", (gchar *)ipaddr);
    snprintf(global_hwaddr, 1000, "%s", (gchar *)hwaddr);

    g_free(hostname);
    g_free(ipaddr);
    g_free(hwaddr);
}
