/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "reread_conf.h"
#include "commented.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;



/* Deletes the selected scope and any corresponding failover peer decl */
void delete_scope(struct w *widgets)
{
    FILE *fp;
    long conf_size = 0;
    long old_pos = 0;
    int found_scope = 0;
    int i, found_failover = 0;
    char *line;
    char *new_conf;
    char *line_from;
    char *line_to;
    char *failover_decl;
    gchar *info;

    line_from = allocate(MAX_CONF_LINE+1);
    line_to = allocate(MAX_CONF_LINE+1);

    /* 3 different styles ...\n{ or ...{ or ... { */
    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    if( strlen(global_nic)==0 || strlen(global_subnet)==0 || strlen(global_netmask)==0 )
    {
       info = g_strdup_printf(_("Missing values in delete scope, scope not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line = allocate(conf_size+1);

    /* Find the correct scope position */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;
    
	if( strstr(line, scope_line1) || strstr(line, scope_line2) || strstr(line, scope_line3) )
	{
	    old_pos = ftell(fp);

	    /* We expect to find the interface decl on the second line */
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( commented(line) )
		  continue;
	    
		if( strstr(line, nic_line) )
		{
	    	    found_scope = 1;
		    break;
		}
	    }
	}

	if( found_scope )
	  break;
    }

    free(line_from);
    free(line_to);
    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);


    rewind(fp);


    failover_decl = allocate(1024);

    /* We have the scopes begin position, now get everything up to it */
    if( found_scope && conf_size > 1 )
    {
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    /* We are at the beginning of the correct scope, scroll past it */
	    if( ftell(fp) == old_pos )
	    {
		while(fgets(line, conf_size, fp)!=NULL)
		{
		    /* Scroll past pool decls but save any "failover peer ..." lines.
		       So we can delete the failover later */
		    if( strstr(line, "pool {") )
		    while(fgets(line, conf_size, fp)!=NULL)
		    {
			/* Save failover peer line */
			if( strstr(line, "failover peer") )
			{
			    found_failover = 1;
			      
			    for(i=1; line[i]!='\0'; i++)
			      if( line[i]!=' ' )
				break;
			      
			    snprintf(failover_decl, 1000, "%s", &line[i]);

			    failover_decl[strlen(failover_decl)-2]='\0';
			}
			  
		        if( strstr(line, "}") && strlen(line) < 3 )
		          break;
		    }
		      
		    /* Break at subnet end */
		    if( strstr(line, "}") && strlen(line) < 3 )
		      break;
		}
	    }
	    else
	      strcat(new_conf, line);
	}
    }

    
    /* Get everything else */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
      strcat(new_conf, line);

    fclose(fp);
    

    /* If the scope is found and deleted, write the new conf */
    if( found_scope )
    {
	if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
	{
    	    printf("Couldnt write: %s\n", DHCPD_CONF_BUF);
	    free(new_conf);
	    free(line);
	    free(failover_decl);
    	    return;
	}
	fputs(new_conf, fp);
	fclose(fp);
    }

    free(new_conf);
    free(line);


    /* If the scope had a failover configuration we must remove it properly */
    if( ! found_failover )
    {
	free(failover_decl);
        return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
	free(failover_decl);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line = allocate(conf_size+1);

    /* Find and remove the failover declaration */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	/* Beginning of failover decl found, scroll past it */
	if( strstr(line, failover_decl) && strstr(line, "{") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    if( strstr(line, "}") )
	      break;
	}
	else	
	  strcat(new_conf, line);
    }
    fclose(fp);

    /* Write the new configuration */
    if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
    {
        printf("Couldnt write: %s\n", DHCPD_CONF_BUF);
	free(line);
	free(new_conf);
	free(failover_decl);
        return;
    }
    fputs(new_conf, fp);
    fclose(fp);

    free(line);
    free(new_conf);
    free(failover_decl);
}
