/* callhandler.c generated by valac 0.14.2, the Vala compiler
 * generated from callhandler.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsogsm.h>
#include <gee.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <freesmartphone.h>
#include <fsotransport.h>
#include <msmcomm-specs.h>


#define TYPE_MSM_CALL_HANDLER (msm_call_handler_get_type ())
#define MSM_CALL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_CALL_HANDLER, MsmCallHandler))
#define MSM_CALL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_CALL_HANDLER, MsmCallHandlerClass))
#define IS_MSM_CALL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_CALL_HANDLER))
#define IS_MSM_CALL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_CALL_HANDLER))
#define MSM_CALL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_CALL_HANDLER, MsmCallHandlerClass))

typedef struct _MsmCallHandler MsmCallHandler;
typedef struct _MsmCallHandlerClass MsmCallHandlerClass;
typedef struct _MsmCallHandlerPrivate MsmCallHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fso_framework_pair_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_pair_unref (var), NULL)))

#define TYPE_MSM_CHANNEL (msm_channel_get_type ())
#define MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_CHANNEL, MsmChannel))
#define MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_CHANNEL, MsmChannelClass))
#define IS_MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_CHANNEL))
#define IS_MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_CHANNEL))
#define MSM_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_CHANNEL, MsmChannelClass))

typedef struct _MsmChannel MsmChannel;
typedef struct _MsmChannelClass MsmChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_gsm_call_unref0(var) ((var == NULL) ? NULL : (var = (fso_gsm_call_unref (var), NULL)))
typedef struct _MsmChannelPrivate MsmChannelPrivate;

#define TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER (msm_unsolicited_response_handler_get_type ())
#define MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandler))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))

typedef struct _MsmUnsolicitedResponseHandler MsmUnsolicitedResponseHandler;
typedef struct _MsmUnsolicitedResponseHandlerClass MsmUnsolicitedResponseHandlerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MsmCallHandlerActivateData MsmCallHandlerActivateData;

#define TYPE_MSM_URC_TYPE (msm_urc_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __vala_MsmcommCallStatusInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_MsmcommCallStatusInfo_free (var), NULL)))
typedef struct _MsmCallHandlerInitiateData MsmCallHandlerInitiateData;
typedef struct _MsmCallHandlerHoldData MsmCallHandlerHoldData;
typedef struct _MsmCallHandlerReleaseData MsmCallHandlerReleaseData;
typedef struct _msm_call_handler_releaseAllData msm_call_handler_releaseAllData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _msm_call_handler_cancelOutgoingWithIdData msm_call_handler_cancelOutgoingWithIdData;
typedef struct _msm_call_handler_rejectIncomingWithIdData msm_call_handler_rejectIncomingWithIdData;
typedef struct _msm_call_handler_setCallAudioStatusData msm_call_handler_setCallAudioStatusData;

struct _MsmCallHandler {
	FsoGsmAbstractCallHandler parent_instance;
	MsmCallHandlerPrivate * priv;
	GeeHashMap* calls;
	FsoFrameworkPair* supplementary;
};

struct _MsmCallHandlerClass {
	FsoGsmAbstractCallHandlerClass parent_class;
};

struct _MsmChannel {
	FsoFrameworkAbstractObject parent_instance;
	MsmChannelPrivate * priv;
	gchar* name;
	MsmUnsolicitedResponseHandler* urc_handler;
	MsmcommManagement* management_service;
	MsmcommState* state_service;
	MsmcommMisc* misc_service;
	MsmcommCall* call_service;
	MsmcommSim* sim_service;
	MsmcommPhonebook* phonebook_service;
	MsmcommNetwork* network_service;
	MsmcommSound* sound_service;
	MsmcommSms* sms_service;
};

struct _MsmChannelClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _MsmCallHandlerActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gint id;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GeeHashMap* _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	GError* _tmp13_;
	gboolean _tmp14_;
	GeeHashMap* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	FsoGsmCall* _tmp18_;
	FreeSmartphoneGSMCallDetail _tmp19_;
	FreeSmartphoneGSMCallStatus _tmp20_;
	gboolean _tmp21_;
	GeeHashMap* _tmp22_;
	gint _tmp23_;
	gpointer _tmp24_;
	FsoGsmCall* _tmp25_;
	FreeSmartphoneGSMCallDetail _tmp26_;
	FreeSmartphoneGSMCallStatus _tmp27_;
	gboolean _tmp28_;
	GError* _tmp29_;
	gint _tmp30_;
	MsmChannel* _tmp31_;
	MsmcommCall* _tmp32_;
	gint _tmp33_;
	GError* _tmp34_;
	GError* _error_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* msg;
	const gchar* _tmp39_;
	GError* _tmp40_;
	GError * _inner_error_;
};

typedef enum  {
	MSM_URC_TYPE_INVALID,
	MSM_URC_TYPE_RESET_RADIO_IND,
	MSM_URC_TYPE_CALL_ORIGINATION,
	MSM_URC_TYPE_EXTENDED_FILE_INFO,
	MSM_URC_TYPE_NETWORK_STATE_INFO,
	MSM_URC_TYPE_OPERATION_MODE,
	MSM_URC_TYPE_PIN1_VERIFIED
} MsmUrcType;

struct _MsmCallHandlerInitiateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gchar* number;
	gchar* ctype;
	gint result;
	gint num;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	gint _tmp2_;
	GError* _tmp3_;
	FsoFrameworkLogger* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	MsmChannel* _tmp10_;
	MsmcommCall* _tmp11_;
	const gchar* _tmp12_;
	FsoFrameworkLogger* _tmp13_;
	gboolean _tmp14_;
	MsmChannel* _tmp15_;
	MsmUnsolicitedResponseHandler* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	MsmcommCallStatusInfo* _tmp19_;
	MsmcommCallStatusInfo* _tmp25_;
	MsmcommCallStatusInfo* call_info;
	FsoFrameworkLogger* _tmp26_;
	guint _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	guint _tmp33_;
	FsoGsmCall* _tmp34_;
	FsoGsmCall* call;
	GeeHashMap* _tmp35_;
	guint _tmp36_;
	GError* _error_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* msg;
	const gchar* _tmp41_;
	GError* _tmp42_;
	GError * _inner_error_;
};

struct _MsmCallHandlerHoldData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	gint _tmp2_;
	GError* _tmp3_;
	gint _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _error_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* msg;
	GError* _tmp10_;
	GError * _inner_error_;
};

struct _MsmCallHandlerReleaseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gint id;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GeeHashMap* _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	GError* _tmp13_;
	GeeHashMap* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	FsoGsmCall* _tmp17_;
	FreeSmartphoneGSMCallDetail _tmp18_;
	FreeSmartphoneGSMCallStatus _tmp19_;
	gboolean _tmp20_;
	GError* _tmp21_;
	GeeHashMap* _tmp22_;
	gint _tmp23_;
	gpointer _tmp24_;
	FsoGsmCall* _tmp25_;
	FreeSmartphoneGSMCallDetail _tmp26_;
	FreeSmartphoneGSMCallStatus _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gint _tmp31_;
	GeeHashMap* _tmp32_;
	gint _tmp33_;
	gpointer _tmp34_;
	FsoGsmCall* _tmp35_;
	FreeSmartphoneGSMCallDetail _tmp36_;
	FreeSmartphoneGSMCallStatus _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	MsmChannel* _tmp40_;
	MsmcommCall* _tmp41_;
	gint _tmp42_;
	GError* _error_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* msg;
	const gchar* _tmp47_;
	GError* _tmp48_;
	GError * _inner_error_;
};

struct _msm_call_handler_releaseAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
};

struct _msm_call_handler_cancelOutgoingWithIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gint id;
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GeeHashMap* _tmp17_;
	gint _tmp18_;
	gpointer _tmp19_;
	FsoGsmCall* call;
	FsoGsmModem* _tmp20_;
	FsoGsmChannel* _tmp21_;
	MsmChannel* channel;
	FsoGsmCall* _tmp22_;
	FreeSmartphoneGSMCallDetail _tmp23_;
	FreeSmartphoneGSMCallStatus _tmp24_;
	MsmChannel* _tmp25_;
	MsmcommCall* _tmp26_;
	gint _tmp27_;
	FsoGsmCall* _tmp28_;
	FreeSmartphoneGSMCallDetail _tmp29_;
	FreeSmartphoneGSMCallStatus _tmp30_;
	MsmChannel* _tmp31_;
	MsmcommCall* _tmp32_;
	gint _tmp33_;
	GError* _error_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* msg;
	const gchar* _tmp38_;
	GError* _tmp39_;
	GError * _inner_error_;
};

struct _msm_call_handler_rejectIncomingWithIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gint id;
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	FsoGsmModem* _tmp7_;
	FsoGsmChannel* _tmp8_;
	MsmChannel* channel;
	GeeHashMap* _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	MsmChannel* _tmp19_;
	MsmcommCall* _tmp20_;
	gint _tmp21_;
	GError* _error_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* msg;
	const gchar* _tmp26_;
	GError* _tmp27_;
	GError * _inner_error_;
};

struct _msm_call_handler_setCallAudioStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmCallHandler* self;
	gboolean active;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	MsmChannel* _tmp2_;
	gboolean _tmp3_;
	MsmChannel* _tmp4_;
	MsmcommSound* _tmp5_;
	GError* _error_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_;
};


static gpointer msm_call_handler_parent_class = NULL;
static GType msm_call_handler_type_id = 0;

#define CALL_STATUS_REFRESH_TIMEOUT 3
GType msm_call_handler_get_type (void) G_GNUC_CONST;
GType msm_call_handler_register_type (GTypeModule * module);
enum  {
	MSM_CALL_HANDLER_DUMMY_PROPERTY
};
MsmCallHandler* msm_call_handler_new (void);
MsmCallHandler* msm_call_handler_construct (GType object_type);
static gchar* msm_call_handler_real_repr (FsoFrameworkAbstractObject* base);
static void msm_call_handler_real_addSupplementaryInformation (FsoGsmAbstractCallHandler* base, const gchar* direction, const gchar* info);
static void msm_call_handler_real_activate_data_free (gpointer _data);
static void msm_call_handler_real_activate (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_activate_co (MsmCallHandlerActivateData* _data_);
GType msm_channel_get_type (void) G_GNUC_CONST;
GType msm_channel_register_type (GTypeModule * module);
static gint msm_call_handler_numberOfBusyCalls (MsmCallHandler* self);
GType msm_unsolicited_response_handler_get_type (void) G_GNUC_CONST;
GType msm_unsolicited_response_handler_register_type (GTypeModule * module);
static void msm_call_handler_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_call_handler_real_initiate_data_free (gpointer _data);
static void msm_call_handler_real_initiate (FsoGsmAbstractCallHandler* base, const gchar* number, const gchar* ctype, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_initiate_co (MsmCallHandlerInitiateData* _data_);
static void msm_call_handler_initiate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType msm_urc_type_get_type (void) G_GNUC_CONST;
void msm_unsolicited_response_handler_waitForUnsolicitedResponse (MsmUnsolicitedResponseHandler* self, MsmUrcType type, gint timeout, GSourceFunc timeout_func, void* timeout_func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* msm_unsolicited_response_handler_waitForUnsolicitedResponse_finish (MsmUnsolicitedResponseHandler* self, GAsyncResult* _res_);
static MsmcommCallStatusInfo* _variant_get4 (GVariant* value);
static void msm_call_handler_setCallAudioStatus (MsmCallHandler* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_call_handler_setCallAudioStatus_finish (MsmCallHandler* self, GAsyncResult* _res_);
static void _vala_MsmcommCallStatusInfo_free (MsmcommCallStatusInfo* self);
static void msm_call_handler_real_hold_data_free (gpointer _data);
static void msm_call_handler_real_hold (FsoGsmAbstractCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_hold_co (MsmCallHandlerHoldData* _data_);
static gint msm_call_handler_numberOfCallsWithStatus (MsmCallHandler* self, FreeSmartphoneGSMCallStatus status);
static void msm_call_handler_real_release_data_free (gpointer _data);
static void msm_call_handler_real_release (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_release_co (MsmCallHandlerReleaseData* _data_);
static void msm_call_handler_release_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_call_handler_real_releaseAll_data_free (gpointer _data);
static void msm_call_handler_real_releaseAll (FsoGsmAbstractCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_releaseAll_co (msm_call_handler_releaseAllData* _data_);
static void msm_call_handler_real_handleIncomingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void msm_call_handler_real_handleConnectingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info);
static void msm_call_handler_real_handleEndingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info);
static void msm_call_handler_real_startTimeoutIfNecessary (FsoGsmAbstractCallHandler* base);
static void msm_call_handler_real_cancelOutgoingWithId_data_free (gpointer _data);
static void msm_call_handler_real_cancelOutgoingWithId (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_cancelOutgoingWithId_co (msm_call_handler_cancelOutgoingWithIdData* _data_);
static void msm_call_handler_cancelOutgoingWithId_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_call_handler_real_rejectIncomingWithId_data_free (gpointer _data);
static void msm_call_handler_real_rejectIncomingWithId (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_call_handler_real_rejectIncomingWithId_co (msm_call_handler_rejectIncomingWithIdData* _data_);
static void msm_call_handler_rejectIncomingWithId_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_call_handler_setCallAudioStatus_data_free (gpointer _data);
static gboolean msm_call_handler_setCallAudioStatus_co (msm_call_handler_setCallAudioStatusData* _data_);
static void msm_call_handler_setCallAudioStatus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_call_handler_finalize (GObject* obj);


MsmCallHandler* msm_call_handler_construct (GType object_type) {
	MsmCallHandler * self = NULL;
	GeeHashMap* _tmp0_;
	self = (MsmCallHandler*) fso_gsm_abstract_call_handler_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, FSO_GSM_TYPE_CALL, (GBoxedCopyFunc) fso_gsm_call_ref, fso_gsm_call_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->calls);
	self->calls = _tmp0_;
	return self;
}


MsmCallHandler* msm_call_handler_new (void) {
	return msm_call_handler_construct (TYPE_MSM_CALL_HANDLER);
}


static gchar* msm_call_handler_real_repr (FsoFrameworkAbstractObject* base) {
	MsmCallHandler * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (MsmCallHandler*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


static void msm_call_handler_real_addSupplementaryInformation (FsoGsmAbstractCallHandler* base, const gchar* direction, const gchar* info) {
	MsmCallHandler * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FsoFrameworkPair* _tmp2_;
	self = (MsmCallHandler*) base;
	g_return_if_fail (direction != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = direction;
	_tmp1_ = info;
	_tmp2_ = fso_framework_pair_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	_fso_framework_pair_unref0 (self->supplementary);
	self->supplementary = _tmp2_;
}


static void msm_call_handler_real_activate_data_free (gpointer _data) {
	MsmCallHandlerActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmCallHandlerActivateData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void msm_call_handler_real_activate (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	MsmCallHandlerActivateData* _data_;
	MsmCallHandler* _tmp0_;
	gint _tmp1_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (MsmCallHandlerActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	msm_call_handler_real_activate_co (_data_);
}


static void msm_call_handler_real_activate_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	MsmCallHandlerActivateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_call_handler_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmCallHandlerActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_real_activate_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean msm_call_handler_real_activate_co (MsmCallHandlerActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	{
		_data_->_tmp3_ = _data_->id;
		if (_data_->_tmp3_ < 1) {
			_data_->_tmp2_ = TRUE;
		} else {
			_data_->_tmp4_ = _data_->id;
			_data_->_tmp2_ = ((guint) _data_->_tmp4_) > FSO_GSM_CONSTANTS_CALL_INDEX_MAX;
		}
		_data_->_tmp5_ = _data_->_tmp2_;
		if (_data_->_tmp5_) {
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_strdup_printf ("Call index needs to be within [ 1, %d ]", (gint) FSO_GSM_CONSTANTS_CALL_INDEX_MAX);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_free0 (_data_->_tmp7_);
			_data_->_inner_error_ = _data_->_tmp9_;
			goto __catch8_g_error;
		}
		_data_->_tmp10_ = _data_->self->calls;
		_data_->_tmp11_ = _data_->id;
		_data_->_tmp12_ = FALSE;
		_data_->_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp10_, GINT_TO_POINTER (_data_->_tmp11_));
		if (!_data_->_tmp12_) {
			_data_->_tmp13_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "Call with specified id is not available");
			_data_->_inner_error_ = _data_->_tmp13_;
			goto __catch8_g_error;
		}
		_data_->_tmp15_ = _data_->self->calls;
		_data_->_tmp16_ = _data_->id;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp15_, GINT_TO_POINTER (_data_->_tmp16_));
		_data_->_tmp18_ = (FsoGsmCall*) _data_->_tmp17_;
		_data_->_tmp19_ = _data_->_tmp18_->detail;
		_data_->_tmp20_ = _data_->_tmp19_.status;
		_data_->_tmp21_ = _data_->_tmp20_ != FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING;
		_fso_gsm_call_unref0 (_data_->_tmp18_);
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = _data_->self->calls;
			_data_->_tmp23_ = _data_->id;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp22_, GINT_TO_POINTER (_data_->_tmp23_));
			_data_->_tmp25_ = (FsoGsmCall*) _data_->_tmp24_;
			_data_->_tmp26_ = _data_->_tmp25_->detail;
			_data_->_tmp27_ = _data_->_tmp26_.status;
			_data_->_tmp14_ = _data_->_tmp27_ != FREE_SMARTPHONE_GSM_CALL_STATUS_HELD;
			_fso_gsm_call_unref0 (_data_->_tmp25_);
		} else {
			_data_->_tmp14_ = FALSE;
		}
		_data_->_tmp28_ = _data_->_tmp14_;
		if (_data_->_tmp28_) {
			_data_->_tmp29_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "No suitable call to activate found");
			_data_->_inner_error_ = _data_->_tmp29_;
			goto __catch8_g_error;
		}
		_data_->_tmp30_ = 0;
		_data_->_tmp30_ = msm_call_handler_numberOfBusyCalls (_data_->self);
		if (_data_->_tmp30_ == 0) {
			_data_->_tmp31_ = _data_->channel;
			_data_->_tmp32_ = _data_->_tmp31_->call_service;
			_data_->_tmp33_ = _data_->id;
			_data_->_state_ = 1;
			msmcomm_call_answer_call (_data_->_tmp32_, (guint) _data_->_tmp33_, msm_call_handler_activate_ready, _data_);
			return FALSE;
			_state_1:
			msmcomm_call_answer_call_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
		} else {
			_data_->_tmp34_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_UNSUPPORTED, "Can't activate incoming while another call is active!");
			_data_->_inner_error_ = _data_->_tmp34_;
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = _data_->_error_;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = string_to_string (_data_->_tmp36_);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = g_strconcat ("Could not process command, got: ", _data_->_tmp37_, NULL);
		_data_->msg = _data_->_tmp38_;
		_data_->_tmp39_ = _data_->msg;
		_data_->_tmp40_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp39_);
		_data_->_inner_error_ = _data_->_tmp40_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally8;
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_real_initiate_data_free (gpointer _data) {
	MsmCallHandlerInitiateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->number);
	_g_free0 (_data_->ctype);
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmCallHandlerInitiateData, _data_);
}


static void msm_call_handler_real_initiate (FsoGsmAbstractCallHandler* base, const gchar* number, const gchar* ctype, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	MsmCallHandlerInitiateData* _data_;
	MsmCallHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (MsmCallHandlerInitiateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_initiate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_initiate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = number;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->number = _tmp2_;
	_tmp3_ = ctype;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->ctype = _tmp4_;
	msm_call_handler_real_initiate_co (_data_);
}


static gint msm_call_handler_real_initiate_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	gint result;
	MsmCallHandlerInitiateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Initiate a call with a specified number; can be a voice or data call
     **/
static void msm_call_handler_initiate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmCallHandlerInitiateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_real_initiate_co (_data_);
}


static MsmcommCallStatusInfo* _variant_get4 (GVariant* value) {
	MsmcommCallStatusInfo _tmp20_;
	GVariantIter _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	g_variant_iter_init (&_tmp21_, value);
	_tmp22_ = g_variant_iter_next_value (&_tmp21_);
	_tmp20_.id = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_tmp21_);
	_tmp20_.type = msmcomm_call_type_from_string (g_variant_get_string (_tmp23_, NULL), NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_tmp21_);
	_tmp20_.number = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	return g_memdup (&_tmp20_, sizeof (MsmcommCallStatusInfo));
}


static void _vala_MsmcommCallStatusInfo_free (MsmcommCallStatusInfo* self) {
	msmcomm_call_status_info_destroy (self);
	g_free (self);
}


static gboolean msm_call_handler_real_initiate_co (MsmCallHandlerInitiateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->num = 0;
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = msm_call_handler_numberOfBusyCalls (_data_->self);
	if (_data_->_tmp2_ > 0) {
		_data_->_tmp3_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "System busy");
		_data_->_inner_error_ = _data_->_tmp3_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp4_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp5_ = _data_->number;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Initiating new call with number ", _data_->_tmp6_, " ...", NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = FALSE;
		_data_->_tmp9_ = fso_framework_logger_debug (_data_->_tmp4_, _data_->_tmp8_);
		g_assert (_data_->_tmp9_);
		_g_free0 (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->channel;
		_data_->_tmp11_ = _data_->_tmp10_->call_service;
		_data_->_tmp12_ = _data_->number;
		_data_->_state_ = 1;
		msmcomm_call_originate_call (_data_->_tmp11_, _data_->_tmp12_, FALSE, msm_call_handler_initiate_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_call_originate_call_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_data_->_tmp13_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp14_ = FALSE;
		_data_->_tmp14_ = fso_framework_logger_debug (_data_->_tmp13_, "Waiting for the call to complete initialization ...");
		g_assert (_data_->_tmp14_);
		_data_->_tmp15_ = _data_->channel;
		_data_->_tmp16_ = _data_->_tmp15_->urc_handler;
		_data_->_state_ = 2;
		msm_unsolicited_response_handler_waitForUnsolicitedResponse (_data_->_tmp16_, MSM_URC_TYPE_CALL_ORIGINATION, 0, NULL, NULL, msm_call_handler_initiate_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = msm_unsolicited_response_handler_waitForUnsolicitedResponse_finish (_data_->_tmp16_, _data_->_res_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _variant_get4 (_data_->_tmp18_);
		_data_->_tmp25_ = _data_->_tmp19_;
		_g_variant_unref0 (_data_->_tmp18_);
		_data_->call_info = _data_->_tmp25_;
		_data_->_tmp26_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp27_ = (*_data_->call_info).id;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = g_strdup_printf ("%u", _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = g_strconcat ("Call with id ", _data_->_tmp29_, " is instatiated; waiting now for the counter part to answer it.", NULL);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = FALSE;
		_data_->_tmp32_ = fso_framework_logger_debug (_data_->_tmp26_, _data_->_tmp31_);
		g_assert (_data_->_tmp32_);
		_g_free0 (_data_->_tmp31_);
		_g_free0 (_data_->_tmp29_);
		msm_call_handler_setCallAudioStatus (_data_->self, TRUE, NULL, NULL);
		_data_->_tmp33_ = (*_data_->call_info).id;
		_data_->_tmp34_ = fso_gsm_call_new_newFromId ((gint) _data_->_tmp33_);
		_data_->call = _data_->_tmp34_;
		fso_gsm_call_update_status (_data_->call, FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING);
		_data_->_tmp35_ = _data_->self->calls;
		_data_->_tmp36_ = (*_data_->call_info).id;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp35_, GINT_TO_POINTER ((gint) _data_->_tmp36_), _data_->call);
		_fso_gsm_call_unref0 (_data_->call);
		__vala_MsmcommCallStatusInfo_free0 (_data_->call_info);
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp37_ = _data_->_error_;
		_data_->_tmp38_ = _data_->_tmp37_->message;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = string_to_string (_data_->_tmp38_);
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = g_strconcat ("Could not process command, got: ", _data_->_tmp39_, NULL);
		_data_->msg = _data_->_tmp40_;
		_data_->_tmp41_ = _data_->msg;
		_data_->_tmp42_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp41_);
		_data_->_inner_error_ = _data_->_tmp42_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally9;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->num;
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_real_hold_data_free (gpointer _data) {
	MsmCallHandlerHoldData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmCallHandlerHoldData, _data_);
}


static void msm_call_handler_real_hold (FsoGsmAbstractCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	MsmCallHandlerHoldData* _data_;
	MsmCallHandler* _tmp0_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (MsmCallHandlerHoldData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_hold);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_hold_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_call_handler_real_hold_co (_data_);
}


static void msm_call_handler_real_hold_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	MsmCallHandlerHoldData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Hold all already active call
     **/
static gboolean msm_call_handler_real_hold_co (MsmCallHandlerHoldData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	{
		_data_->_tmp2_ = 0;
		_data_->_tmp2_ = msm_call_handler_numberOfCallsWithStatus (_data_->self, FREE_SMARTPHONE_GSM_CALL_STATUS_ACTIVE);
		if (_data_->_tmp2_ == 0) {
			_data_->_tmp3_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "No active call present");
			_data_->_inner_error_ = _data_->_tmp3_;
			goto __catch10_g_error;
		}
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = msm_call_handler_numberOfCallsWithStatus (_data_->self, FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING);
		if (_data_->_tmp4_ > 0) {
			_data_->_tmp5_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "Call incoming. Can't hold active calls without activating");
			_data_->_inner_error_ = _data_->_tmp5_;
			goto __catch10_g_error;
		}
		_data_->_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_UNSUPPORTED, "Putting an call in hold state is not supported yet!");
		_data_->_inner_error_ = _data_->_tmp6_;
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = _data_->_error_->message;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strconcat ("Could not process command, got: ", _data_->_tmp8_, NULL);
		_data_->msg = _data_->_tmp9_;
		_data_->_tmp10_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->msg);
		_data_->_inner_error_ = _data_->_tmp10_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally10;
	}
	__finally10:
	if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->channel);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_real_release_data_free (gpointer _data) {
	MsmCallHandlerReleaseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmCallHandlerReleaseData, _data_);
}


static void msm_call_handler_real_release (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	MsmCallHandlerReleaseData* _data_;
	MsmCallHandler* _tmp0_;
	gint _tmp1_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (MsmCallHandlerReleaseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_release);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_release_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	msm_call_handler_real_release_co (_data_);
}


static void msm_call_handler_real_release_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	MsmCallHandlerReleaseData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Release an already active call
     **/
static void msm_call_handler_release_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmCallHandlerReleaseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_real_release_co (_data_);
}


static gboolean msm_call_handler_real_release_co (MsmCallHandlerReleaseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	{
		_data_->_tmp3_ = _data_->id;
		if (_data_->_tmp3_ < 1) {
			_data_->_tmp2_ = TRUE;
		} else {
			_data_->_tmp4_ = _data_->id;
			_data_->_tmp2_ = ((guint) _data_->_tmp4_) > FSO_GSM_CONSTANTS_CALL_INDEX_MAX;
		}
		_data_->_tmp5_ = _data_->_tmp2_;
		if (_data_->_tmp5_) {
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_strdup_printf ("Call index needs to be within [ 1, %d ]", (gint) FSO_GSM_CONSTANTS_CALL_INDEX_MAX);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_free0 (_data_->_tmp7_);
			_data_->_inner_error_ = _data_->_tmp9_;
			goto __catch11_g_error;
		}
		_data_->_tmp10_ = _data_->self->calls;
		_data_->_tmp11_ = _data_->id;
		_data_->_tmp12_ = FALSE;
		_data_->_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp10_, GINT_TO_POINTER (_data_->_tmp11_));
		if (!_data_->_tmp12_) {
			_data_->_tmp13_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "Call with specified id is not available");
			_data_->_inner_error_ = _data_->_tmp13_;
			goto __catch11_g_error;
		}
		_data_->_tmp14_ = _data_->self->calls;
		_data_->_tmp15_ = _data_->id;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp14_, GINT_TO_POINTER (_data_->_tmp15_));
		_data_->_tmp17_ = (FsoGsmCall*) _data_->_tmp16_;
		_data_->_tmp18_ = _data_->_tmp17_->detail;
		_data_->_tmp19_ = _data_->_tmp18_.status;
		_data_->_tmp20_ = _data_->_tmp19_ == FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE;
		_fso_gsm_call_unref0 (_data_->_tmp17_);
		if (_data_->_tmp20_) {
			_data_->_tmp21_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "No suitable call to release found");
			_data_->_inner_error_ = _data_->_tmp21_;
			goto __catch11_g_error;
		}
		_data_->_tmp22_ = _data_->self->calls;
		_data_->_tmp23_ = _data_->id;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp22_, GINT_TO_POINTER (_data_->_tmp23_));
		_data_->_tmp25_ = (FsoGsmCall*) _data_->_tmp24_;
		_data_->_tmp26_ = _data_->_tmp25_->detail;
		_data_->_tmp27_ = _data_->_tmp26_.status;
		_data_->_tmp28_ = _data_->_tmp27_ == FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING;
		_fso_gsm_call_unref0 (_data_->_tmp25_);
		if (_data_->_tmp28_) {
			_data_->_tmp29_ = _data_->id;
			_data_->_state_ = 1;
			fso_gsm_abstract_call_handler_cancelOutgoingWithId ((FsoGsmAbstractCallHandler*) _data_->self, _data_->_tmp29_, msm_call_handler_release_ready, _data_);
			return FALSE;
			_state_1:
			fso_gsm_abstract_call_handler_cancelOutgoingWithId_finish ((FsoGsmAbstractCallHandler*) _data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp31_ = 0;
		_data_->_tmp31_ = msm_call_handler_numberOfCallsWithStatus (_data_->self, FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING);
		if (_data_->_tmp31_ == 1) {
			_data_->_tmp32_ = _data_->self->calls;
			_data_->_tmp33_ = _data_->id;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp32_, GINT_TO_POINTER (_data_->_tmp33_));
			_data_->_tmp35_ = (FsoGsmCall*) _data_->_tmp34_;
			_data_->_tmp36_ = _data_->_tmp35_->detail;
			_data_->_tmp37_ = _data_->_tmp36_.status;
			_data_->_tmp30_ = _data_->_tmp37_ == FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING;
			_fso_gsm_call_unref0 (_data_->_tmp35_);
		} else {
			_data_->_tmp30_ = FALSE;
		}
		_data_->_tmp38_ = _data_->_tmp30_;
		if (_data_->_tmp38_) {
			_data_->_tmp39_ = _data_->id;
			_data_->_state_ = 2;
			fso_gsm_abstract_call_handler_rejectIncomingWithId ((FsoGsmAbstractCallHandler*) _data_->self, _data_->_tmp39_, msm_call_handler_release_ready, _data_);
			return FALSE;
			_state_2:
			fso_gsm_abstract_call_handler_rejectIncomingWithId_finish ((FsoGsmAbstractCallHandler*) _data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp40_ = _data_->channel;
			_data_->_tmp41_ = _data_->_tmp40_->call_service;
			_data_->_tmp42_ = _data_->id;
			_data_->_state_ = 3;
			msmcomm_call_sups_call (_data_->_tmp41_, (guint) _data_->_tmp42_, MSMCOMM_SUPS_ACTION_HANGUP_ACTIVE_CALL, msm_call_handler_release_ready, _data_);
			return FALSE;
			_state_3:
			msmcomm_call_sups_call_finish (_data_->_tmp41_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp43_ = _data_->_error_;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = string_to_string (_data_->_tmp44_);
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = g_strconcat ("Could not process command, got: ", _data_->_tmp45_, NULL);
		_data_->msg = _data_->_tmp46_;
		_data_->_tmp47_ = _data_->msg;
		_data_->_tmp48_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp47_);
		_data_->_inner_error_ = _data_->_tmp48_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally11;
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_real_releaseAll_data_free (gpointer _data) {
	msm_call_handler_releaseAllData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_call_handler_releaseAllData, _data_);
}


static void msm_call_handler_real_releaseAll (FsoGsmAbstractCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	msm_call_handler_releaseAllData* _data_;
	MsmCallHandler* _tmp0_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (msm_call_handler_releaseAllData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_releaseAll);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_releaseAll_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_call_handler_real_releaseAll_co (_data_);
}


static void msm_call_handler_real_releaseAll_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	msm_call_handler_releaseAllData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Release all calls
     **/
static gboolean msm_call_handler_real_releaseAll_co (msm_call_handler_releaseAllData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Handle an incomming call 
     **/
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static void msm_call_handler_real_handleIncomingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info) {
	MsmCallHandler * self;
	FsoFrameworkLogger* _tmp0_;
	FsoGsmCallInfo* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	FsoGsmCallInfo* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	FsoGsmCall* _tmp11_;
	FsoGsmCall* new_call;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GHashTable* _tmp14_;
	GHashTable* empty_properties;
	FsoGsmCallInfo* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	FreeSmartphoneGSMCallDetail call_detail = {0};
	FreeSmartphoneGSMCallDetail _tmp18_;
	GeeHashMap* _tmp19_;
	FsoGsmCallInfo* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	self = (MsmCallHandler*) base;
	g_return_if_fail (call_info != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = call_info;
	_tmp2_ = fso_gsm_call_info_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Got a new incomming call with id = ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	fso_framework_logger_debug (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = call_info;
	_tmp9_ = fso_gsm_call_info_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = fso_gsm_call_new_newFromId (_tmp10_);
	new_call = _tmp11_;
	_tmp12_ = g_str_hash;
	_tmp13_ = g_str_equal;
	_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, _g_free0_, _g_variant_unref0_);
	empty_properties = _tmp14_;
	_tmp15_ = call_info;
	_tmp16_ = fso_gsm_call_info_get_id (_tmp15_);
	_tmp17_ = _tmp16_;
	free_smartphone_gsm_call_detail_init (&call_detail, _tmp17_, FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING, empty_properties);
	_tmp18_ = call_detail;
	fso_gsm_call_update (new_call, &_tmp18_);
	_tmp19_ = self->calls;
	_tmp20_ = call_info;
	_tmp21_ = fso_gsm_call_info_get_id (_tmp20_);
	_tmp22_ = _tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, GINT_TO_POINTER (_tmp22_), new_call);
	free_smartphone_gsm_call_detail_destroy (&call_detail);
	_g_hash_table_unref0 (empty_properties);
	_fso_gsm_call_unref0 (new_call);
}


/**
     * Handle an connecting call
     **/
static void msm_call_handler_real_handleConnectingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info) {
	MsmCallHandler * self;
	FsoFrameworkLogger* _tmp0_;
	FsoGsmCallInfo* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	FsoGsmCallInfo* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	self = (MsmCallHandler*) base;
	g_return_if_fail (call_info != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = call_info;
	_tmp2_ = fso_gsm_call_info_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Got a new connecting call with id = ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	fso_framework_logger_debug (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->calls;
	_tmp9_ = call_info;
	_tmp10_ = fso_gsm_call_info_get_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, GINT_TO_POINTER (_tmp11_));
	if (_tmp12_) {
		GeeHashMap* _tmp13_;
		FsoGsmCallInfo* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gpointer _tmp17_ = NULL;
		FsoGsmCall* call;
		FsoGsmCall* _tmp18_;
		FreeSmartphoneGSMCallDetail _tmp19_;
		FreeSmartphoneGSMCallStatus _tmp20_;
		FsoGsmCall* _tmp21_;
		_tmp13_ = self->calls;
		_tmp14_ = call_info;
		_tmp15_ = fso_gsm_call_info_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, GINT_TO_POINTER (_tmp16_));
		call = (FsoGsmCall*) _tmp17_;
		_tmp18_ = call;
		_tmp19_ = _tmp18_->detail;
		_tmp20_ = _tmp19_.status;
		if (_tmp20_ != FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING) {
			msm_call_handler_setCallAudioStatus (self, TRUE, NULL, NULL);
		}
		_tmp21_ = call;
		fso_gsm_call_update_status (_tmp21_, FREE_SMARTPHONE_GSM_CALL_STATUS_ACTIVE);
		_fso_gsm_call_unref0 (call);
	} else {
		FsoFrameworkLogger* _tmp22_;
		_tmp22_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp22_, "callhandler got connecting call which is not known as incoming or outg" \
"oing before!");
	}
}


/**
     * Handle an ending call
     **/
static void msm_call_handler_real_handleEndingCall (FsoGsmAbstractCallHandler* base, FsoGsmCallInfo* call_info) {
	MsmCallHandler * self;
	FsoFrameworkLogger* _tmp0_;
	FsoGsmCallInfo* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	FsoGsmCallInfo* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	self = (MsmCallHandler*) base;
	g_return_if_fail (call_info != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = call_info;
	_tmp2_ = fso_gsm_call_info_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Got a new ending call with id = ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	fso_framework_logger_debug (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->calls;
	_tmp9_ = call_info;
	_tmp10_ = fso_gsm_call_info_get_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, GINT_TO_POINTER (_tmp11_));
	if (_tmp12_) {
		GeeHashMap* _tmp13_;
		FsoGsmCallInfo* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gpointer _tmp17_ = NULL;
		FsoGsmCall* call;
		FsoGsmCall* _tmp18_;
		GeeHashMap* _tmp19_;
		FsoGsmCallInfo* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp13_ = self->calls;
		_tmp14_ = call_info;
		_tmp15_ = fso_gsm_call_info_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, GINT_TO_POINTER (_tmp16_));
		call = (FsoGsmCall*) _tmp17_;
		_tmp18_ = call;
		fso_gsm_call_update_status (_tmp18_, FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE);
		_tmp19_ = self->calls;
		_tmp20_ = call_info;
		_tmp21_ = fso_gsm_call_info_get_id (_tmp20_);
		_tmp22_ = _tmp21_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, GINT_TO_POINTER (_tmp22_), NULL);
		msm_call_handler_setCallAudioStatus (self, FALSE, NULL, NULL);
		_fso_gsm_call_unref0 (call);
	} else {
		FsoFrameworkLogger* _tmp23_;
		_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp23_, "callhandler got ending call which is not known as active before!");
	}
}


static void msm_call_handler_real_startTimeoutIfNecessary (FsoGsmAbstractCallHandler* base) {
	MsmCallHandler * self;
	self = (MsmCallHandler*) base;
}


static void msm_call_handler_real_cancelOutgoingWithId_data_free (gpointer _data) {
	msm_call_handler_cancelOutgoingWithIdData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_call_handler_cancelOutgoingWithIdData, _data_);
}


static void msm_call_handler_real_cancelOutgoingWithId (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	msm_call_handler_cancelOutgoingWithIdData* _data_;
	MsmCallHandler* _tmp0_;
	gint _tmp1_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (msm_call_handler_cancelOutgoingWithIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_cancelOutgoingWithId);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_cancelOutgoingWithId_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	msm_call_handler_real_cancelOutgoingWithId_co (_data_);
}


static void msm_call_handler_real_cancelOutgoingWithId_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	msm_call_handler_cancelOutgoingWithIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_call_handler_cancelOutgoingWithId_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_call_handler_cancelOutgoingWithIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_real_cancelOutgoingWithId_co (_data_);
}


static gboolean msm_call_handler_real_cancelOutgoingWithId_co (msm_call_handler_cancelOutgoingWithIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp1_ = _data_->id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup_printf ("%i", _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strconcat ("Cancelling outgoing call with ID ", _data_->_tmp3_, NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = fso_framework_logger_debug (_data_->_tmp0_, _data_->_tmp5_);
	g_assert (_data_->_tmp6_);
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp7_ = _data_->self->calls;
	_data_->_tmp8_ = _data_->id;
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp7_, GINT_TO_POINTER (_data_->_tmp8_));
	if (!_data_->_tmp9_) {
		_data_->_tmp10_ = _data_->id;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_strconcat ("Unknown call id ", _data_->_tmp12_, NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_g_free0 (_data_->_tmp14_);
		_g_free0 (_data_->_tmp12_);
		_data_->_inner_error_ = _data_->_tmp16_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp17_ = _data_->self->calls;
	_data_->_tmp18_ = _data_->id;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp17_, GINT_TO_POINTER (_data_->_tmp18_));
	_data_->call = (FsoGsmCall*) _data_->_tmp19_;
	{
		_data_->_tmp20_ = fso_gsm_theModem;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = fso_gsm_modem_channel (_data_->_tmp20_, "main");
		_data_->channel = IS_MSM_CHANNEL (_data_->_tmp21_) ? ((MsmChannel*) _data_->_tmp21_) : NULL;
		_data_->_tmp22_ = _data_->call;
		_data_->_tmp23_ = _data_->_tmp22_->detail;
		_data_->_tmp24_ = _data_->_tmp23_.status;
		if (_data_->_tmp24_ == FREE_SMARTPHONE_GSM_CALL_STATUS_ACTIVE) {
			_data_->_tmp25_ = _data_->channel;
			_data_->_tmp26_ = _data_->_tmp25_->call_service;
			_data_->_tmp27_ = _data_->id;
			_data_->_state_ = 1;
			msmcomm_call_sups_call (_data_->_tmp26_, (guint) _data_->_tmp27_, MSMCOMM_SUPS_ACTION_HANGUP_ACTIVE_CALL, msm_call_handler_cancelOutgoingWithId_ready, _data_);
			return FALSE;
			_state_1:
			msmcomm_call_sups_call_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->channel);
				goto __catch12_g_error;
			}
		} else {
			_data_->_tmp28_ = _data_->call;
			_data_->_tmp29_ = _data_->_tmp28_->detail;
			_data_->_tmp30_ = _data_->_tmp29_.status;
			if (_data_->_tmp30_ == FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING) {
				_data_->_tmp31_ = _data_->channel;
				_data_->_tmp32_ = _data_->_tmp31_->call_service;
				_data_->_tmp33_ = _data_->id;
				_data_->_state_ = 2;
				msmcomm_call_end_call (_data_->_tmp32_, (guint) _data_->_tmp33_, msm_call_handler_cancelOutgoingWithId_ready, _data_);
				return FALSE;
				_state_2:
				msmcomm_call_end_call_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_g_object_unref0 (_data_->channel);
					goto __catch12_g_error;
				}
			}
		}
		_g_object_unref0 (_data_->channel);
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp34_ = _data_->_error_;
		_data_->_tmp35_ = _data_->_tmp34_->message;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = string_to_string (_data_->_tmp35_);
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = g_strconcat ("Could not process command, got: ", _data_->_tmp36_, NULL);
		_data_->msg = _data_->_tmp37_;
		_data_->_tmp38_ = _data_->msg;
		_data_->_tmp39_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp38_);
		_data_->_inner_error_ = _data_->_tmp39_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally12;
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_fso_gsm_call_unref0 (_data_->call);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_fso_gsm_call_unref0 (_data_->call);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_fso_gsm_call_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_real_rejectIncomingWithId_data_free (gpointer _data) {
	msm_call_handler_rejectIncomingWithIdData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_call_handler_rejectIncomingWithIdData, _data_);
}


static void msm_call_handler_real_rejectIncomingWithId (FsoGsmAbstractCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmCallHandler * self;
	msm_call_handler_rejectIncomingWithIdData* _data_;
	MsmCallHandler* _tmp0_;
	gint _tmp1_;
	self = (MsmCallHandler*) base;
	_data_ = g_slice_new0 (msm_call_handler_rejectIncomingWithIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_real_rejectIncomingWithId);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_real_rejectIncomingWithId_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	msm_call_handler_real_rejectIncomingWithId_co (_data_);
}


static void msm_call_handler_real_rejectIncomingWithId_finish (FsoGsmAbstractCallHandler* base, GAsyncResult* _res_, GError** error) {
	msm_call_handler_rejectIncomingWithIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_call_handler_rejectIncomingWithId_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_call_handler_rejectIncomingWithIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_real_rejectIncomingWithId_co (_data_);
}


static gboolean msm_call_handler_real_rejectIncomingWithId_co (msm_call_handler_rejectIncomingWithIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp1_ = _data_->id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup_printf ("%i", _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strconcat ("Rejecting incoming call with ID ", _data_->_tmp3_, NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = fso_framework_logger_debug (_data_->_tmp0_, _data_->_tmp5_);
	g_assert (_data_->_tmp6_);
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp7_ = fso_gsm_theModem;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = fso_gsm_modem_channel (_data_->_tmp7_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp8_) ? ((MsmChannel*) _data_->_tmp8_) : NULL;
	_data_->_tmp9_ = _data_->self->calls;
	_data_->_tmp10_ = _data_->id;
	_data_->_tmp11_ = FALSE;
	_data_->_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp9_, GINT_TO_POINTER (_data_->_tmp10_));
	if (!_data_->_tmp11_) {
		_data_->_tmp12_ = _data_->id;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_strdup_printf ("%i", _data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_strconcat ("Unknown call id ", _data_->_tmp14_, NULL);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_g_free0 (_data_->_tmp16_);
		_g_free0 (_data_->_tmp14_);
		_data_->_inner_error_ = _data_->_tmp18_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp19_ = _data_->channel;
		_data_->_tmp20_ = _data_->_tmp19_->call_service;
		_data_->_tmp21_ = _data_->id;
		_data_->_state_ = 1;
		msmcomm_call_sups_call (_data_->_tmp20_, (guint) _data_->_tmp21_, MSMCOMM_SUPS_ACTION_REJECT_INCOMING_CALL, msm_call_handler_rejectIncomingWithId_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_call_sups_call_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = _data_->_error_;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = string_to_string (_data_->_tmp23_);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_strconcat ("Could not process command, got: ", _data_->_tmp24_, NULL);
		_data_->msg = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->msg;
		_data_->_tmp27_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp26_);
		_data_->_inner_error_ = _data_->_tmp27_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->_error_);
		goto __finally13;
	}
	__finally13:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint msm_call_handler_numberOfBusyCalls (MsmCallHandler* self) {
	gint result = 0;
	gint num;
	g_return_val_if_fail (self != NULL, 0);
	num = 0;
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _call_it;
		_tmp0_ = self->calls;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_call_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FsoGsmCall* call;
			gboolean _tmp10_ = FALSE;
			FsoGsmCall* _tmp11_;
			FreeSmartphoneGSMCallDetail _tmp12_;
			FreeSmartphoneGSMCallStatus _tmp13_;
			gboolean _tmp17_;
			_tmp6_ = _call_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _call_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			call = (FsoGsmCall*) _tmp9_;
			_tmp11_ = call;
			_tmp12_ = _tmp11_->detail;
			_tmp13_ = _tmp12_.status;
			if (_tmp13_ != FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE) {
				FsoGsmCall* _tmp14_;
				FreeSmartphoneGSMCallDetail _tmp15_;
				FreeSmartphoneGSMCallStatus _tmp16_;
				_tmp14_ = call;
				_tmp15_ = _tmp14_->detail;
				_tmp16_ = _tmp15_.status;
				_tmp10_ = _tmp16_ != FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp17_ = _tmp10_;
			if (_tmp17_) {
				gint _tmp18_;
				_tmp18_ = num;
				num = _tmp18_ + 1;
			}
			_fso_gsm_call_unref0 (call);
		}
		_g_object_unref0 (_call_it);
	}
	result = num;
	return result;
}


static gint msm_call_handler_numberOfCallsWithStatus (MsmCallHandler* self, FreeSmartphoneGSMCallStatus status) {
	gint result = 0;
	gint num;
	g_return_val_if_fail (self != NULL, 0);
	num = 0;
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _call_it;
		_tmp0_ = self->calls;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_call_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FsoGsmCall* call;
			FsoGsmCall* _tmp10_;
			FreeSmartphoneGSMCallDetail _tmp11_;
			FreeSmartphoneGSMCallStatus _tmp12_;
			FreeSmartphoneGSMCallStatus _tmp13_;
			_tmp6_ = _call_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _call_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			call = (FsoGsmCall*) _tmp9_;
			_tmp10_ = call;
			_tmp11_ = _tmp10_->detail;
			_tmp12_ = _tmp11_.status;
			_tmp13_ = status;
			if (_tmp12_ == _tmp13_) {
				gint _tmp14_;
				_tmp14_ = num;
				num = _tmp14_ + 1;
			}
			_fso_gsm_call_unref0 (call);
		}
		_g_object_unref0 (_call_it);
	}
	result = num;
	return result;
}


static void msm_call_handler_setCallAudioStatus_data_free (gpointer _data) {
	msm_call_handler_setCallAudioStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_call_handler_setCallAudioStatusData, _data_);
}


static void msm_call_handler_setCallAudioStatus (MsmCallHandler* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_call_handler_setCallAudioStatusData* _data_;
	MsmCallHandler* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (msm_call_handler_setCallAudioStatusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_call_handler_setCallAudioStatus);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_call_handler_setCallAudioStatus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = active;
	_data_->active = _tmp1_;
	msm_call_handler_setCallAudioStatus_co (_data_);
}


static void msm_call_handler_setCallAudioStatus_finish (MsmCallHandler* self, GAsyncResult* _res_) {
	msm_call_handler_setCallAudioStatusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_call_handler_setCallAudioStatus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_call_handler_setCallAudioStatusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_call_handler_setCallAudioStatus_co (_data_);
}


static gboolean msm_call_handler_setCallAudioStatus_co (msm_call_handler_setCallAudioStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	_data_->_tmp2_ = _data_->channel;
	g_assert (_data_->_tmp2_ != NULL);
	_data_->_tmp3_ = _data_->active;
	if (!_data_->_tmp3_) {
		_g_object_unref0 (_data_->channel);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp4_ = _data_->channel;
		_data_->_tmp5_ = _data_->_tmp4_->sound_service;
		_data_->_state_ = 1;
		msmcomm_sound_set_device (_data_->_tmp5_, MSMCOMM_SOUND_DEVICE_CLASS_HANDSET, MSMCOMM_SOUND_DEVICE_SUB_CLASS_DEFAULT, msm_call_handler_setCallAudioStatus_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_sound_set_device_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = _data_->active;
		if (_data_->_tmp7_) {
			_data_->_tmp6_ = "activate";
		} else {
			_data_->_tmp6_ = "deactivate";
		}
		_data_->_tmp8_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp9_ = _data_->_error_;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = string_to_string (_data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_strconcat ("Can't %s call audio: ", _data_->_tmp11_, NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->_tmp6_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_strdup_printf (_data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		fso_framework_logger_error (_data_->_tmp8_, _data_->_tmp16_);
		_g_free0 (_data_->_tmp16_);
		_g_free0 (_data_->_tmp13_);
		_g_error_free0 (_data_->_error_);
	}
	__finally14:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_call_handler_class_init (MsmCallHandlerClass * klass) {
	msm_call_handler_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = msm_call_handler_real_repr;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->addSupplementaryInformation = msm_call_handler_real_addSupplementaryInformation;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->activate = msm_call_handler_real_activate;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->activate_finish = msm_call_handler_real_activate_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->initiate = msm_call_handler_real_initiate;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->initiate_finish = msm_call_handler_real_initiate_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->hold = msm_call_handler_real_hold;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->hold_finish = msm_call_handler_real_hold_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->release = msm_call_handler_real_release;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->release_finish = msm_call_handler_real_release_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->releaseAll = msm_call_handler_real_releaseAll;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->releaseAll_finish = msm_call_handler_real_releaseAll_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->handleIncomingCall = msm_call_handler_real_handleIncomingCall;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->handleConnectingCall = msm_call_handler_real_handleConnectingCall;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->handleEndingCall = msm_call_handler_real_handleEndingCall;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->startTimeoutIfNecessary = msm_call_handler_real_startTimeoutIfNecessary;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->cancelOutgoingWithId = msm_call_handler_real_cancelOutgoingWithId;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->cancelOutgoingWithId_finish = msm_call_handler_real_cancelOutgoingWithId_finish;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->rejectIncomingWithId = msm_call_handler_real_rejectIncomingWithId;
	FSO_GSM_ABSTRACT_CALL_HANDLER_CLASS (klass)->rejectIncomingWithId_finish = msm_call_handler_real_rejectIncomingWithId_finish;
	G_OBJECT_CLASS (klass)->finalize = msm_call_handler_finalize;
}


static void msm_call_handler_instance_init (MsmCallHandler * self) {
}


static void msm_call_handler_finalize (GObject* obj) {
	MsmCallHandler * self;
	self = MSM_CALL_HANDLER (obj);
	_g_object_unref0 (self->calls);
	_fso_framework_pair_unref0 (self->supplementary);
	G_OBJECT_CLASS (msm_call_handler_parent_class)->finalize (obj);
}


/**
 * @class FsoGsm.GenericAtCallHandler
 */
GType msm_call_handler_get_type (void) {
	return msm_call_handler_type_id;
}


GType msm_call_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MsmCallHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) msm_call_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MsmCallHandler), 0, (GInstanceInitFunc) msm_call_handler_instance_init, NULL };
	msm_call_handler_type_id = g_type_module_register_type (module, FSO_GSM_TYPE_ABSTRACT_CALL_HANDLER, "MsmCallHandler", &g_define_type_info, 0);
	return msm_call_handler_type_id;
}



