/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __PARALLEL_INTERACTION_STORAGE_ED_H
#define __PARALLEL_INTERACTION_STORAGE_ED_H

//--- project includes ---
#include "pi_storage_e.h"

//--- STL includes ---
#include <vector>
using std::vector;

//--- IO includes ---

/*!
  \class ParallelInteractionStorage_ED
  \brief parallel storage array with exchange for dynamically created interactions (friction etc.)
*/
template<typename P,typename I>
class ParallelInteractionStorage_ED : public ParallelInteractionStorage_E<P,I>
{
 public:
  //  typedef I ParallelInteractionStorage_ED::interaction_type;

 protected:
  int m_update_timestamp;
  AParallelInteractionStorage* m_exIG; //<! if an interaction is in m_exIG, it can't be in m_interactions

 public:
  ParallelInteractionStorage_ED(AParallelParticleArray*,const typename I::ParameterType&);

  virtual void addExIG(AParallelInteractionStorage*);
  virtual bool update();
  virtual void setTimeStepSize(double dt);

  virtual void saveCheckPointData(std::ostream &oStream);
  virtual void loadCheckPointData(std::istream &iStream);

  virtual void calcHeatTrans();
  virtual void calcHeatFrict();

  virtual bool willSave(){ return true;};
};

#include "pis/pi_storage_ed.hpp"

#endif // __PARALLEL_INTERACTION_STORAGE_ED_H
