#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

"""
Defines classes which relate to I{modifying} renderable objects.
"""

from esys.lsm.vis.core import *

class Modifiable(Modifiable):
    def __init__(self):
        core.Modifiable.__init__(self)

    def applyModifiers(self, actor):
        for modifier in self.getModifierList():
            if (modifier != None):
                modifier.applyTo(actor)

class Modifier(Modifier):
    def __init__(self):
        pass

    def applyTo(self, actor):
        core.raiseNotImplemented("Not implemented.")


