/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include "Foundation/PathSearcher.h"
#include "Foundation/StringUtil.h"

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/convenience.hpp>
#include <boost/filesystem/fstream.hpp>

using namespace boost;

namespace esys
{
  namespace lsm
  {
    PathSearcher::PathSearcher(const std::string &delimitedPathList, const std::string &delim)
      : m_pathVector()
    {
      StringUtil::StringVector searchPaths = StringUtil::splitStrings(delimitedPathList, delim);
      for (StringUtil::StringVector::const_iterator it = searchPaths.begin(); it != searchPaths.end(); it++)
      {
        m_pathVector.push_back(filesystem::path(*it, filesystem::native));
      }
    }
    
    bool exists(const std::string &fileName)
    {
      return false;
    }

    filesystem::path PathSearcher::findPath(const std::string &fileName)
    {
      for (PathVector::const_iterator it = m_pathVector.begin(); it != m_pathVector.end(); it++)
      {
        const filesystem::path p = (*it) / fileName;
        if (filesystem::exists(p))
        {
          return p;
        }
      }
      return filesystem::path();
    }

    std::string PathSearcher::find(const std::string &fileName)
    {
      return findPath(fileName).string();
    }
  }
}
