"**************************************************************************
"enCore 4.0 to 4.0.1 Patch. 
"Copyright (C) 2004 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************


@program $quota_utils:init_for_core
if (!caller_perms().wizard)
  return E_PERM;
else
  $quota_utils = this;
  set_verb_code(this, "can_peek", {"return args[1]==this.owner || $perm_utils:controls(args[1], args[2]);"});
  set_verb_code(this, "can_touch", {"return args[1].wizard;"});
  this.default_quota = {100000, 0, 0, 1};
  this.exempted = {};
  this.working = #2;
  this.task_time_limit = 500;
  this.repeat_cycle = 0;
  this.large_objects = {};
  this.report_recipients = {#2};
endif
.

@program $encore_web_class:css
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
style_sheet = {};
if ($object_utils:isa(object, $encore_web_object) && $encore_web_object.use_external_stylesheet || ($object_utils:isa(object, $encore_web_application) && $encore_web_application.use_external_stylesheet))
  "--------------------------------------------------";
  "Use specified external style sheet";
  "--------------------------------------------------";
  ref = $object_utils:isa(object, $encore_web_object) == 1 ? $encore_web_object.external_stylesheet | $encore_web_application.external_stylesheet;
  if (!match(ref, "http://"))
    ref = tostr($xpress_client.external_baseurl, $xpress_client.stylesheets_folder, ref);
  endif
  style_sheet = {tostr("   <link rel=\"StyleSheet\" href=\"", ref, "\" type=\"text/css\" media=\"screen\" />")};
else
  "--------------------------------------------------";
  "Make embedded style sheet based on object apperance values";
  "--------------------------------------------------";
  if (user.override_object_styles && object.allow_override_styles)
    object = user;
  endif
  background = "";
  if (match(object.web_background, "http://"))
    background = object.web_background;
  elseif (object.web_background != "")
    background = tostr($xpress_client.external_baseurl, $xpress_client.icons_folder, object.web_background);
  endif
  style_sheet = {@style_sheet, "      /* General element definitions */"};
  style_sheet = {@style_sheet, tostr("        body, p, td { color: ", object.web_text_color, "; font-family: ", object.web_font, "; font-size: ", object.web_font_size, "; background: none }")};
  style_sheet = {@style_sheet, tostr("        body { ", bkground = background == "" ? "" | tostr("background: url(", background, "); "), bgcolor = object.web_bgcolor == "" ? "" | tostr("background-color: ", object.web_bgcolor, "; "), " }")};
  style_sheet = {@style_sheet, tostr("        img { border: ", object.icon_border, " }")};
  style_sheet = {@style_sheet, tostr("        div.title { color: ", object.title_font_color, "; font-size: ", object.title_font_size, "; ", background = $object_utils:isa(object, $encore_web_application) == 1 ? tostr(" background-image: url(\"", $xpress_client.external_baseurl, $xpress_client.themes_folder, user.xpress_theme, "/theme-background.jpg\")") | " background: none", " }")};
  style_sheet = {@style_sheet, tostr("        div.subtitle { color: ", object.title_font_color, "; font-size: ", object.subtitle_font_size, "; ", background = $object_utils:isa(object, $encore_web_application) == 1 ? tostr(" background-image: url(\"", $xpress_client.external_baseurl, $xpress_client.themes_folder, user.xpress_theme, "/theme-background.jpg\")") | " background: none", " }")};
  style_sheet = {@style_sheet, tostr("        pre { font-family: ", object.fixed_width_font, "; font-size: ", object.fixed_width_font_size, " }")};
  style_sheet = {@style_sheet, "      /* Link definitions */"};
  style_sheet = {@style_sheet, tostr("        a { font-family: ", object.web_font, "; font-size: ", object.web_font_size, ";", object.underline_links == 0 ? " text-decoration: none;" | "", " background: none; }")};
  style_sheet = {@style_sheet, tostr("        a:link { color: ", object.web_link_color, " }")};
  style_sheet = {@style_sheet, tostr("        a:visited { color: ", object.web_vlink_color, " }")};
  style_sheet = {@style_sheet, tostr("        a:hover { background: ", object.web_alink_color, " }")};
  style_sheet = {@style_sheet, "      /* Table layout */"};
  style_sheet = {@style_sheet, tostr("        table { width: ", object.table_width, ";  border : 1px solid black; }")};
  style_sheet = {@style_sheet, tostr("        th { vertical-align: ", object.table_vertical_alignment, " }")};
  style_sheet = {@style_sheet, tostr("        td { vertical-align: ", object.table_vertical_alignment, ";  }")};
  style_sheet = {@style_sheet, tostr("        div.header { background-color: silver; }")};
endif
return style_sheet;
.

@program $webpage:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik";
"This object assumes that the user marks up the page in the description, so we do not pass to parent";
"===========================================================";
user = args[1];
contents = exits = links = {};
html = this.description;
additional = 0;
if (this.contents != {})
  contents = $encore_web_utils:insert_line_breaks($list_utils:append({this.web_contents_msg}, $encore_web_utils:generate_links(user, this.contents)));
endif
if (this.exits != {})
  for exit in (this.exits)
    if (exit.obvious)
      exits = {@exits, exit};
    endif
  endfor
  exits = $encore_web_utils:insert_line_breaks($list_utils:append({this.web_exits_msg}, $encore_web_utils:generate_links(user, exits)));
endif
table = $encore_web_utils:generate_table(user, {contents, exits}, this, 1);
html = $list_utils:append(html, table);
"Move user to new location if java client on";
if (user.ts_client && user.location != this)
  $encore_web_utils:move_via_web(user, this);
endif
return html;
.

@program $prog:@code
"Added task perms here to prevent folks from viewing non-readable code. Thanks to Wade Wesolowsky";
set_task_perms(player);
if (!args)
  return player:tell("Usage: @code object:verb");
elseif (!(spec = $code_utils:parse_verbref(args[1])))
  player:tell("Usage:  @code <object>:<verb>");
  return E_INVARG;
endif
object = player:my_match_object(spec[1]);
if ($command_utils:object_match_failed(object, spec[1]))
  return;
endif
what = object;
vname = spec[2];
while (what != $nothing && (code = verb_code(what, vname)) == E_VERBNF)
  what = parent(what);
endwhile
info = verb_info(what, vname);
if (code == E_VERBNF)
  player:tell("That object does not define that verb.");
elseif (typeof(code) == ERR)
  player:tell(code);
elseif (code == {})
  player:tell("That verb has not been programmed.");
else
  if (what != object)
    player:tell("Object ", object, " does not define that verb, but its ancestor ", what, " does.");
  endif
  info = verb_info(what, vname);
  vargs = verb_args(what, vname);
  if (index(vargs[2], "/"))
    vargs = listset(vargs, $code_utils:short_prep(vargs[2]), 2);
  endif
  if (spec[1][1] == "$")
    vrb = spec[1];
  else
    vrb = what;
  endif
  player:tell(tostr("@verb ", vrb, ":", $string_utils:print(info[3]), " ", $string_utils:from_list(vargs, " "), " ", info[2]));
  player:tell(tostr("@program ", vrb, ":", vname));
  player:tell_lines(code);
  player:tell(".");
endif
.


@program $xpress_moo_mailer:permission_to_read
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb that checks to see if user has permission to see requested";
"folder or mail message. Returns true (1) if user has permission,";
"else returns false (0)";
"Added additional checks to make sure users can't read other players";
"mail. Thanks to Wade Wesolowsky";
"===========================================================";
{user, folder} = args;
cm = user.current_message;
cm[1..2] = verb == "@rn" ? {{this, @cm[1..2]}} | {};
valid_folders = {user};
for item in (cm)
  if (item[1] == user)
    "Folder is the user";
    valid_folders = {@valid_folders, item[1]};
  elseif ($object_utils:isa(item[1], $mail_recipient) || $object_utils:isa(item[1], $big_mail_recipient))
    "Folder is a mailing list, grant access if user is wizard or if folder is readable";
    if ($object_utils:has_property(item[1], "readers"))
      if (user.wizard || item[1].readers == 1)
        valid_folders = {@valid_folders, item[1]};
      endif
    endif
  endif
endfor
if (folder in valid_folders)
  return 1;
else
  return 0;
endif
.

@program $administration_module:batch_make_player
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Create several characters at once.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
body = names = email_addresses = real_names = {};
bad_names = "";
class = toobj(data[2][2]);
account_data = data[2][3];
if (typeof(account_data) == STR)
  account_data = {account_data};
endif
"=== Organize data ===";
for line in (account_data)
  $command_utils:suspend_if_needed(1);
  parts = $string_utils:explode(line);
  try
    names = {@names, parts[1]};
    if (class != $guest)
      email_addresses = {@email_addresses, parts[2]};
      real_names = {@real_names, $string_utils:from_list(parts[3..$], " ")};
    endif
  except error (ANY)
    body = this:view_html(user, {{class, "", account_data}, {"batch"}});
    msg = "alert('You need to fill both names and valid email addresses. Real names are optional. If you are creating new guest characters, you only need to fill in the names.')";
    result = this:pre_assemble(user, body, "Character Administration", msg);
    return result;
  endtry
endfor
"=== Check that names are available ===";
for name in (names)
  if (!$player_db:available(name))
    bad_names = bad_names + name + " ";
  endif
endfor
if (bad_names)
  return this:view_html(user, {{class, bad_names, account_data}, {"batch"}});
else
  result = {tostr("Account Creation Report: ", $network.MOO_name)};
  result = {@result, tostr("Date: ", $time_utils:time_sub("$2/$T/$Y", time()), $time_utils:time_sub(" $H:$M:$S, $Z", time()))};
  result = {@result, tostr("Created by: ", user.name)};
  result = {@result, ""};
  for n in [1..length(names)]
    $command_utils:suspend_if_needed(1);
    if (class == $guest)
      result = {@result, this:make_guest(user, class, names[n])};
    else
      result = {@result, this:make_player(user, class, names[n], email_addresses[n], real_names[n])};
    endif
    result = {@result, ""};
  endfor
endif
return this:view_html(user, {{$player_class, "", result}, {"report"}});
.

@program $administration_module:view_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Account administration module";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
action = data[2];
msg = "Select a character class and enter name, email address and real name for the new account to be created below. If you are creating a new guest account, you only need to fill in the name field.";
if (action == {"update"})
  OBJ = data[1];
  player_class = parent(OBJ);
  plyr_name = OBJ.name;
  email = OBJ.email_address;
  real_name = OBJ.real_name;
  msg = "Change data for this account by editing the fields below.";
elseif (action == {"batch"})
  if (data[1] == {""})
    player_class = $player_class;
    msg = tostr("Select a character type and enter data for the new accounts below. Use one line for each new account. Separate user name, email address, and real name with open spaces. Example: ", $encore_web_utils:br(), $encore_web_utils:i("Anna Annab@someplace.com Anna Livingston"));
    account_data = {};
  else
    player_class = toobj(data[1][1]);
    msg = "The following name(s) is/are already in use: " + data[1][2] + $encore_web_utils:br() + "Please choose new name(s) and try again.";
    account_data = data[1][3];
  endif
elseif (action == {"report"})
  player_class = $player_class;
  msg = "Account Creation Report:";
  account_data = data[1][3];
else
  player_class = $player_class;
  plyr_name = email = real_name = "";
endif
body = search = part1 = part2 = {};
confirmDelete = {"function confirmAction() {", "   if (confirm('Are you sure you want to do this?')) {", "      return true;", "   }", "   return false;", "}"};
base_url = tostr("http://", $network.site, ":", $network.webport, "/administration_module/");
title = $encore_web_utils:get_subtitle(user, this, "Character Account Administration");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "enCore_Account_Creation");
functions = $encore_web_utils:insert_javascript($list_utils:append(help_function, confirmDelete));
menu_buttons = $encore_web_utils:input("single", "Single Account", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "view_html'\""));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("multiple", "Multiple Accounts", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "view_html?batch'\"")));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("edit", "Edit Account", "", "button", "onclick=\"this.form.submit()\""));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("name", "", "10", "text"));
menu = $list_utils:append(help_button, menu_buttons);
menu = $encore_web_utils:form(menu, "search", "/administration_module/find_player");
"=================================";
"== Set up player class section ==";
"=================================";
part1 = $encore_web_utils:input("name", OBJ, "", "hidden");
part1 = $list_utils:append(part1, $encore_web_utils:br("Character Type"));
player_classes = {$guest, $player_class, $builder, $prog, $wiz};
for class in (player_classes)
  class_name = $string_utils:trim($string_utils:substitute(class.name, {{"Generic", ""}}));
  class_name = $string_utils:capitalize(class_name);
  if (class == player_class)
    part1 = $list_utils:append(part1, $encore_web_utils:input("class", toint(class), "", "radio", "", "checked"), {class_name}, {$encore_web_utils:br()});
  else
    part1 = $list_utils:append(part1, $encore_web_utils:input("class", toint(class), "", "radio"), {class_name}, {$encore_web_utils:br()});
  endif
endfor
if (action == {"batch"} || action == {"report"})
  "==============================================";
  "== Form for creating a batch of characters  ==";
  "==============================================";
  part2 = $list_utils:append(part2, $encore_web_utils:p(msg), $encore_web_utils:textarea(account_data, "account_data", "10", "50"), {$encore_web_utils:br()});
  if (action == {"report"})
    if ($network.active)
      part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Email Report to Me", "", "submit"));
    else
      part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "MOOmail Report to Me", "", "submit"));
    endif
    vrb = "mail_report";
  else
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Create Multiple Accounts", "", "submit"));
    vrb = "batch_make_player";
  endif
else
  "============================================================";
  "== Form for making one character, or updating a character ==";
  "============================================================";
  part2 = $list_utils:append(part2, $encore_web_utils:p(msg), $encore_web_utils:input("name", plyr_name, "30", "text"), {" Name"}, {$encore_web_utils:br()});
  part2 = $list_utils:append(part2, $encore_web_utils:input("email_address", email, "30", "text"), {" Email"}, {$encore_web_utils:br()});
  part2 = $list_utils:append(part2, $encore_web_utils:input("real_name", real_name, "30", "text"), {" Real name"}, {$encore_web_utils:br()});
  if (action == {"update"})
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Update account", "", "submit"));
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Delete account", "", "submit"));
    vrb = "update";
  else
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Create New Account", "", "submit"));
    vrb = "create";
  endif
endif
form = $list_utils:append($encore_web_utils:p(), $encore_web_utils:span(part1, "classes"), $encore_web_utils:span(part2, "data"));
form = $encore_web_utils:form(form, "character", tostr("/administration_module/", vrb), "return confirmAction()");
body = $list_utils:append(functions, title, menu, $encore_web_utils:p(), form);
return body;
.

@program $xpress_object_editor:view_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"User wants to edit an object. Check if object exists, is";
"reachable and editable by user.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data, ?alert = ""} = args;
body = data = {};
alert = "self.focus();" + alert;
if (form_data != {{}, {}})
  "User has asked for an object to view";
  requested = form_data[2][1];
  if (valid(object = $string_utils:match_object(requested, user.location, user)) || valid(object = $string_utils:match_object(tostr("#", requested), user.location, user)))
    if ($encore_web_utils:permission_to_edit(user, object))
      body = this:editor_html(user, object);
    else
      alert = tostr("alert('Sorry, you may only work with objects that you own. The object, ", object.name, " belongs to ", object.owner.name, ".')");
    endif
  else
    alert = "alert('Could not find an object by that name. You must either hold an object, or be in the same room as the object in order to refer to it by name.')";
  endif
else
  "If no arguments are passed return user's edit options by default";
  body = this:editor_html(user, user);
endif
result = this:build(user, body, "Xpress Edit", alert);
return result;
.

@program $encore_web_object:examine_html
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Display obvious verbs via Xpress.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = vrbs = help = {};
title = $encore_web_utils:get_subtitle(user, this, tostr("Information about ", this.name));
"List obvious verbs on object";
if (vrbs = this:examine_verbs(user))
  vrbs = $list_utils:append($encore_web_utils:p("Here are some of the things you can do with this object. Type the obvious verbs shown here into the Xpress talk area. The word \"anything\" should be substituted for a valid object name."), $encore_web_utils:preformat(vrbs));
endif
if ($object_utils:has_property(this, "help_msg"))
  "Add help on object";
  help = $list_utils:append(body, $encore_web_utils:get_text_linebreak(this.help_msg));
endif
body = $list_utils:append(title, vrbs, help);
result = this:build(user, body, "Examine", "self.focus()");
return result;
.

;#0.("core_history") = {{"enCore 4.0.1", "1.8.1", 1074538820}, {"enCore 4.0", "1.8.1", 1073061410}, {"enCore enCore 3.3.4", "1.8.1", 1069049189}, {"enCore enCore 3.3.3", "1.8.1", 1043507175}, {"enCore 3.3.2", "1.8.1", 1041824617}, {"enCore 3.3.1", "1.8.1", 1040185243}, {"enCore 3.3", "1.8.1", 1040053857}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}

@set #0.core_version to "4.0.1"