/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class UserOutputArea
extends Panel
implements Runnable {
    private TextArea outputArea;
    private PipedOutputStream outputStream;
    private PipedInputStream inputStream;
    private BufferedReader in;
    private BufferedInputStream buffIn;
    private Thread userOutputThread = new Thread((Runnable)this, "UserOutput");
    private CommandTextField inputArea;
    int maxHistoryLength = 22000;
    int maxMaxHistoryLength = this.maxHistoryLength + 2000;
    private int numberOfRows;
    String history = new String("");
    String buffer = new String("");
    private boolean ancientAWT;

    UserOutputArea(Font font, CommandTextField commandTextField) {
        this.inputArea = commandTextField;
        try {
            this.outputArea = new TextArea("", 0, 0, 1);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.outputArea = new TextArea("");
            this.ancientAWT = true;
        }
        this.outputArea.setFont(font);
        this.outputArea.setBackground(Color.white);
        this.outputArea.setEditable(false);
        this.inputStream = new PipedInputStream();
        try {
            this.outputStream = new PipedOutputStream(this.inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.buffIn = new BufferedInputStream(this.inputStream);
        this.in = new BufferedReader(new InputStreamReader(this.buffIn));
        this.userOutputThread.start();
        this.setLayout(new BorderLayout());
        this.add("Center", this.outputArea);
        this.numberOfRows = this.outputArea.getRows();
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void scrollToBottom() {
        if (this.ancientAWT) {
            this.outputArea.select(this.maxMaxHistoryLength, this.maxMaxHistoryLength);
            this.inputArea.requestFocus();
        } else {
            try {
                this.outputArea.setCaretPosition(this.maxMaxHistoryLength);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private synchronized void refreshScreen() {
        this.history = this.history + this.buffer;
        if (this.history.length() >= this.maxMaxHistoryLength) {
            this.history = this.history.substring(this.history.length() - this.maxHistoryLength);
            this.history = this.history.substring(this.history.indexOf("\n") + 1, this.history.length());
            this.outputArea.replaceRange(this.history, 0, this.outputArea.getText().length());
        } else {
            this.outputArea.append(this.buffer);
        }
        this.buffer = "";
        this.scrollToBottom();
    }

    public void run() {
        this.buffer = this.outputArea.getText();
        this.refreshScreen();
        try {
            String string;
            while ((string = this.in.readLine()) != null) {
                this.buffer = this.buffer + "\n" + string;
                while (this.buffIn.available() > 0) {
                    string = this.in.readLine();
                    this.buffer = this.buffer + "\n" + string;
                }
                this.refreshScreen();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

