/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

/*
//  setpar.c
//
//  This is a replacement for the SETPAR.f FORTRAN-callable subroutine.
//  It sets the number of bits per word (kbit), 
//  and the largest negative number (kneg).
//  The diagnostic print option is no longer supported (kpar).
//
*/
#include <limits.h>
#include "fortint.h"

void setpar_(fortint * kbit, fortint * kneg, fortint * kpar)
{
    *kbit = sizeof(fortint)*8 ;
#ifdef INTEGER_IS_INT
    *kneg = INT_MIN ;
#else
    *kneg = LONG_MIN ;
#endif
    return;
}

void setpar(fortint * kbit, fortint * kneg, fortint * kpar) {

  setpar_(kbit,kneg,kpar);
}
