/* articulations.c 
 * Implements articulation markings which are not notes 
 *
 * A Tee  (c) 2000, 2001
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chordops.h"
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "datastructures.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"
#include "articulations.h"


struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *combobox;
};

static gchar *gen_articulations[10] =
  { "staccato", "staccatissimo", "marcato", "accent", "fermata",
  "tenuto", "turn", "reverse turn",
  "trill", "mordent"
};

static gchar *string_articulations[2] = { "up bow", "down bow" };

static gchar *organ_articulations[4] = { "rheel", "lheel", "ltoe", "rtoe" };


static void
insert_artic (GtkWidget * widget, gpointer data)
{
  mudelaobject *mudelaobj;
  struct callbackdata *cbdata = data;
  struct scoreinfo *si = cbdata->si;
  gchar *articulationstring =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combobox)->entry));

  mudelaobj = si->currentobject ? si->currentobject->data : NULL;

  if (mudelaobj)
    set_articulation (articulationstring, mudelaobj);


  /*object_insert (si, dynamic_new (directivestring)); */
  gtk_widget_draw (si->scorearea, NULL);
}




void
insert_articulation (gpointer callback_data, guint callback_action,
		     GtkWidget * widget)
{
  int i;
  struct scoreinfo *si = callback_data;
  static struct callbackdata cbdata;
  GtkWidget *dialog;
  GtkWidget *combo;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  GtkWidget *label;
  GList *articulationlist = NULL;


  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Insert Articulation"));


  label = gtk_label_new (_("Insert Articulation"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);

  combo = gtk_combo_new ();
  if (callback_action == GENERAL)
    {

      if (!articulationlist)
	for (i = 0; i < 10; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      gen_articulations[i]);
	  }
    }
  else if (callback_action == STRING)
    {
      if (!articulationlist)
	for (i = 0; i < 2; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      string_articulations[i]);
	  }
    }
  else if (callback_action == ORGAN)
    {
      if (!articulationlist)
	for (i = 0; i < 4; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      organ_articulations[i]);
	  }
    }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), articulationlist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), "");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), combo,
		      TRUE, TRUE, 0);
  gtk_widget_show (combo);



  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.combobox = combo;
  processenter (GTK_COMBO (combo)->entry, insert_artic, cbdata, dialog);
  gtk_signal_connect (GTK_OBJECT (okbutton), _("clicked"),
		      GTK_SIGNAL_FUNC (insert_artic), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), _("clicked"),
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), _("clicked"),
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);
  gtk_widget_grab_focus (combo);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}


int
set_articulation (gchar * string, mudelaobject * obj)
{
  if (obj->type == CHORD && obj->u.chordval.tones)
    {
      if (!strcmp (string, "staccato"))
	obj->u.chordval.has_stacatto_p = !obj->u.chordval.has_stacatto_p;
      else if (!strcmp (string, "tenuto"))
	obj->u.chordval.has_tenuto_p = !obj->u.chordval.has_tenuto_p;
      else if (!strcmp (string, "staccatissimo"))
	obj->u.chordval.has_staccatissimo_p =
	  !obj->u.chordval.has_staccatissimo_p;
      else if (!strcmp (string, "accent"))
	obj->u.chordval.is_accented_p = !obj->u.chordval.is_accented_p;
      else if (!strcmp (string, "marcato"))
	obj->u.chordval.has_marcato_p = !obj->u.chordval.has_marcato_p;
      else if (!strcmp (string, "fermata"))
	obj->u.chordval.has_fermata_p = !obj->u.chordval.has_fermata_p;
      else if (!strcmp (string, "trill"))
	obj->u.chordval.has_trill_p = !obj->u.chordval.has_trill_p;
      else if (!strcmp (string, "turn"))
	obj->u.chordval.has_turn_p = !obj->u.chordval.has_turn_p;
      else if (!strcmp (string, "mordent"))
	obj->u.chordval.has_mordent_p = !obj->u.chordval.has_mordent_p;
      else if (!strcmp (string, "reverse turn"))
	obj->u.chordval.has_turn_p = !obj->u.chordval.has_turn_p;
      /* String specific articulations */
      else if (!strcmp (string, "up bow"))
	obj->u.chordval.has_ubow_p = !obj->u.chordval.has_ubow_p;
      else if (!strcmp (string, "down bow"))
	obj->u.chordval.has_dbow_p = !obj->u.chordval.has_dbow_p;
      /*organ articulations */
      else if (!strcmp (string, "rheel"))
	obj->u.chordval.has_rheel_p = !obj->u.chordval.has_rheel_p;
      else if (!strcmp (string, "lheel"))
	obj->u.chordval.has_lheel_p = !obj->u.chordval.has_lheel_p;
      else if (!strcmp (string, "rtoe"))
	obj->u.chordval.has_rtoe_p = !obj->u.chordval.has_rtoe_p;
      else if (!strcmp (string, "ltoe"))
	obj->u.chordval.has_ltoe_p = !obj->u.chordval.has_ltoe_p;
    }
  else
    return -1;

  return 0;
}
