;;; skk-ffh.el --- SKK find-file hook
;; Copyright (C) 2003 NAKAJIMA Mikio <minakaji@namazu.org>

;; Author: NAKAJIMA Mikio <minakaji@namazu.org>
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: $Id: skk-ffh.el,v 0.00 2003/07/19 00:56:38 minakaji Exp $
;; Keywords: japanese
;; Created: Jul. 22, 2003
;; Last Modified: $Date: 2003/07/19 00:56:38 $

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.

;; Daredevil SKK is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:
;;
;; <How to install>
;;
;; ~/.skk $B$K(B
;;
;;   (require 'skk-ffh)
;;
;; $B$H=q$$$F2<$5$$!#(Bskk-study.el $B$rJ;MQ$9$k$J$i$P(B (require 'skk-study)
;; $B$N8e$K(B (require 'skk-ffh) $B$r=q$/$h$&$K$7$F2<$5$$!#(B
;;
;; <TODO>
;;

;;; Code:
(eval-when-compile
  (require 'cl)
  (require 'skk-study))

(defcustom skk-ffh-autoselect-study-limit 3000
  "* skk-study $B$N(B theme $B$r7h$a$k$?$a$K(B `find-file' $B$7$?%P%C%U%!$G$I$3$^$G(B kakasi $B$GD4$Y$k$+!#(B"
  ;; default $BCM$O$$$$2C8:$JCM!#;n9T:x8m$9$Y$-!#(B
  :type 'integer)

(defcustom skk-ffh-study-min-match 20
  "*skk-study $B$N(B theme $B7h$a$N$?$a$K(B kakasi $B$GJL$A=q$-$7$FD4$Y$?C18l$,:GDc$$$/$D%^%C%A$7$J$1$l$P$J$i$J$$$+!#(B"
  ;; default $BCM$O$$$$2C8:$JCM!#;n9T:x8m$9$Y$-!#(B
  :type 'integer)

(add-hook 'find-file-hook 'skk-ffh-search-kutouten)

(when (and (featurep 'skk-study)
	   (string< "0.2" skk-study-file-format-version))
  (add-hook 'find-file-hook 'skk-ffh-autoselect-study-theme))

(defun skk-ffh-search-kutouten ()
  (save-excursion
    (let (kuten touten)
    ;; fail safe
    (goto-char (point-min))
    (when (re-search-forward "[$B!#!%(B]" nil t nil)
      (setq kuten (match-string 0)))
    (when (re-search-forward "[$B!"!$(B]" nil t nil)
      (setq touten (match-string 0)))
    (cond ((not (or kuten touten))
	   (setq skk-kutouten-type
		 (default-value 'skk-kutouten-type)))
	  ((and kuten (string= kuten "$B!#(B"))
	   (setq skk-kutouten-type 'jp))
	  ((and kuten (string= kuten "$B!%(B"))
	   (setq skk-kutouten-type 'en))
	  ((and touten (string= touten "$B!"(B"))
	   (setq skk-kutouten-type 'jp))
	  ((and touten (string= touten "$B!$(B"))
	   (setq skk-kutouten-type 'en)))
    (cond ((eq skk-kutouten-type 'jp)
	   (skk-message "$B6gFIE@$N%?%$%W$r(B `jp' $B$K%;%C%H$7$^$7$?(B"
			"Set kutouten type to `jp'"))
	  ((eq skk-kutouten-type 'en)
	   (skk-message "$B6gFIE@$N%?%$%W$r(B `en' $B$K%;%C%H$7$^$7$?(B"
			"Set kutouten type to `en'"))))))

(defun skk-ffh-autoselect-study-theme ()
  (unless skk-use-kakasi
    (skk-error "KAKASI $B$,%$%s%9%H!<%k$5$l$F$$$^$;$s(B"
	       "Cannot find KAKASI installed"))
  (unless (string< "0.2" skk-study-file-format-version)
    (skk-error "`skk-study.el' $B$N%P!<%8%g%s$,8E$$$G$9(B"
	       "It seems old version of `skk-study' installed"))
  (when (not (zerop (buffer-size)))
    (let ((wbuf (get-buffer-create " *skk-ffh*"))
	  theme themes)
      (unwind-protect
	  (progn
	    (or skk-study-alist (skk-study-read))
	    (dolist (alist skk-study-alist)
	      (when (and (setq theme (car alist))
			 (stringp theme)
			 (not (string= theme "general")))
		(setq themes (cons theme themes))))
	    (when themes
	      (save-excursion
		(let ((v (call-process-region
			  (point-min)
			  (min (point-max)
			       skk-ffh-autoselect-study-limit)
			  skk-kakasi-command
			  ;; -w option $BHsBP1~$N(B kakasi $B$b$^$@8=Lr(B?
			  nil wbuf nil "-w"))
		      word words alist max)
		  (unless (= v 0)
		    (skk-error "KAKASI $B$N<B9T;~$N%(%i!<$G$9(B"
			       "KAKASI runtime error"))
		  (set-buffer wbuf)
		  (goto-char (point-min))
		  (while (re-search-forward "[^ $B%t$!(B-$B$s%!(B-$B%s(B]+" nil t nil)
		    ;; $B$R$i$,$J!"%+%?%+%J!"(BSPC $B0J30$r@Z$j=P$9!#(B
		    ;; $B?tCMJQ49$KBP1~$7$F$$$J$$(B...$B!#(B
		    (setq words (cons (match-string 0) words)))
		  (let (v1)
		    (dolist (theme themes)
		      (setq alist (cdr
				   (assq
				    'okuri-nasi
				    (cdr (assoc theme skk-study-alist)))))
		      (let ((count 0))
			(dolist (cell alist)
			  (dolist (elm (cdr (car (cdr cell))))
			    ;; $B3X=,%G!<%?$K$+$+$o$i$:!"(Btheme $BKh$KD4$Y(B
			    ;; $B$kC18l$rJL$K%f!<%6$,@_Dj$G$-$k$HJXMx!#(B
			    (when (member elm words)
			      (setq count (incf count)))))
			(setq v1 (cons (cons count theme) v1))))
		    (setq max (apply 'max (mapcar 'car v1)))
		    (when (and (> max skk-ffh-study-min-match)
			       (setq theme (cdr (assq max v1))))
		      (skk-study-switch-current-theme theme)
		      (skk-message
		       "$B%+%l%s%H$N3X=,%F!<%^$r(B %s $B$KJQ99$7$^$7$?(B"
		       "Switch current study theme to %s"
		       theme)))))))
	(kill-buffer wbuf)))))

(require 'product)
(product-provide (provide 'skk-ffh) (require 'skk-version))
;;; skk-ffh.el ends here
