/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: range.h 2528 2011-09-23 21:54:05Z brachman $
 */

#ifndef _RANGE_H_
#define _RANGE_H_

#include <ctype.h>
#include <stdio.h>

#define RANGE_SPAN_SEP_STR		":"
#define RANGE_ELEMENT_MAX_STR		"#"
#define RANGE_ELEMENT_SEP_CHAR	','
#define RANGE_SIGNED_VALUES		1

typedef struct Range_syntax {
  char element_sep_char;
  char *span_sep_str;
  char *element_max_str;
  int signed_values;
} Range_syntax;

#ifdef __cplusplus
extern "C" {
#endif

extern Range_syntax *range_set_default_syntax(Range_syntax *syntax);
extern int range_is_valid(char *range, Range_syntax *syntax, char **errmsg);
extern int range_test(int num, char *range, Range_syntax *syntax,
					  char **errmsg);
extern int range_selftest(FILE *fp);

#ifdef __cplusplus
}
#endif

#endif
