;;; cmail-use-multi-account.el -- use multi accounts

;; Author: ASANO Fumihisa <fasano@mva.biglobe.ne.jp>
;; Keywords: mail
;; Create date:
;; $Id: cmail-use-multi-account.el,v 1.1 2002/07/20 23:09:58 tmp Exp $

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; This file is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:
;; Installation:
;;	Put this line in your ~/.emacs
;;		(setq cmail-use-multi-account t
;;		      cmail-smtp-servers '(("foo" . "foo.smtp.server")
;;                                         ("bar" . "bar.smtp.server")))


;;; Code:
(eval-when-compile (require 'cmail-vars))

(defun cmail-set-multi-account (symbol value)
  (setq cmail-use-multi-account value)
  (when cmail-use-multi-account
    (require 'cmail-multi-account)))


(cmail-i18n-defgroup cmail-use-multi-account-group nil
  ((ja_JP . "$BJ#?t$N%"%+%&%s%H$r;H$C$F%a!<%k$r=P$9$?$a$N@_Dj!#(B")
   (en_US . "Setup for multi account."))
  :group 'cmail-other-features)

(cmail-i18n-defcustom cmail-use-multi-account nil
  ((ja_JP . "*$BJ#?t$N%"%+%&%s%H$r;H$C$F%a!<%k$r=P$9$+$I$&$+!#(B

 $BCM$,(Bnil$B$N$H$-$O;HMQ$7$J$$!#(B")
   (en_US . "*Whether to use multi account.

 if non-nil, use multi account"))
  :type 'boolean
  :set 'cmail-set-multi-account
  :group 'cmail-all-variables
  :group 'cmail-use-multi-account-group)
(cmail-custom-add-init 'cmail-set-multi-account 'cmail-use-multi-account)

(provide 'cmail-use-multi-account)

;;; cmail-use-multi-account.el ends here
